/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.CanonicalPathUtils;
import org.junit.Assert;
import org.junit.Test;

public class CanonicalPathUtilsTestCase {
    @Test
    public void testCanonicalization() {
        Assert.assertSame((Object)"a/b/c", (Object)CanonicalPathUtils.canonicalize((String)"a/b/c"));
        Assert.assertSame((Object)"a/b/c/", (Object)CanonicalPathUtils.canonicalize((String)"a/b/c/"));
        Assert.assertSame((Object)"aaaaa", (Object)CanonicalPathUtils.canonicalize((String)"aaaaa"));
        Assert.assertEquals((Object)"a./b", (Object)CanonicalPathUtils.canonicalize((String)"a./b"));
        Assert.assertEquals((Object)"a./.b", (Object)CanonicalPathUtils.canonicalize((String)"a./.b"));
        Assert.assertEquals((Object)"a/b", (Object)CanonicalPathUtils.canonicalize((String)"a//b"));
        Assert.assertEquals((Object)"a/b", (Object)CanonicalPathUtils.canonicalize((String)"a///b"));
        Assert.assertEquals((Object)"a/b", (Object)CanonicalPathUtils.canonicalize((String)"a////b"));
        Assert.assertEquals((Object)"a/b", (Object)CanonicalPathUtils.canonicalize((String)"a/./b"));
        Assert.assertEquals((Object)"a/b", (Object)CanonicalPathUtils.canonicalize((String)"a/././b"));
        Assert.assertEquals((Object)"a/b/c", (Object)CanonicalPathUtils.canonicalize((String)"a/./b/./c"));
        Assert.assertEquals((Object)"a/b", (Object)CanonicalPathUtils.canonicalize((String)"a/./././b"));
        Assert.assertEquals((Object)"a/b/", (Object)CanonicalPathUtils.canonicalize((String)"a/./././b/./"));
        Assert.assertEquals((Object)"a/b", (Object)CanonicalPathUtils.canonicalize((String)"a/./././b/."));
        Assert.assertEquals((Object)"/b", (Object)CanonicalPathUtils.canonicalize((String)"/a/../b"));
        Assert.assertEquals((Object)"/b", (Object)CanonicalPathUtils.canonicalize((String)"/a/../c/../e/../b"));
        Assert.assertEquals((Object)"/b", (Object)CanonicalPathUtils.canonicalize((String)"/a/c/../../b"));
        Assert.assertEquals((Object)"/", (Object)CanonicalPathUtils.canonicalize((String)"/a/../.."));
        Assert.assertEquals((Object)"/foo", (Object)CanonicalPathUtils.canonicalize((String)"/a/../../foo"));
        Assert.assertEquals((Object)"/a/", (Object)CanonicalPathUtils.canonicalize((String)"/a/"));
        Assert.assertEquals((Object)"/", (Object)CanonicalPathUtils.canonicalize((String)"/"));
        Assert.assertEquals((Object)"/bbb/a", (Object)CanonicalPathUtils.canonicalize((String)"/cc/../bbb/a/."));
        Assert.assertEquals((Object)"/aaa/bbb/", (Object)CanonicalPathUtils.canonicalize((String)"/aaa/bbb//////"));
    }
}

