/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.testutils;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.alpn.ALPNManager;
import io.undertow.protocols.alpn.ALPNProvider;
import io.undertow.protocols.alpn.JettyAlpnProvider;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.security.impl.GSSAPIAuthenticationMechanism;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.DelegateOpenListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.OpenListener;
import io.undertow.server.handlers.ProxyPeerAddressHandler;
import io.undertow.server.handlers.RequestDumpingHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.SSLHeaderHandler;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.server.protocol.ajp.AjpOpenListener;
import io.undertow.server.protocol.http.AlpnOpenListener;
import io.undertow.server.protocol.http.HttpOpenListener;
import io.undertow.server.protocol.http2.Http2OpenListener;
import io.undertow.server.protocol.http2.Http2UpgradeHandler;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.DebuggingSlicePool;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.testutils.HttpsIgnore;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.Headers;
import io.undertow.util.NetworkUtils;
import io.undertow.util.SingleByteStreamSinkConduit;
import io.undertow.util.SingleByteStreamSourceConduit;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.channels.Channel;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.wildfly.openssl.OpenSSLProvider;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.ssl.XnioSsl;

public class DefaultServer
extends BlockJUnit4ClassRunner {
    private static final Throwable OPENSSL_FAILURE;
    static final String DEFAULT = "default";
    private static final int PROXY_OFFSET = 1111;
    public static final int APACHE_PORT = 9080;
    public static final int APACHE_SSL_PORT = 9443;
    public static final int BUFFER_SIZE;
    public static final DebuggingSlicePool SSL_BUFFER_POOL;
    private static boolean first;
    private static OptionMap serverOptions;
    private static OpenListener openListener;
    private static ChannelListener acceptListener;
    private static OpenListener proxyOpenListener;
    private static ChannelListener proxyAcceptListener;
    private static XnioWorker worker;
    private static AcceptingChannel<? extends StreamConnection> server;
    private static AcceptingChannel<? extends StreamConnection> proxyServer;
    private static AcceptingChannel<? extends StreamConnection> sslServer;
    private static SSLContext clientSslContext;
    private static Xnio xnio;
    private static final String SERVER_KEY_STORE = "server.keystore";
    private static final String SERVER_TRUST_STORE = "server.truststore";
    private static final String CLIENT_KEY_STORE = "client.keystore";
    private static final String CLIENT_TRUST_STORE = "client.truststore";
    private static final char[] STORE_PASSWORD;
    private static final boolean ajp;
    private static final boolean h2;
    private static final boolean h2c;
    private static final boolean h2cUpgrade;
    private static final boolean https;
    private static final boolean proxy;
    private static final boolean apache;
    private static final boolean dump;
    private static final boolean single;
    private static final boolean openssl;
    private static final int runs;
    private static final DelegatingHandler rootHandler;
    private static final DebuggingSlicePool pool;
    private static Boolean alpnEnabled;

    private static KeyStore loadKeyStore(String name) throws IOException {
        InputStream stream = DefaultServer.class.getClassLoader().getResourceAsStream(name);
        try {
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(stream, STORE_PASSWORD);
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IOException(String.format("Unable to load KeyStore %s", name), e);
        }
        finally {
            IoUtils.safeClose((Closeable)stream);
        }
    }

    private static SSLContext createSSLContext(KeyStore keyStore, KeyStore trustStore, boolean client) throws IOException {
        SSLContext sslContext;
        KeyManager[] keyManagers;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, STORE_PASSWORD);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IOException("Unable to initialise KeyManager[]", e);
        }
        TrustManager[] trustManagers = null;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new IOException("Unable to initialise TrustManager[]", e);
        }
        try {
            sslContext = openssl && !client ? SSLContext.getInstance("openssl.TLS") : SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IOException("Unable to create and initialise the SSLContext", e);
        }
        return sslContext;
    }

    public static String getDefaultServerURL() {
        return "http://" + NetworkUtils.formatPossibleIpv6Address((String)DefaultServer.getHostAddress(DEFAULT)) + ":" + DefaultServer.getHostPort(DEFAULT);
    }

    public static InetSocketAddress getDefaultServerAddress() {
        return new InetSocketAddress(DefaultServer.getHostAddress(DEFAULT), DefaultServer.getHostPort(DEFAULT));
    }

    public static String getDefaultServerSSLAddress() {
        if (sslServer == null && !DefaultServer.isApacheTest()) {
            throw new IllegalStateException("SSL Server not started.");
        }
        return "https://" + NetworkUtils.formatPossibleIpv6Address((String)DefaultServer.getHostAddress(DEFAULT)) + ":" + DefaultServer.getHostSSLPort(DEFAULT);
    }

    public DefaultServer(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public static void setupProxyHandlerForSSL(ProxyHandler proxyHandler) {
        proxyHandler.addRequestHeader(Headers.SSL_CLIENT_CERT, "%{SSL_CLIENT_CERT}", DefaultServer.class.getClassLoader());
        proxyHandler.addRequestHeader(Headers.SSL_CIPHER, "%{SSL_CIPHER}", DefaultServer.class.getClassLoader());
        proxyHandler.addRequestHeader(Headers.SSL_SESSION_ID, "%{SSL_SESSION_ID}", DefaultServer.class.getClassLoader());
    }

    public static ByteBufferPool getBufferPool() {
        return pool;
    }

    public Description getDescription() {
        return super.getDescription();
    }

    public void run(final RunNotifier notifier) {
        notifier.addListener(new RunListener(){

            public void testStarted(Description description) throws Exception {
                DebuggingSlicePool.currentLabel = description.getClassName() + "." + description.getMethodName();
                super.testStarted(description);
            }

            public void testFinished(Description description) throws Exception {
                if (!DebuggingSlicePool.BUFFERS.isEmpty()) {
                    try {
                        Thread.sleep(200L);
                        if (!DebuggingSlicePool.BUFFERS.isEmpty()) {
                            Thread.sleep(2000L);
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    for (DebuggingSlicePool.DebuggingBuffer b : DebuggingSlicePool.BUFFERS) {
                        b.getAllocationPoint().printStackTrace();
                        notifier.fireTestFailure(new Failure(description, (Throwable)new RuntimeException("Buffer Leak " + b.getLabel(), b.getAllocationPoint())));
                    }
                    DebuggingSlicePool.BUFFERS.clear();
                }
                super.testFinished(description);
            }
        });
        DefaultServer.runInternal(notifier);
        super.run(notifier);
    }

    private static void runInternal(RunNotifier notifier) {
        if (openssl && OPENSSL_FAILURE != null) {
            throw new RuntimeException(OPENSSL_FAILURE);
        }
        if (first) {
            first = false;
            xnio = Xnio.getInstance((String)"nio", (ClassLoader)DefaultServer.class.getClassLoader());
            try {
                worker = xnio.createWorker(OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, 30).set(Options.WORKER_TASK_MAX_THREADS, 30).set(Options.TCP_NODELAY, true).set(Options.CORK, true).getMap());
                serverOptions = OptionMap.builder().set(Options.TCP_NODELAY, true).set(Options.BACKLOG, 1000).set(Options.REUSE_ADDRESSES, true).set(Options.BALANCING_TOKENS, 1).set(Options.BALANCING_CONNECTIONS, 2).getMap();
                SSLContext serverContext = DefaultServer.createSSLContext(DefaultServer.loadKeyStore(SERVER_KEY_STORE), DefaultServer.loadKeyStore(SERVER_TRUST_STORE), false);
                UndertowXnioSsl ssl = new UndertowXnioSsl(worker.getXnio(), OptionMap.EMPTY, (ByteBufferPool)SSL_BUFFER_POOL, serverContext);
                if (ajp) {
                    openListener = new AjpOpenListener((ByteBufferPool)pool);
                    acceptListener = ChannelListeners.openListenerAdapter(DefaultServer.wrapOpenListener((ChannelListener<StreamConnection>)openListener));
                    if (apache) {
                        int port = 8888;
                        server = worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), port), acceptListener, serverOptions);
                    } else {
                        server = worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), 8888), acceptListener, serverOptions);
                        proxyOpenListener = new HttpOpenListener((ByteBufferPool)pool, OptionMap.create((Option)UndertowOptions.BUFFER_PIPELINED_DATA, (Object)true));
                        proxyAcceptListener = ChannelListeners.openListenerAdapter(DefaultServer.wrapOpenListener((ChannelListener<StreamConnection>)proxyOpenListener));
                        proxyServer = worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), DefaultServer.getHostPort(DEFAULT)), proxyAcceptListener, serverOptions);
                        proxyOpenListener.setRootHandler((HttpHandler)new ProxyHandler((ProxyClient)new LoadBalancingProxyClient(GSSAPIAuthenticationMechanism.EXCLUSIVITY_CHECKER).addHost(new URI("ajp", null, DefaultServer.getHostAddress(DEFAULT), DefaultServer.getHostPort(DEFAULT) + 1111, "/", null, null)), 120000, (HttpHandler)ResponseCodeHandler.HANDLE_404));
                        proxyServer.resumeAccepts();
                    }
                } else if (h2 && DefaultServer.isAlpnEnabled()) {
                    openListener = new Http2OpenListener((ByteBufferPool)pool, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true, (Option)UndertowOptions.HTTP2_PADDING_SIZE, (Object)10));
                    acceptListener = ChannelListeners.openListenerAdapter(DefaultServer.wrapOpenListener((ChannelListener<StreamConnection>)new AlpnOpenListener((ByteBufferPool)pool).addProtocol("h2", (DelegateOpenListener)openListener, 10)));
                    SSLContext clientContext = DefaultServer.createSSLContext(DefaultServer.loadKeyStore(CLIENT_KEY_STORE), DefaultServer.loadKeyStore(CLIENT_TRUST_STORE), true);
                    server = ssl.createSslConnectionServer(worker, new InetSocketAddress(DefaultServer.getHostAddress(DEFAULT), 8888), acceptListener, serverOptions);
                    server.resumeAccepts();
                    proxyOpenListener = new HttpOpenListener((ByteBufferPool)pool, OptionMap.create((Option)UndertowOptions.BUFFER_PIPELINED_DATA, (Object)true));
                    proxyAcceptListener = ChannelListeners.openListenerAdapter(DefaultServer.wrapOpenListener((ChannelListener<StreamConnection>)proxyOpenListener));
                    proxyServer = worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), DefaultServer.getHostPort(DEFAULT)), proxyAcceptListener, serverOptions);
                    ProxyHandler proxyHandler = new ProxyHandler((ProxyClient)new LoadBalancingProxyClient(GSSAPIAuthenticationMechanism.EXCLUSIVITY_CHECKER).addHost(new URI("h2", null, DefaultServer.getHostAddress(DEFAULT), DefaultServer.getHostPort(DEFAULT) + 1111, "/", null, null), null, (XnioSsl)new UndertowXnioSsl(xnio, OptionMap.EMPTY, (ByteBufferPool)SSL_BUFFER_POOL, clientContext), OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true)), 120000, (HttpHandler)ResponseCodeHandler.HANDLE_404);
                    DefaultServer.setupProxyHandlerForSSL(proxyHandler);
                    proxyOpenListener.setRootHandler((HttpHandler)proxyHandler);
                    proxyServer.resumeAccepts();
                } else if (h2c || h2cUpgrade) {
                    openListener = new HttpOpenListener((ByteBufferPool)pool, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true, (Option)UndertowOptions.HTTP2_PADDING_SIZE, (Object)10));
                    acceptListener = ChannelListeners.openListenerAdapter(DefaultServer.wrapOpenListener((ChannelListener<StreamConnection>)openListener));
                    InetSocketAddress targetAddress = new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), DefaultServer.getHostPort(DEFAULT) + 1111);
                    server = worker.createStreamConnectionServer((SocketAddress)targetAddress, acceptListener, serverOptions);
                    proxyOpenListener = new HttpOpenListener((ByteBufferPool)pool, OptionMap.create((Option)UndertowOptions.BUFFER_PIPELINED_DATA, (Object)true));
                    proxyAcceptListener = ChannelListeners.openListenerAdapter(DefaultServer.wrapOpenListener((ChannelListener<StreamConnection>)proxyOpenListener));
                    proxyServer = worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), DefaultServer.getHostPort(DEFAULT)), proxyAcceptListener, serverOptions);
                    ProxyHandler proxyHandler = new ProxyHandler((ProxyClient)new LoadBalancingProxyClient(GSSAPIAuthenticationMechanism.EXCLUSIVITY_CHECKER).addHost(new URI(h2cUpgrade ? "http" : "h2c-prior", null, DefaultServer.getHostAddress(DEFAULT), DefaultServer.getHostPort(DEFAULT) + 1111, "/", null, null), null, null, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true)), 30000, (HttpHandler)ResponseCodeHandler.HANDLE_404);
                    DefaultServer.setupProxyHandlerForSSL(proxyHandler);
                    proxyOpenListener.setRootHandler((HttpHandler)proxyHandler);
                    proxyServer.resumeAccepts();
                } else if (https) {
                    UndertowXnioSsl clientSsl = new UndertowXnioSsl(xnio, OptionMap.EMPTY, (ByteBufferPool)SSL_BUFFER_POOL, DefaultServer.createClientSslContext());
                    openListener = new HttpOpenListener((ByteBufferPool)pool, OptionMap.create((Option)UndertowOptions.BUFFER_PIPELINED_DATA, (Object)true));
                    acceptListener = ChannelListeners.openListenerAdapter(DefaultServer.wrapOpenListener((ChannelListener<StreamConnection>)openListener));
                    server = ssl.createSslConnectionServer(worker, new InetSocketAddress(DefaultServer.getHostAddress(DEFAULT), 8888), acceptListener, serverOptions);
                    server.getAcceptSetter().set(acceptListener);
                    server.resumeAccepts();
                    proxyOpenListener = new HttpOpenListener((ByteBufferPool)pool, OptionMap.create((Option)UndertowOptions.BUFFER_PIPELINED_DATA, (Object)true));
                    proxyAcceptListener = ChannelListeners.openListenerAdapter(DefaultServer.wrapOpenListener((ChannelListener<StreamConnection>)proxyOpenListener));
                    proxyServer = worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), DefaultServer.getHostPort(DEFAULT)), proxyAcceptListener, serverOptions);
                    ProxyHandler proxyHandler = new ProxyHandler((ProxyClient)new LoadBalancingProxyClient(GSSAPIAuthenticationMechanism.EXCLUSIVITY_CHECKER).addHost(new URI("https", null, DefaultServer.getHostAddress(DEFAULT), DefaultServer.getHostPort(DEFAULT) + 1111, "/", null, null), (XnioSsl)clientSsl), 30000, (HttpHandler)ResponseCodeHandler.HANDLE_404);
                    DefaultServer.setupProxyHandlerForSSL(proxyHandler);
                    proxyOpenListener.setRootHandler((HttpHandler)proxyHandler);
                    proxyServer.resumeAccepts();
                } else {
                    if (h2) {
                        UndertowLogger.ROOT_LOGGER.error((Object)"HTTP2 selected but Netty ALPN was not on the boot class path");
                    }
                    openListener = new HttpOpenListener((ByteBufferPool)pool, OptionMap.create((Option)UndertowOptions.BUFFER_PIPELINED_DATA, (Object)true, (Option)UndertowOptions.ENABLE_CONNECTOR_STATISTICS, (Object)true));
                    acceptListener = ChannelListeners.openListenerAdapter(DefaultServer.wrapOpenListener((ChannelListener<StreamConnection>)openListener));
                    if (!proxy) {
                        server = worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), DefaultServer.getHostPort(DEFAULT)), acceptListener, serverOptions);
                    } else {
                        InetSocketAddress targetAddress = new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), DefaultServer.getHostPort(DEFAULT) + 1111);
                        server = worker.createStreamConnectionServer((SocketAddress)targetAddress, acceptListener, serverOptions);
                        proxyOpenListener = new HttpOpenListener((ByteBufferPool)pool, OptionMap.create((Option)UndertowOptions.BUFFER_PIPELINED_DATA, (Object)true));
                        proxyAcceptListener = ChannelListeners.openListenerAdapter(DefaultServer.wrapOpenListener((ChannelListener<StreamConnection>)proxyOpenListener));
                        proxyServer = worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), DefaultServer.getHostPort(DEFAULT)), proxyAcceptListener, serverOptions);
                        ProxyHandler proxyHandler = new ProxyHandler((ProxyClient)new LoadBalancingProxyClient(GSSAPIAuthenticationMechanism.EXCLUSIVITY_CHECKER).addHost(new URI("http", null, DefaultServer.getHostAddress(DEFAULT), DefaultServer.getHostPort(DEFAULT) + 1111, "/", null, null)), 30000, (HttpHandler)ResponseCodeHandler.HANDLE_404);
                        DefaultServer.setupProxyHandlerForSSL(proxyHandler);
                        proxyOpenListener.setRootHandler((HttpHandler)proxyHandler);
                        proxyServer.resumeAccepts();
                    }
                }
                if (h2cUpgrade) {
                    openListener.setRootHandler((HttpHandler)new Http2UpgradeHandler((HttpHandler)rootHandler));
                } else {
                    openListener.setRootHandler((HttpHandler)rootHandler);
                }
                server.resumeAccepts();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            notifier.addListener(new RunListener(){

                public void testRunFinished(Result result) throws Exception {
                    server.close();
                    DefaultServer.stopSSLServer();
                    worker.shutdown();
                }
            });
        }
    }

    protected Description describeChild(FrameworkMethod method) {
        if (runs > 1 && method.getAnnotation(Ignore.class) == null) {
            return this.describeRepeatTest(method);
        }
        return super.describeChild(method);
    }

    private Description describeRepeatTest(FrameworkMethod method) {
        Description description = Description.createSuiteDescription((String)(this.testName(method) + " [" + runs + " times]"), (Annotation[])method.getAnnotations());
        for (int i = 1; i <= runs; ++i) {
            description.addChild(Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)("[" + i + "] " + this.testName(method))));
        }
        return description;
    }

    private static ChannelListener<StreamConnection> wrapOpenListener(final ChannelListener<StreamConnection> listener) {
        if (!single) {
            return listener;
        }
        return new ChannelListener<StreamConnection>(){

            public void handleEvent(StreamConnection channel) {
                channel.getSinkChannel().setConduit((StreamSinkConduit)new SingleByteStreamSinkConduit(channel.getSinkChannel().getConduit(), 10000));
                channel.getSourceChannel().setConduit((StreamSourceConduit)new SingleByteStreamSourceConduit(channel.getSourceChannel().getConduit(), 10000));
                listener.handleEvent((Channel)channel);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        AjpIgnore ajpIgnore = (AjpIgnore)method.getAnnotation(AjpIgnore.class);
        if (ajpIgnore == null) {
            ajpIgnore = method.getMethod().getDeclaringClass().getAnnotation(AjpIgnore.class);
        }
        if (ajp && ajpIgnore != null && (apache || !ajpIgnore.apacheOnly())) {
            notifier.fireTestIgnored(this.describeChild(method));
            return;
        }
        if (h2 || h2c || ajp || h2cUpgrade) {
            HttpOneOnly httpOneOnly = (HttpOneOnly)method.getAnnotation(HttpOneOnly.class);
            if (httpOneOnly == null) {
                httpOneOnly = method.getMethod().getDeclaringClass().getAnnotation(HttpOneOnly.class);
            }
            if (httpOneOnly != null) {
                notifier.fireTestIgnored(this.describeChild(method));
                return;
            }
            if (h2) {
                DefaultServer.assumeAlpnEnabled();
            }
        }
        if (https) {
            HttpsIgnore httpsIgnore = (HttpsIgnore)method.getAnnotation(HttpsIgnore.class);
            if (httpsIgnore == null) {
                httpsIgnore = method.getMethod().getDeclaringClass().getAnnotation(HttpsIgnore.class);
            }
            if (httpsIgnore != null) {
                notifier.fireTestIgnored(this.describeChild(method));
                return;
            }
        }
        if (DefaultServer.isProxy() && (method.getAnnotation(ProxyIgnore.class) != null || method.getMethod().getDeclaringClass().isAnnotationPresent(ProxyIgnore.class) || this.getTestClass().getJavaClass().isAnnotationPresent(ProxyIgnore.class))) {
            notifier.fireTestIgnored(this.describeChild(method));
            return;
        }
        try {
            if (runs > 1) {
                Statement statement = this.methodBlock(method);
                Description description = this.describeChild(method);
                for (Description desc : description.getChildren()) {
                    this.runLeaf(statement, desc, notifier);
                }
            } else {
                super.runChild(method, notifier);
            }
        }
        finally {
            TestHttpClient.afterTest();
        }
    }

    protected String testName(FrameworkMethod method) {
        if (!DefaultServer.isProxy()) {
            return super.testName(method);
        }
        StringBuilder sb = new StringBuilder(super.testName(method));
        if (DefaultServer.isProxy()) {
            sb.append("{proxy}");
        }
        if (ajp) {
            sb.append("{ajp}");
        }
        if (https) {
            sb.append("{https}");
        }
        if (h2) {
            sb.append("{http2}");
        }
        if (h2c) {
            sb.append("{http2-clear}");
        }
        if (h2cUpgrade) {
            sb.append("{http2-clear-upgrade}");
        }
        return sb.toString();
    }

    public static void setRootHandler(HttpHandler handler) {
        if (DefaultServer.isProxy() && !ajp) {
            handler = new SSLHeaderHandler((HttpHandler)new ProxyPeerAddressHandler(handler));
        }
        DefaultServer.rootHandler.next = dump ? new RequestDumpingHandler(handler) : handler;
    }

    public static SSLContext getClientSSLContext() {
        if (clientSslContext == null) {
            clientSslContext = DefaultServer.createClientSslContext();
        }
        return clientSslContext;
    }

    public static void startSSLServer() throws IOException {
        SSLContext serverContext = DefaultServer.getServerSslContext();
        DefaultServer.getClientSSLContext();
        DefaultServer.startSSLServer(serverContext, OptionMap.create((Option)Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUESTED));
    }

    public static SSLContext createClientSslContext() {
        try {
            return DefaultServer.createSSLContext(DefaultServer.loadKeyStore(CLIENT_KEY_STORE), DefaultServer.loadKeyStore(CLIENT_TRUST_STORE), true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static SSLContext getServerSslContext() {
        try {
            return DefaultServer.createSSLContext(DefaultServer.loadKeyStore(SERVER_KEY_STORE), DefaultServer.loadKeyStore(SERVER_TRUST_STORE), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void startSSLServer(OptionMap optionMap) throws IOException {
        SSLContext serverContext = DefaultServer.getServerSslContext();
        clientSslContext = DefaultServer.createClientSslContext();
        DefaultServer.startSSLServer(optionMap, proxyAcceptListener != null ? proxyAcceptListener : acceptListener);
    }

    public static void startSSLServer(OptionMap optionMap, ChannelListener openListener) throws IOException {
        SSLContext serverContext = DefaultServer.createSSLContext(DefaultServer.loadKeyStore(SERVER_KEY_STORE), DefaultServer.loadKeyStore(SERVER_TRUST_STORE), false);
        clientSslContext = DefaultServer.createSSLContext(DefaultServer.loadKeyStore(CLIENT_KEY_STORE), DefaultServer.loadKeyStore(CLIENT_TRUST_STORE), true);
        DefaultServer.startSSLServer(serverContext, optionMap, openListener);
    }

    public static void startSSLServer(SSLContext context, OptionMap options) throws IOException {
        DefaultServer.startSSLServer(context, options, proxyAcceptListener != null ? proxyAcceptListener : acceptListener);
    }

    public static void startSSLServer(SSLContext context, OptionMap options, ChannelListener openListener) throws IOException {
        DefaultServer.startSSLServer(context, options, openListener, DefaultServer.getHostSSLPort(DEFAULT));
    }

    public static void startSSLServer(SSLContext context, OptionMap options, ChannelListener openListener, int port) throws IOException {
        if (DefaultServer.isApacheTest()) {
            return;
        }
        OptionMap combined = OptionMap.builder().addAll(serverOptions).addAll(options).set(Options.USE_DIRECT_BUFFERS, true).getMap();
        UndertowXnioSsl ssl = new UndertowXnioSsl(worker.getXnio(), OptionMap.EMPTY, (ByteBufferPool)SSL_BUFFER_POOL, context);
        sslServer = ssl.createSslConnectionServer(worker, new InetSocketAddress(DefaultServer.getHostAddress(DEFAULT), port), openListener, combined);
        sslServer.getAcceptSetter().set(openListener);
        sslServer.resumeAccepts();
    }

    private static boolean isApacheTest() {
        return apache;
    }

    public static void stopSSLServer() throws IOException {
        if (sslServer != null) {
            sslServer.close();
            sslServer = null;
        }
        clientSslContext = null;
    }

    public static String getHostAddress(String serverName) {
        return System.getProperty(serverName + ".server.address", "localhost");
    }

    public static String getHostAddress() {
        return DefaultServer.getHostAddress(DEFAULT);
    }

    public static int getHostPort(String serverName) {
        if (DefaultServer.isApacheTest()) {
            return 9080;
        }
        return Integer.getInteger(serverName + ".server.port", 7777);
    }

    public static int getHostPort() {
        return DefaultServer.getHostPort(DEFAULT);
    }

    public static int getHostSSLPort(String serverName) {
        if (DefaultServer.isApacheTest()) {
            return 9443;
        }
        return Integer.getInteger(serverName + ".server.sslPort", 7778);
    }

    public static OptionMap getUndertowOptions() {
        return openListener.getUndertowOptions();
    }

    public static void setUndertowOptions(OptionMap options) {
        OptionMap.Builder builder = OptionMap.builder().addAll(options);
        if (h2c) {
            builder.set(UndertowOptions.ENABLE_HTTP2, true);
        }
        openListener.setUndertowOptions(builder.getMap());
    }

    public static XnioWorker getWorker() {
        return worker;
    }

    public static boolean isAjp() {
        return ajp;
    }

    public static boolean isProxy() {
        return proxy || https || h2 || h2c || ajp || h2cUpgrade;
    }

    public static boolean isHttps() {
        return https;
    }

    public static boolean isH2() {
        return h2 || h2c || h2cUpgrade;
    }

    private static boolean isAlpnEnabled() {
        if (alpnEnabled == null) {
            SSLEngine engine = DefaultServer.getServerSslContext().createSSLEngine();
            ALPNProvider provider = ALPNManager.INSTANCE.getProvider(engine);
            alpnEnabled = provider instanceof JettyAlpnProvider ? Boolean.valueOf(System.getProperty("alpn-boot-string") != null) : Boolean.valueOf(provider != null);
        }
        return alpnEnabled;
    }

    public static void assumeAlpnEnabled() {
        Assume.assumeTrue((boolean)DefaultServer.isAlpnEnabled());
    }

    static {
        Throwable failure = null;
        try {
            OpenSSLProvider.register();
        }
        catch (Throwable t) {
            failure = t;
        }
        OPENSSL_FAILURE = failure;
        BUFFER_SIZE = Integer.getInteger("test.bufferSize", 24576);
        SSL_BUFFER_POOL = new DebuggingSlicePool((ByteBufferPool)new DefaultByteBufferPool(true, 17408));
        first = true;
        STORE_PASSWORD = "password".toCharArray();
        ajp = Boolean.getBoolean("test.ajp");
        h2 = Boolean.getBoolean("test.h2");
        h2c = Boolean.getBoolean("test.h2c");
        h2cUpgrade = Boolean.getBoolean("test.h2c-upgrade");
        https = Boolean.getBoolean("test.https");
        proxy = Boolean.getBoolean("test.proxy");
        apache = Boolean.getBoolean("test.apache");
        dump = Boolean.getBoolean("test.dump");
        single = Boolean.getBoolean("test.single");
        openssl = Boolean.getBoolean("test.openssl");
        runs = Integer.getInteger("test.runs", 1);
        rootHandler = new DelegatingHandler();
        pool = new DebuggingSlicePool((ByteBufferPool)new DefaultByteBufferPool(true, BUFFER_SIZE, 1000, 10, 100));
    }

    private static final class DelegatingHandler
    implements HttpHandler {
        volatile HttpHandler next;

        private DelegatingHandler() {
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            this.next.handleRequest(exchange);
        }
    }

    public static class Parameterized
    extends org.junit.runners.Parameterized {
        public Parameterized(Class<?> klass) throws Throwable {
            super(klass);
        }

        public void run(RunNotifier notifier) {
            DefaultServer.runInternal(notifier);
            super.run(notifier);
        }
    }
}

