/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.encoding;

import io.undertow.conduits.GzipStreamSourceConduit;
import io.undertow.conduits.InflatingStreamSourceConduit;
import io.undertow.io.IoCallback;
import io.undertow.io.Receiver;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.DeflateEncodingProvider;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import io.undertow.server.handlers.encoding.RequestEncodingHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class RequestContentEncodingTestCase {
    private static volatile String message;

    @BeforeClass
    public static void setup() {
        EncodingHandler handler = new EncodingHandler(new ContentEncodingRepository().addEncodingHandler("deflate", (ContentEncodingProvider)new DeflateEncodingProvider(), 50).addEncodingHandler("gzip", (ContentEncodingProvider)new GzipEncodingProvider(), 60)).setNext(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, message.length() + "");
                exchange.getResponseSender().send(message, IoCallback.END_EXCHANGE);
            }
        });
        RequestEncodingHandler decode = new RequestEncodingHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getRequestReceiver().receiveFullBytes(new Receiver.FullBytesCallback(){

                    public void handle(HttpServerExchange exchange, byte[] message) {
                        exchange.getResponseSender().send(ByteBuffer.wrap(message));
                    }
                });
            }
        }).addEncoding("deflate", InflatingStreamSourceConduit.WRAPPER).addEncoding("gzip", GzipStreamSourceConduit.WRAPPER);
        PathHandler pathHandler = new PathHandler();
        pathHandler.addPrefixPath("/encode", (HttpHandler)handler);
        pathHandler.addPrefixPath("/decode", (HttpHandler)decode);
        DefaultServer.setRootHandler((HttpHandler)pathHandler);
    }

    @Test
    public void testDeflateEncoding() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            sb.append("a message");
        }
        this.runTest(sb.toString(), "deflate");
        this.runTest("Hello World", "deflate");
    }

    @Test
    public void testGzipEncoding() throws IOException {
        this.runTest("Hello World", "gzip");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            sb.append("a message");
        }
        this.runTest(sb.toString(), "gzip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(String theMessage, String encoding) throws IOException {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            message = theMessage;
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/encode");
            get.setHeader("Accept-Encoding", encoding);
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header[] header = result.getHeaders("Content-Encoding");
            Assert.assertEquals((Object)encoding, (Object)header[0].getValue());
            byte[] body = HttpClientUtils.readRawResponse(result);
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/decode");
            post.setEntity((HttpEntity)new ByteArrayEntity(body));
            post.addHeader("Content-Encoding", encoding);
            result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String sb = HttpClientUtils.readResponse(result);
            Assert.assertEquals((long)theMessage.length(), (long)sb.length());
            Assert.assertEquals((Object)theMessage, (Object)sb);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

