/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.ajp;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.ajp.AjpRequestParseState;
import io.undertow.server.protocol.ajp.AjpRequestParser;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.xnio.IoUtils;

public class AjpParsingUnitTestCase {
    private static final ByteBuffer buffer;
    public static final AjpRequestParser AJP_REQUEST_PARSER;

    @Test
    public void testAjpParsing() throws IOException, AjpRequestParser.BadRequestException {
        ByteBuffer buffer = AjpParsingUnitTestCase.buffer.duplicate();
        HttpServerExchange result = new HttpServerExchange(null);
        AjpRequestParseState state = new AjpRequestParseState();
        AJP_REQUEST_PARSER.parse(buffer, state, result);
        Assert.assertEquals((long)165L, (long)state.dataSize);
        Assert.assertTrue((boolean)state.isComplete());
        Assert.assertEquals((long)0L, (long)buffer.remaining());
        this.testResult(result);
    }

    @Test
    public void testByteByByteAjpParsing() throws IOException, AjpRequestParser.BadRequestException {
        ByteBuffer buffer = AjpParsingUnitTestCase.buffer.duplicate();
        HttpServerExchange result = new HttpServerExchange(null);
        AjpRequestParseState state = new AjpRequestParseState();
        int limit = buffer.limit();
        for (int i = 1; i <= limit; ++i) {
            buffer.limit(i);
            AJP_REQUEST_PARSER.parse(buffer, state, result);
        }
        Assert.assertEquals((long)165L, (long)state.dataSize);
        Assert.assertTrue((boolean)state.isComplete());
        this.testResult(result);
    }

    private void testResult(HttpServerExchange exchange) {
        Assert.assertSame((Object)Methods.GET, (Object)exchange.getRequestMethod());
        Assert.assertEquals((Object)Protocols.HTTP_1_1, (Object)exchange.getProtocol());
        Assert.assertEquals((long)3L, (long)exchange.getRequestHeaders().getHeaderNames().size());
        Assert.assertEquals((Object)"localhost:7777", (Object)exchange.getRequestHeaders().getFirst(Headers.HOST));
        Assert.assertEquals((Object)"Apache-HttpClient/4.1.3 (java 1.5)", (Object)exchange.getRequestHeaders().getFirst(Headers.USER_AGENT));
        Assert.assertEquals((Object)"Keep-Alive", (Object)exchange.getRequestHeaders().getFirst(Headers.CONNECTION));
    }

    static {
        InputStream stream = AjpParsingUnitTestCase.class.getResourceAsStream("sample-ajp-request");
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int r = 0;
            byte[] buf = new byte[1024];
            while ((r = stream.read(buf)) > 0) {
                out.write(buf, 0, r);
            }
            buffer = ByteBuffer.wrap(out.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IoUtils.safeClose((Closeable)stream);
        }
        AJP_REQUEST_PARSER = new AjpRequestParser("UTF-8", true, 100, 100);
    }
}

