/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.encoding;

import io.undertow.conduits.DeflatingStreamSinkConduit;
import io.undertow.io.IoCallback;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.util.Headers;
import io.undertow.util.ObjectPool;
import java.io.IOException;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.ContentEncodingHttpClient;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class GzipContentEncodingSimpleObjectPoolTestCase {
    private static volatile String message;

    @BeforeClass
    public static void setup() {
        ObjectPool deflaterPool = DeflatingStreamSinkConduit.simpleDeflaterPool((int)50, (int)1);
        EncodingHandler handler = new EncodingHandler(new ContentEncodingRepository().addEncodingHandler("gzip", (ContentEncodingProvider)new GzipEncodingProvider(deflaterPool), 50, Predicates.parse((String)"max-content-size[5]"))).setNext(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, message.length() + "");
                exchange.getResponseSender().send(message, IoCallback.END_EXCHANGE);
            }
        });
        DefaultServer.setRootHandler((HttpHandler)handler);
    }

    @Test
    public void testGzipEncoding() throws IOException {
        this.runTest("Hello World");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSmallMessagePredicateDoesNotCompress() throws IOException {
        ContentEncodingHttpClient client = new ContentEncodingHttpClient();
        try {
            message = "Hi";
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "gzip");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header[] header = result.getHeaders("Content-Encoding");
            Assert.assertEquals((long)0L, (long)header.length);
            String body = HttpClientUtils.readResponse(result);
            Assert.assertEquals((Object)"Hi", (Object)body);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAcceptIdentity() throws IOException {
        ContentEncodingHttpClient client = new ContentEncodingHttpClient();
        try {
            message = "Hi";
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "identity;q=1, *;q=0");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header[] header = result.getHeaders("Content-Encoding");
            Assert.assertEquals((long)1L, (long)header.length);
            Assert.assertEquals((Object)"identity", (Object)header[0].getValue());
            String body = HttpClientUtils.readResponse(result);
            Assert.assertEquals((Object)"Hi", (Object)body);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Test
    public void testGZipEncodingLargeResponse() throws IOException {
        StringBuilder messageBuilder = new StringBuilder(691963);
        for (int i = 0; i < 691963; ++i) {
            messageBuilder.append("*");
        }
        this.runTest(messageBuilder.toString());
    }

    @Test
    public void testGzipEncodingRandomSizeResponse() throws IOException {
        int seed = new Random().nextInt();
        System.out.println("Using seed " + seed);
        try {
            Random random = new Random(seed);
            int size = random.nextInt(691963);
            StringBuilder messageBuilder = new StringBuilder(size);
            for (int i = 0; i < size; ++i) {
                messageBuilder.append(42 + random.nextInt(10));
            }
            this.runTest(messageBuilder.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Test failed with seed " + seed, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(String theMessage) throws IOException {
        ContentEncodingHttpClient client = new ContentEncodingHttpClient();
        try {
            message = theMessage;
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "gzip");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header[] header = result.getHeaders("Content-Encoding");
            Assert.assertEquals((Object)"gzip", (Object)header[0].getValue());
            String body = HttpClientUtils.readResponse(result);
            Assert.assertEquals((Object)theMessage, (Object)body);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

