/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RouteIteratorFactory {
    private final ParsingCompatibility parsing;
    private final String delimiter;

    public RouteIteratorFactory(ParsingCompatibility parsingCompatibility, String rankedRouteDelimiter) {
        this.parsing = parsingCompatibility;
        this.delimiter = rankedRouteDelimiter;
    }

    public Iterator<CharSequence> iterator(String sessionId) {
        return new RouteIterator(sessionId);
    }

    private class RouteIterator
    implements Iterator<CharSequence> {
        private final String sessionId;
        private boolean nextResolved;
        private int nextPos;
        private CharSequence next;

        RouteIterator(String sessionId) {
            int index;
            this.sessionId = sessionId;
            int n = index = sessionId == null ? -1 : sessionId.indexOf(46);
            if (index == -1) {
                this.nextResolved = true;
                this.next = null;
            } else {
                this.nextPos = index + 1;
            }
        }

        @Override
        public boolean hasNext() {
            this.resolveNext();
            return this.next != null;
        }

        @Override
        public CharSequence next() {
            this.resolveNext();
            if (this.next != null) {
                CharSequence result = this.next;
                this.nextResolved = RouteIteratorFactory.this.delimiter == null;
                this.next = null;
                return result;
            }
            throw new NoSuchElementException();
        }

        private void resolveNext() {
            if (!this.nextResolved) {
                if (RouteIteratorFactory.this.delimiter == null) {
                    if (RouteIteratorFactory.this.parsing == ParsingCompatibility.MOD_JK) {
                        int last = this.sessionId.indexOf(46, this.nextPos);
                        if (last == -1) {
                            last = this.sessionId.length();
                        }
                        this.next = CharBuffer.wrap(this.sessionId, this.nextPos, last);
                    } else {
                        this.next = CharBuffer.wrap(this.sessionId, this.nextPos, this.sessionId.length());
                    }
                } else if (this.nextPos >= this.sessionId.length()) {
                    this.next = null;
                } else {
                    int currentPos = this.sessionId.indexOf(RouteIteratorFactory.this.delimiter, this.nextPos);
                    this.next = CharBuffer.wrap(this.sessionId, this.nextPos, currentPos != -1 ? currentPos : this.sessionId.length());
                    this.nextPos += this.next.length() + RouteIteratorFactory.this.delimiter.length();
                }
                this.nextResolved = true;
            }
        }
    }

    public static enum ParsingCompatibility {
        MOD_JK,
        MOD_CLUSTER;

    }
}

