/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.PooledObject;
import io.undertow.util.SimpleObjectPool;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SimpleObjectPoolTestCase {
    @Rule
    public final ExpectedException expected = ExpectedException.none();

    @Test
    public void testObjectAlreadyReturned() {
        SimpleObjectPool pool = new SimpleObjectPool(1, Object::new, obj -> {}, obj -> {});
        PooledObject pooled = pool.allocate();
        pooled.close();
        this.expected.expect(IllegalStateException.class);
        pooled.getObject();
    }

    @Test
    public void testCloseMayBeInvokedMultipleTimesWhenObjectIsRecycled() {
        AtomicInteger recycled = new AtomicInteger();
        AtomicInteger destroyed = new AtomicInteger();
        SimpleObjectPool pool = new SimpleObjectPool(1, Object::new, obj -> recycled.incrementAndGet(), obj -> destroyed.incrementAndGet());
        PooledObject pooled = pool.allocate();
        pooled.close();
        pooled.close();
        Assert.assertEquals((String)"Pooled object should only be recycled once", (long)1L, (long)recycled.get());
        Assert.assertEquals((String)"Pooled object should be queued for reuse, not destroyed", (long)0L, (long)destroyed.get());
    }

    @Test
    public void testCloseMayBeInvokedMultipleTimesWhenObjectIsConsumed() {
        AtomicInteger recycled = new AtomicInteger();
        AtomicInteger destroyed = new AtomicInteger();
        SimpleObjectPool pool = new SimpleObjectPool(1, Object::new, obj -> recycled.incrementAndGet(), obj -> destroyed.incrementAndGet());
        PooledObject initial = pool.allocate();
        PooledObject pooled = pool.allocate();
        initial.close();
        pooled.close();
        pooled.close();
        Assert.assertEquals((String)"Each pooled object should be recycled", (long)2L, (long)recycled.get());
        Assert.assertEquals((String)"Pooled object should be destroyed exactly once", (long)1L, (long)destroyed.get());
    }
}

