/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ExceptionHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ExceptionHandlerTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExceptionMappers() throws IOException {
        PathHandler pathHandler = Handlers.path().addExactPath("/", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send("expected");
            }
        }).addExactPath("/exceptionParent", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                throw new ParentException();
            }
        }).addExactPath("/exceptionChild", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                throw new ChildException();
            }
        }).addExactPath("/exceptionAnotherChild", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                throw new AnotherChildException();
            }
        }).addExactPath("/illegalArgumentException", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                throw new IllegalArgumentException();
            }
        });
        ExceptionHandler exceptionHandler = Handlers.exceptionHandler((HttpHandler)pathHandler).addExceptionHandler(ChildException.class, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send("child exception handled");
            }
        }).addExceptionHandler(ParentException.class, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send("parent exception handled");
            }
        }).addExceptionHandler(Throwable.class, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send("catch all throwables");
            }
        });
        DefaultServer.setRootHandler((HttpHandler)exceptionHandler);
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"expected", (Object)HttpClientUtils.readResponse((HttpResponse)result));
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/exceptionParent");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"parent exception handled", (Object)HttpClientUtils.readResponse((HttpResponse)result));
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/exceptionChild");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"child exception handled", (Object)HttpClientUtils.readResponse((HttpResponse)result));
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/exceptionAnotherChild");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"parent exception handled", (Object)HttpClientUtils.readResponse((HttpResponse)result));
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/illegalArgumentException");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"catch all throwables", (Object)HttpClientUtils.readResponse((HttpResponse)result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReThrowUnmatchedException() throws IOException {
        PathHandler pathHandler = Handlers.path().addExactPath("/", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                throw new IllegalArgumentException();
            }
        });
        ExceptionHandler exceptionHandler = Handlers.exceptionHandler((HttpHandler)pathHandler);
        DefaultServer.setRootHandler((HttpHandler)exceptionHandler);
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)500L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAttachException() throws IOException {
        PathHandler pathHandler = Handlers.path().addExactPath("/", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                throw new IllegalArgumentException();
            }
        });
        ExceptionHandler exceptionHandler = Handlers.exceptionHandler((HttpHandler)pathHandler).addExceptionHandler(IllegalArgumentException.class, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send("exception handled");
            }
        });
        DefaultServer.setRootHandler(new HttpHandler((HttpHandler)exceptionHandler){
            final /* synthetic */ HttpHandler val$exceptionHandler;
            {
                this.val$exceptionHandler = httpHandler;
            }

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                Throwable throwable = (Throwable)exchange.getAttachment(ExceptionHandler.THROWABLE);
                Assert.assertNull((Object)throwable);
                this.val$exceptionHandler.handleRequest(exchange);
                throwable = (Throwable)exchange.getAttachment(ExceptionHandler.THROWABLE);
                Assert.assertTrue((boolean)(throwable instanceof IllegalArgumentException));
            }
        });
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"exception handled", (Object)HttpClientUtils.readResponse((HttpResponse)result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private static class AnotherChildException
    extends ParentException {
        private AnotherChildException() {
        }
    }

    private static class ChildException
    extends ParentException {
        private ChildException() {
        }
    }

    private static class ParentException
    extends Exception {
        private ParentException() {
        }
    }
}

