package io.undertow;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import java.net.InetSocketAddress;
import io.undertow.protocols.ssl.SslConduit;
import java.lang.String;
import io.undertow.server.handlers.sse.ServerSentEventConnection.EventCallback;
import org.jboss.logging.Logger;
import java.net.URI;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.server.ServerConnection.CloseListener;
import org.jboss.logging.BasicLogger;
import java.util.List;
import java.net.SocketAddress;
import java.lang.IllegalArgumentException;
import java.nio.file.Path;
import javax.annotation.Generated;
import io.undertow.server.ServerConnection;
import java.io.IOException;
import java.lang.Exception;
import java.util.Date;
import org.xnio.ssl.SslConnection;
import java.lang.Throwable;
import java.util.Arrays;
import java.net.InetAddress;
import io.undertow.util.HttpString;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-03-30T04:50:16-0300")
public class UndertowLogger_$logger extends DelegatingBasicLogger implements UndertowLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = UndertowLogger_$logger.class.getName();
    public UndertowLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void exceptionProcessingRequest(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, exceptionProcessingRequest$str());
    }
    protected String exceptionProcessingRequest$str() {
        return "UT005001: An exception occurred processing the request";
    }
    @Override
    public final void ioExceptionReadingFromChannel(final IOException e) {
        super.log.logf(FQCN, ERROR, e, ioExceptionReadingFromChannel$str());
    }
    protected String ioExceptionReadingFromChannel$str() {
        return "UT005003: IOException reading from channel";
    }
    @Override
    public final void cannotRemoveUploadedFile(final Path file) {
        super.log.logf(FQCN, ERROR, null, cannotRemoveUploadedFile$str(), file);
    }
    protected String cannotRemoveUploadedFile$str() {
        return "UT005005: Cannot remove uploaded file %s";
    }
    @Override
    public final void requestHeaderWasTooLarge(final SocketAddress address, final int size) {
        super.log.logf(FQCN, DEBUG, null, requestHeaderWasTooLarge$str(), address, size);
    }
    protected String requestHeaderWasTooLarge$str() {
        return "UT005006: Connection from %s terminated as request header was larger than %s";
    }
    @Override
    public final void requestWasNotFullyConsumed() {
        super.log.logf(FQCN, DEBUG, null, requestWasNotFullyConsumed$str());
    }
    protected String requestWasNotFullyConsumed$str() {
        return "UT005007: Request was not fully consumed";
    }
    @Override
    public final void invalidTokenReceived(final String tokenName, final String tokenValue) {
        super.log.logf(FQCN, DEBUG, null, invalidTokenReceived$str(), tokenName, tokenValue);
    }
    protected String invalidTokenReceived$str() {
        return "UT005008: An invalid token '%s' with value '%s' has been received.";
    }
    @Override
    public final void missingAuthorizationToken(final String tokenName) {
        super.log.logf(FQCN, DEBUG, null, missingAuthorizationToken$str(), tokenName);
    }
    protected String missingAuthorizationToken$str() {
        return "UT005009: A mandatory token %s is missing from the request.";
    }
    @Override
    public final void authenticationFailed(final String userName, final String mechanism) {
        super.log.logf(FQCN, DEBUG, null, authenticationFailed$str(), userName, mechanism);
    }
    protected String authenticationFailed$str() {
        return "UT005010: Verification of authentication tokens for user '%s' has failed using mechanism '%s'.";
    }
    @Override
    public final void ignoringAjpRequestWithPrefixCode(final byte prefix) {
        super.log.logf(FQCN, ERROR, null, ignoringAjpRequestWithPrefixCode$str(), prefix);
    }
    protected String ignoringAjpRequestWithPrefixCode$str() {
        return "UT005011: Ignoring AJP request with prefix %s";
    }
    @Override
    public final void ioException(final IOException e) {
        super.log.logf(FQCN, DEBUG, e, ioException$str());
    }
    protected String ioException$str() {
        return "UT005013: An IOException occurred";
    }
    @Override
    public final void failedToParseRequest(final Throwable e) {
        super.log.logf(FQCN, DEBUG, e, failedToParseRequest$str());
    }
    protected String failedToParseRequest$str() {
        return "UT005014: Failed to parse request";
    }
    @Override
    public final void errorRotatingAccessLog(final IOException e) {
        super.log.logf(FQCN, ERROR, e, errorRotatingAccessLog$str());
    }
    protected String errorRotatingAccessLog$str() {
        return "UT005015: Error rotating access log";
    }
    @Override
    public final void errorWritingAccessLog(final IOException e) {
        super.log.logf(FQCN, ERROR, e, errorWritingAccessLog$str());
    }
    protected String errorWritingAccessLog$str() {
        return "UT005016: Error writing access log";
    }
    @Override
    public final void unknownVariable(final String token) {
        super.log.logf(FQCN, ERROR, null, unknownVariable$str(), token);
    }
    protected String unknownVariable$str() {
        return "UT005017: Unknown variable %s. For the literal percent character use two percent characters: '%%'";
    }
    @Override
    public final void exceptionInvokingCloseListener(final CloseListener l, final Throwable e) {
        super.log.logf(FQCN, ERROR, e, exceptionInvokingCloseListener$str(), l);
    }
    protected String exceptionInvokingCloseListener$str() {
        return "UT005018: Exception invoking close listener %s";
    }
    @Override
    public final void errorWritingJDBCLog(final Exception e) {
        super.log.logf(FQCN, ERROR, e, errorWritingJDBCLog$str());
    }
    protected String errorWritingJDBCLog$str() {
        return "UT005020: Error writing JDBC log";
    }
    @Override
    public final void exceptionGeneratingErrorPage(final Exception e, final String location) {
        super.log.logf(FQCN, ERROR, e, exceptionGeneratingErrorPage$str(), location);
    }
    protected String exceptionGeneratingErrorPage$str() {
        return "UT005022: Exception generating error page %s";
    }
    @Override
    public final void exceptionHandlingRequest(final Throwable t, final String requestURI) {
        super.log.logf(FQCN, ERROR, t, exceptionHandlingRequest$str(), requestURI);
    }
    protected String exceptionHandlingRequest$str() {
        return "UT005023: Exception handling request to %s";
    }
    @Override
    public final void couldNotRegisterChangeListener(final Exception e) {
        super.log.logf(FQCN, ERROR, e, couldNotRegisterChangeListener$str());
    }
    protected String couldNotRegisterChangeListener$str() {
        return "UT005024: Could not register resource change listener for caching resource manager, automatic invalidation of cached resource will not work";
    }
    @Override
    public final void timingOutRequest(final String requestURI) {
        super.log.logf(FQCN, ERROR, null, timingOutRequest$str(), requestURI);
    }
    protected String timingOutRequest$str() {
        return "UT005027: Timing out request to %s";
    }
    @Override
    public final void proxyRequestFailed(final String requestURI, final Exception e) {
        super.log.logf(FQCN, ERROR, e, proxyRequestFailed$str(), requestURI);
    }
    protected String proxyRequestFailed$str() {
        return "UT005028: Proxy request to %s failed";
    }
    @Override
    public final void proxyFailedToConnectToBackend(final String requestURI, final URI uri) {
        super.log.logf(FQCN, ERROR, null, proxyFailedToConnectToBackend$str(), requestURI, uri);
    }
    protected String proxyFailedToConnectToBackend$str() {
        return "UT005031: Proxy request to %s could not connect to backend server %s";
    }
    @Override
    public final void listenerNotProgressing() {
        super.log.logf(FQCN, ERROR, null, listenerNotProgressing$str());
    }
    protected String listenerNotProgressing$str() {
        return "UT005032: Listener not making progress on framed channel, closing channel to prevent infinite loop";
    }
    @Override
    public final void remoteEndpointFailedToSendInitialSettings(final int type) {
        super.log.logf(FQCN, ERROR, null, remoteEndpointFailedToSendInitialSettings$str(), type);
    }
    protected String remoteEndpointFailedToSendInitialSettings$str() {
        return "UT005034: Remote endpoint failed to send initial settings frame in HTTP2 connection, frame type %s";
    }
    @Override
    public final void parseRequestTimedOut(final SocketAddress remoteAddress) {
        super.log.logf(FQCN, DEBUG, null, parseRequestTimedOut$str(), remoteAddress);
    }
    protected String parseRequestTimedOut$str() {
        return "UT005035: Closing channel because of parse timeout for remote address %s";
    }
    @Override
    public final void noALPNFallback(final SocketAddress address) {
        super.log.logf(FQCN, ERROR, null, noALPNFallback$str(), address);
    }
    protected String noALPNFallback$str() {
        return "UT005036: ALPN negotiation failed for %s and no fallback defined, closing connection";
    }
    @Override
    public final void stickySessionCookieLengthTruncated(final String original, final String current) {
        super.log.logf(FQCN, WARN, null, stickySessionCookieLengthTruncated$str(), original, current);
    }
    protected String stickySessionCookieLengthTruncated$str() {
        return "UT005037: Name of the cookie containing the session id, %s, had been too long and was truncated to: %s";
    }
    @Override
    public final void balancerCreated(final int id, final String name, final boolean stickySession, final String stickySessionCookie, final String stickySessionPath, final boolean stickySessionRemove, final boolean stickySessionForce, final int waitWorker, final int maxattempts) {
        super.log.logf(FQCN, DEBUG, null, balancerCreated$str(), id, name, stickySession, stickySessionCookie, stickySessionPath, stickySessionRemove, stickySessionForce, waitWorker, maxattempts);
    }
    protected String balancerCreated$str() {
        return "UT005038: Balancer created: id: %s, name: %s, stickySession: %s, stickySessionCookie: %s, stickySessionPath: %s, stickySessionRemove: %s, stickySessionForce: %s, waitWorker: %s, maxattempts: %s";
    }
    @Override
    public final void proxyAdvertisementsStarted(final String address, final int frequency) {
        super.log.logf(FQCN, INFO, null, proxyAdvertisementsStarted$str(), address, frequency);
    }
    protected String proxyAdvertisementsStarted$str() {
        return "UT005039: Undertow starts mod_cluster proxy advertisements on %s with frequency %s ms";
    }
    @Override
    public final void proxyAdvertiseMessagePayload(final String payload) {
        super.log.logf(FQCN, DEBUG, null, proxyAdvertiseMessagePayload$str(), payload);
    }
    protected String proxyAdvertiseMessagePayload$str() {
        return "UT005040: Gonna send payload:\n%s";
    }
    @Override
    public final void proxyAdvertiseCannotSendMessage(final Exception e, final InetSocketAddress address) {
        super.log.logf(FQCN, ERROR, e, proxyAdvertiseCannotSendMessage$str(), address);
    }
    protected String proxyAdvertiseCannotSendMessage$str() {
        return "UT005041: Cannot send advertise message. Address: %s";
    }
    @Override
    public final void mcmpHandlerCreated() {
        super.log.logf(FQCN, DEBUG, null, mcmpHandlerCreated$str());
    }
    protected String mcmpHandlerCreated$str() {
        return "UT005042: Undertow mod_cluster proxy MCMPHandler created";
    }
    @Override
    public final void mcmpProcessingError(final String type, final String errString) {
        super.log.logf(FQCN, ERROR, null, mcmpProcessingError$str(), type, errString);
    }
    protected String mcmpProcessingError$str() {
        return "UT005043: Error in processing MCMP commands: Type:%s, Mess: %s";
    }
    @Override
    public final void removingNode(final String jvmRoute) {
        super.log.logf(FQCN, INFO, null, removingNode$str(), jvmRoute);
    }
    protected String removingNode$str() {
        return "UT005044: Removing node %s";
    }
    @Override
    public final void registeringContext(final String contextPath, final String jvmRoute) {
        super.log.logf(FQCN, INFO, null, registeringContext2$str(), contextPath, jvmRoute);
    }
    protected String registeringContext2$str() {
        return "UT005045: Registering context %s, for node %s";
    }
    @Override
    public final void registeringContext(final String contextPath, final String jvmRoute, final List<String> aliases) {
        super.log.logf(FQCN, DEBUG, null, registeringContext3$str(), contextPath, jvmRoute, aliases);
    }
    protected String registeringContext3$str() {
        return "UT005046: Registering context %s, for node %s, with aliases %s";
    }
    @Override
    public final void unregisteringContext(final String contextPath, final String jvmRoute) {
        super.log.logf(FQCN, INFO, null, unregisteringContext$str(), contextPath, jvmRoute);
    }
    protected String unregisteringContext$str() {
        return "UT005047: Unregistering context %s, from node %s";
    }
    @Override
    public final void nodeIsInError(final String jvmRoute) {
        super.log.logf(FQCN, DEBUG, null, nodeIsInError$str(), jvmRoute);
    }
    protected String nodeIsInError$str() {
        return "UT005048: Node %s in error";
    }
    @Override
    public final void nodeConfigCreated(final URI connectionURI, final String balancer, final String domain, final String jvmRoute, final boolean flushPackets, final int flushwait, final int ping, final long ttl, final int timeout, final int maxConnections, final int cacheConnections, final int requestQueueSize, final boolean queueNewRequests) {
        super.log.logf(FQCN, DEBUG, null, nodeConfigCreated$str(), connectionURI, balancer, domain, jvmRoute, flushPackets, flushwait, ping, ttl, timeout, maxConnections, cacheConnections, requestQueueSize, queueNewRequests);
    }
    protected String nodeConfigCreated$str() {
        return "UT005049: NodeConfig created: connectionURI: %s, balancer: %s, load balancing group: %s, jvmRoute: %s, flushPackets: %s, flushwait: %s, ping: %s,ttl: %s, timeout: %s, maxConnections: %s, cacheConnections: %s, requestQueueSize: %s, queueNewRequests: %s";
    }
    @Override
    public final void failedToProcessManagementReq(final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToProcessManagementReq$str());
    }
    protected String failedToProcessManagementReq$str() {
        return "UT005050: Failed to process management request";
    }
    @Override
    public final void failedToSendPingResponse(final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToSendPingResponse$str());
    }
    protected String failedToSendPingResponse$str() {
        return "UT005051: Failed to send ping response";
    }
    @Override
    public final void failedToSendPingResponseDBG(final Exception e, final String node, final String jvmRoute) {
        super.log.logf(FQCN, DEBUG, e, failedToSendPingResponseDBG$str(), node, jvmRoute);
    }
    protected String failedToSendPingResponseDBG$str() {
        return "UT005052: Failed to send ping response, node.getJvmRoute(): %s, jvmRoute: %s";
    }
    @Override
    public final void registeringNode(final String jvmRoute, final URI connectionURI) {
        super.log.logf(FQCN, INFO, null, registeringNode$str(), jvmRoute, connectionURI);
    }
    protected String registeringNode$str() {
        return "UT005053: Registering node %s, connection: %s";
    }
    @Override
    public final void mcmpKeyValue(final HttpString name, final String value) {
        super.log.logf(FQCN, DEBUG, null, mcmpKeyValue$str(), name, value);
    }
    protected String mcmpKeyValue$str() {
        return "UT005054: MCMP processing, key: %s, value: %s";
    }
    @Override
    public final void httpClientPingTask(final URI connection) {
        super.log.logf(FQCN, DEBUG, null, httpClientPingTask$str(), connection);
    }
    protected String httpClientPingTask$str() {
        return "UT005055: HttpClientPingTask run for connection: %s";
    }
    @Override
    public final void receivedNodeLoad(final String jvmRoute, final String loadValue) {
        super.log.logf(FQCN, DEBUG, null, receivedNodeLoad$str(), jvmRoute, loadValue);
    }
    protected String receivedNodeLoad$str() {
        return "UT005056: Received node load in STATUS message, node jvmRoute: %s, load: %s";
    }
    @Override
    public final void mcmpSendingResponse(final InetSocketAddress destination, final int status, final HeaderMap headers, final String response) {
        super.log.logf(FQCN, DEBUG, null, mcmpSendingResponse$str(), destination, status, headers, response);
    }
    protected String mcmpSendingResponse$str() {
        return "UT005057: Sending MCMP response to destination: %s, HTTP status: %s, Headers: %s, response: %s";
    }
    @Override
    public final void potentialCrossTalking(final InetAddress group, final String s, final String localizedMessage) {
        super.log.logf(FQCN, WARN, null, potentialCrossTalking$str(), group, s, localizedMessage);
    }
    protected String potentialCrossTalking$str() {
        return "UT005058: Could not bind multicast socket to %s (%s address): %s; make sure your multicast address is of the same type as the IP stack (IPv4 or IPv6). Multicast socket will not be bound to an address, but this may lead to cross talking (see http://www.jboss.org/community/docs/DOC-9469 for details).";
    }
    @Override
    public final void oldStylePredicateSyntax(final String string) {
        super.log.logf(FQCN, WARN, null, oldStylePredicateSyntax$str(), string);
    }
    protected String oldStylePredicateSyntax$str() {
        return "UT005060: Predicate %s uses old style square braces to define predicates, which will be removed in a future release. predicate[value] should be changed to predicate(value)";
    }
    protected String maxRestartsExceeded$str() {
        return "UT005061: More than %s restarts detected, breaking assumed infinite loop";
    }
    @Override
    public final IllegalStateException maxRestartsExceeded(final int maxRestarts) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), maxRestartsExceeded$str(), maxRestarts));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void extendedAccessLogPatternParseError(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, extendedAccessLogPatternParseError$str());
    }
    protected String extendedAccessLogPatternParseError$str() {
        return "UT005062: Pattern parse error";
    }
    @Override
    public final void extendedAccessLogUnknownToken(final String token) {
        super.log.logf(FQCN, ERROR, null, extendedAccessLogUnknownToken$str(), token);
    }
    protected String extendedAccessLogUnknownToken$str() {
        return "UT005063: Unable to decode with rest of chars starting: %s";
    }
    @Override
    public final void extendedAccessLogMissingClosing() {
        super.log.logf(FQCN, ERROR, null, extendedAccessLogMissingClosing$str());
    }
    protected String extendedAccessLogMissingClosing$str() {
        return "UT005064: No closing ) found for in decode";
    }
    @Override
    public final void extendedAccessLogCannotDecode(final String chars) {
        super.log.logf(FQCN, ERROR, null, extendedAccessLogCannotDecode$str(), chars);
    }
    protected String extendedAccessLogCannotDecode$str() {
        return "UT005065: The next characters couldn't be decoded: %s";
    }
    @Override
    public final void extendedAccessLogCannotDecodeXParamValue(final String value) {
        super.log.logf(FQCN, ERROR, null, extendedAccessLogCannotDecodeXParamValue$str(), value);
    }
    protected String extendedAccessLogCannotDecodeXParamValue$str() {
        return "UT005066: X param for servlet request, couldn't decode value: %s";
    }
    @Override
    public final void extendedAccessLogBadXParam() {
        super.log.logf(FQCN, ERROR, null, extendedAccessLogBadXParam$str());
    }
    protected String extendedAccessLogBadXParam$str() {
        return "UT005067: X param in wrong format. Needs to be 'x-#(...)'";
    }
    @Override
    public final void extendedAccessLogEmptyPattern() {
        super.log.logf(FQCN, INFO, null, extendedAccessLogEmptyPattern$str());
    }
    protected String extendedAccessLogEmptyPattern$str() {
        return "UT005068: Pattern was just empty or whitespace";
    }
    @Override
    public final void failedToWriteJdbcAccessLog(final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToWriteJdbcAccessLog$str());
    }
    protected String failedToWriteJdbcAccessLog$str() {
        return "UT005069: Failed to write JDBC access log";
    }
    @Override
    public final void failedToWritePreCachedFile() {
        super.log.logf(FQCN, ERROR, null, failedToWritePreCachedFile$str());
    }
    protected String failedToWritePreCachedFile$str() {
        return "UT005070: Failed to write pre-cached file";
    }
    @Override
    public final void undertowRequestFailed(final Throwable t, final HttpServerExchange exchange) {
        super.log.logf(FQCN, ERROR, t, undertowRequestFailed$str(), exchange);
    }
    protected String undertowRequestFailed$str() {
        return "UT005071: Undertow request failed %s";
    }
    @Override
    public final void stuckThreadDetected(final String threadName, final long threadId, final long active, final Date start, final String requestUri, final int threshold, final int stuckCount, final Throwable stackTrace) {
        super.log.logf(FQCN, WARN, stackTrace, stuckThreadDetected$str(), threadName, threadId, active, start, requestUri, threshold, stuckCount);
    }
    protected String stuckThreadDetected$str() {
        return "UT005072: Thread %s (id=%s) has been active for %s milliseconds (since %s) to serve the same request for %s and may be stuck (configured threshold for this StuckThreadDetectionValve is %s seconds). There is/are %s thread(s) in total that are monitored by this Valve and may be stuck.";
    }
    @Override
    public final void stuckThreadCompleted(final String threadName, final long threadId, final long active, final int stuckCount) {
        super.log.logf(FQCN, WARN, null, stuckThreadCompleted$str(), threadName, threadId, active, stuckCount);
    }
    protected String stuckThreadCompleted$str() {
        return "UT005073: Thread %s (id=%s) was previously reported to be stuck but has completed. It was active for approximately %s milliseconds. There is/are still %s thread(s) that are monitored by this Valve and may be stuck.";
    }
    @Override
    public final void failedToInvokeFailedCallback(final EventCallback callback, final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToInvokeFailedCallback$str(), callback);
    }
    protected String failedToInvokeFailedCallback$str() {
        return "UT005074: Failed to invoke error callback %s for SSE task";
    }
    protected String unableToResolveModClusterManagementHost$str() {
        return "UT005075: Unable to resolve mod_cluster management host's address for '%s'";
    }
    @Override
    public final IllegalStateException unableToResolveModClusterManagementHost(final String providedHost) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToResolveModClusterManagementHost$str(), providedHost));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void sslReadLoopDetected(final SslConduit sslConduit) {
        super.log.logf(FQCN, ERROR, null, sslReadLoopDetected$str(), sslConduit);
    }
    protected String sslReadLoopDetected$str() {
        return "UT005076: SSL read loop detected. This should not happen, please report this to the Undertow developers. Current state %s";
    }
    @Override
    public final void sslBufferOverflow(final SslConduit sslConduit) {
        super.log.logf(FQCN, ERROR, null, sslBufferOverflow$str(), sslConduit);
    }
    protected String sslBufferOverflow$str() {
        return "UT005077: SSL unwrap buffer overflow detected. This should not happen, please report this to the Undertow developers. Current state %s";
    }
    @Override
    public final void alpnConnectionFailed(final SslConnection connection) {
        super.log.logf(FQCN, ERROR, null, alpnConnectionFailed$str(), connection);
    }
    protected String alpnConnectionFailed$str() {
        return "UT005079: ALPN negotiation on %s failed";
    }
    @Override
    public final void resumedAndDispatched() {
        super.log.logf(FQCN, ERROR, null, resumedAndDispatched$str());
    }
    protected String resumedAndDispatched$str() {
        return "UT005080: HttpServerExchange cannot have both async IO resumed and dispatch() called in the same cycle";
    }
    @Override
    public final void cannotProxyStartedRequest(final HttpServerExchange exchange) {
        super.log.logf(FQCN, ERROR, null, cannotProxyStartedRequest$str(), exchange);
    }
    protected String cannotProxyStartedRequest$str() {
        return "UT005081: Response has already been started, cannot proxy request %s";
    }
    protected String cannotUseWildcardAddressAsModClusterManagementHost$str() {
        return "UT005082: Configured mod_cluster management host address cannot be a wildcard address (%s)!";
    }
    @Override
    public final IllegalArgumentException cannotUseWildcardAddressAsModClusterManagementHost(final String providedAddress) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotUseWildcardAddressAsModClusterManagementHost$str(), providedAddress));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedEndOfCompressedInput$str() {
        return "UT005083: Unexpected end of compressed input";
    }
    @Override
    public final IOException unexpectedEndOfCompressedInput() {
        final IOException result = new IOException(String.format(getLoggingLocale(), unexpectedEndOfCompressedInput$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String dataLargerThanContentLength$str() {
        return "UT005084: Attempted to write %s bytes however content-length has been set to %s";
    }
    @Override
    public final IOException dataLargerThanContentLength(final long totalToWrite, final long responseContentLength) {
        final IOException result = new IOException(String.format(getLoggingLocale(), dataLargerThanContentLength$str(), totalToWrite, responseContentLength));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void responseWasNotTerminated(final ServerConnection connection, final HttpServerExchange exchange) {
        super.log.logf(FQCN, DEBUG, null, responseWasNotTerminated$str(), connection, exchange);
    }
    protected String responseWasNotTerminated$str() {
        return "UT005085: Connection %s for exchange %s was not closed cleanly, forcibly closing connection";
    }
    @Override
    public final void failedToAcceptSSLRequest(final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToAcceptSSLRequest$str());
    }
    protected String failedToAcceptSSLRequest$str() {
        return "UT005086: Failed to accept SSL request";
    }
    @Override
    public final void closeAsyncFailed(final IOException e) {
        super.log.logf(FQCN, ERROR, e, closeAsyncFailed$str());
    }
    protected String closeAsyncFailed$str() {
        return "UT005088: Failed to execute ServletOutputStream.closeAsync() on IO thread";
    }
    protected String nullParameter$str() {
        return "UT005089: Method parameter '%s' cannot be null";
    }
    @Override
    public final IllegalArgumentException nullParameter(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullParameter$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void handleUnexpectedFailure(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, handleUnexpectedFailure$str());
    }
    protected String handleUnexpectedFailure$str() {
        return "UT005090: Unexpected failure";
    }
    @Override
    public final void directBufferDeallocatorInitializationFailed(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, directBufferDeallocatorInitializationFailed$str());
    }
    protected String directBufferDeallocatorInitializationFailed$str() {
        return "UT005091: Failed to initialize DirectByteBufferDeallocator";
    }
    @Override
    public final void directBufferDeallocationFailed(final Throwable t) {
        super.log.logf(FQCN, DEBUG, t, directBufferDeallocationFailed$str());
    }
    protected String directBufferDeallocationFailed$str() {
        return "UT005092: Failed to free direct buffer";
    }
}
