/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.Option;
import org.xnio.OptionMap;

@RunWith(value=DefaultServer.class)
@AjpIgnore(apacheOnly=true)
public class LotsOfHeadersRequestTestCase {
    private static final String HEADER = "HEADER";
    private static final String MESSAGE = "Hello Header";
    private static final int DEFAULT_MAX_HEADERS = 200;
    private static final int TEST_MAX_HEADERS = 20;

    private static int getDefaultMaxHeaders() {
        int res = 197;
        if (DefaultServer.isProxy()) {
            res -= 5;
        }
        if (DefaultServer.isH2()) {
            res -= 3;
        }
        return res;
    }

    private static int getTestMaxHeaders() {
        int res = 17;
        if (DefaultServer.isProxy()) {
            res -= 5;
        }
        if (DefaultServer.isH2()) {
            res -= 3;
        }
        return res;
    }

    @BeforeClass
    public static void setup() {
        Assume.assumeFalse((boolean)DefaultServer.isH2upgrade());
        BlockingHandler blockingHandler = new BlockingHandler();
        DefaultServer.setRootHandler((HttpHandler)blockingHandler);
        blockingHandler.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                HeaderMap headers = exchange.getRequestHeaders();
                for (HeaderValues header : headers) {
                    for (String val : header) {
                        exchange.getResponseHeaders().put(HttpString.tryFromString((String)header.getHeaderName().toString()), val);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AjpIgnore
    public void testLotsOfHeadersInRequest_Default_Ok() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            for (int i = 0; i < LotsOfHeadersRequestTestCase.getDefaultMaxHeaders(); ++i) {
                get.addHeader(HEADER + i, MESSAGE + i);
            }
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            for (int i = 0; i < LotsOfHeadersRequestTestCase.getDefaultMaxHeaders(); ++i) {
                Header[] header = result.getHeaders(HEADER + i);
                Assert.assertEquals((Object)(MESSAGE + i), (Object)header[0].getValue());
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLotsOfHeadersInRequest_Default_BadRequest() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            for (int i = 0; i < LotsOfHeadersRequestTestCase.getDefaultMaxHeaders() + 1; ++i) {
                get.addHeader(HEADER + i, MESSAGE + i);
            }
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)(DefaultServer.isH2() ? 503L : 400L), (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AjpIgnore
    public void testLotsOfHeadersInRequest_MaxHeaders_Ok() throws IOException {
        OptionMap existing = DefaultServer.getUndertowOptions();
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            for (int i = 0; i < LotsOfHeadersRequestTestCase.getTestMaxHeaders(); ++i) {
                get.addHeader(HEADER + i, MESSAGE + i);
            }
            DefaultServer.setUndertowOptions(OptionMap.create((Option)UndertowOptions.MAX_HEADERS, (Object)20));
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            for (int i = 0; i < LotsOfHeadersRequestTestCase.getTestMaxHeaders(); ++i) {
                Header[] header = result.getHeaders(HEADER + i);
                Assert.assertEquals((Object)(MESSAGE + i), (Object)header[0].getValue());
            }
        }
        finally {
            DefaultServer.setUndertowOptions(existing);
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLotsOfHeadersInRequest_MaxHeaders_BadRequest() throws IOException {
        OptionMap existing = DefaultServer.getUndertowOptions();
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            for (int i = 0; i < LotsOfHeadersRequestTestCase.getTestMaxHeaders() + 1; ++i) {
                get.addHeader(HEADER + i, MESSAGE + i);
            }
            DefaultServer.setUndertowOptions(OptionMap.create((Option)UndertowOptions.MAX_HEADERS, (Object)20));
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)(DefaultServer.isH2() ? 503L : 400L), (long)result.getStatusLine().getStatusCode());
        }
        finally {
            DefaultServer.setUndertowOptions(existing);
            client.getConnectionManager().shutdown();
        }
    }
}

