/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.file;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.PreCompressedResourceSupplier;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.ResourceSupplier;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.ContentEncodingHttpClient;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class PreCompressedResourceTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContentEncodedResource() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceSupplier)new PreCompressedResourceSupplier((ResourceManager)new PathResourceManager(rootPath, 0xA00000L)).addEncoding("gzip", ".gz")).setDirectoryListingEnabled(true))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/page.html");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String nonCompressedResource = HttpClientUtils.readResponse(result);
            Header[] headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
            Assert.assertTrue((String)nonCompressedResource, (boolean)nonCompressedResource.contains("A web page"));
            Assert.assertNull((Object)result.getFirstHeader("Content-Encoding"));
            ContentEncodingHttpClient compClient = new ContentEncodingHttpClient();
            result = compClient.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String compressedResource = HttpClientUtils.readResponse(result);
            headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
            Assert.assertEquals((Object)nonCompressedResource.replace("\r", ""), (Object)compressedResource.replace("\r", ""));
            Assert.assertEquals((Object)"gzip", (Object)result.getFirstHeader("Content-Encoding").getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

