/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.testutils;

import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class DebuggingSlicePool
implements ByteBufferPool {
    private static final ThreadLocal<String> ALLOCATION_CONTEXT = new ThreadLocal();
    static final Set<DebuggingBuffer> BUFFERS = Collections.newSetFromMap(new ConcurrentHashMap());
    static volatile String currentLabel;
    private final ByteBufferPool delegate;
    private final ByteBufferPool arrayBacked;

    public DebuggingSlicePool(ByteBufferPool delegate) {
        this.delegate = delegate;
        this.arrayBacked = delegate.isDirect() ? new DebuggingSlicePool(delegate.getArrayBackedPool()) : this;
    }

    public static void addContext(String context) {
        ALLOCATION_CONTEXT.set(context);
    }

    public PooledByteBuffer allocate() {
        PooledByteBuffer delegate = this.delegate.allocate();
        return new DebuggingBuffer(delegate, currentLabel);
    }

    public ByteBufferPool getArrayBackedPool() {
        return this.arrayBacked;
    }

    public void close() {
        this.delegate.close();
    }

    public int getBufferSize() {
        return this.delegate.getBufferSize();
    }

    public boolean isDirect() {
        return this.delegate.isDirect();
    }

    static class DebuggingBuffer
    implements PooledByteBuffer {
        private static final AtomicInteger allocationCount = new AtomicInteger();
        private final RuntimeException allocationPoint;
        private final PooledByteBuffer delegate;
        private final String label;
        private final int no;
        private volatile boolean free = false;
        private RuntimeException freePoint;

        DebuggingBuffer(PooledByteBuffer delegate, String label) {
            this.delegate = delegate;
            this.label = label;
            this.no = allocationCount.getAndIncrement();
            String ctx = (String)ALLOCATION_CONTEXT.get();
            ALLOCATION_CONTEXT.remove();
            this.allocationPoint = new RuntimeException(delegate.getBuffer() + " NO: " + this.no + " " + (ctx == null ? "[NO_CONTEXT]" : ctx));
            BUFFERS.add(this);
        }

        public void close() {
            if (this.free) {
                return;
            }
            this.freePoint = new RuntimeException("FREE POINT");
            this.free = true;
            BUFFERS.remove(this);
            this.delegate.close();
        }

        public boolean isOpen() {
            return !this.free;
        }

        public ByteBuffer getBuffer() throws IllegalStateException {
            if (this.free) {
                throw new IllegalStateException("Buffer already freed, free point: ", this.freePoint);
            }
            return this.delegate.getBuffer();
        }

        RuntimeException getAllocationPoint() {
            return this.allocationPoint;
        }

        String getLabel() {
            return this.label;
        }

        public String toString() {
            return "[debug:" + this.no + "]" + this.delegate.toString();
        }
    }
}

