/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ForwardedHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@ProxyIgnore
public class ForwardedHandlerTestCase {
    @BeforeClass
    public static void setup() {
        DefaultServer.setRootHandler((HttpHandler)new ForwardedHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send(exchange.getRequestScheme() + "|" + exchange.getHostAndPort() + "|" + exchange.getDestinationAddress() + "|" + exchange.getSourceAddress());
            }
        }));
    }

    @Test
    public void testHeaderParsing() {
        HashMap results = new HashMap();
        ForwardedHandler.parseHeader((String)"For=\"[2001:db8:cafe::17]:4711\"", results);
        Assert.assertEquals((Object)"[2001:db8:cafe::17]:4711", results.get(ForwardedHandler.Token.FOR));
        results.clear();
        ForwardedHandler.parseHeader((String)"for=192.0.2.60;proto=http;by=203.0.113.43", results);
        Assert.assertEquals((Object)"192.0.2.60", results.get(ForwardedHandler.Token.FOR));
        Assert.assertEquals((Object)"http", results.get(ForwardedHandler.Token.PROTO));
        Assert.assertEquals((Object)"203.0.113.43", results.get(ForwardedHandler.Token.BY));
        results.clear();
        ForwardedHandler.parseHeader((String)"for=192.0.2.43, for=198.51.100.17", results);
        Assert.assertEquals((Object)"192.0.2.43", results.get(ForwardedHandler.Token.FOR));
        results.clear();
        ForwardedHandler.parseHeader((String)"for=192.0.2.43, for=198.51.100.17;by=\"foo\"", results);
        Assert.assertEquals((Object)"192.0.2.43", results.get(ForwardedHandler.Token.FOR));
        Assert.assertEquals((Object)"foo", results.get(ForwardedHandler.Token.BY));
        results.clear();
    }

    @Test
    public void testAddressParsing() throws UnknownHostException {
        Assert.assertEquals(null, (Object)ForwardedHandler.parseAddress((String)"unknown"));
        Assert.assertEquals(null, (Object)ForwardedHandler.parseAddress((String)"_foo"));
        Assert.assertEquals((Object)new InetSocketAddress(InetAddress.getByAddress(new byte[]{-64, -88, 1, 1}), 0), (Object)ForwardedHandler.parseAddress((String)"192.168.1.1"));
        Assert.assertEquals((Object)new InetSocketAddress(InetAddress.getByAddress(new byte[]{-64, -88, 1, 1}), 8080), (Object)ForwardedHandler.parseAddress((String)"192.168.1.1:8080"));
        Assert.assertEquals((Object)new InetSocketAddress(InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}), 0), (Object)ForwardedHandler.parseAddress((String)"[::1]"));
        Assert.assertEquals((Object)new InetSocketAddress(InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}), 8080), (Object)ForwardedHandler.parseAddress((String)"[::1]:8080"));
    }

    @Test
    public void testForwardedHandler() throws IOException {
        String[] res = ForwardedHandlerTestCase.run(new String[0]);
        Assert.assertEquals((Object)"http", (Object)res[0]);
        Assert.assertEquals((Object)(DefaultServer.getHostAddress() + ":" + DefaultServer.getHostPort()), (Object)res[1]);
        Assert.assertEquals((Object)("/" + InetAddress.getByName(DefaultServer.getHostAddress()).getHostAddress() + ":" + DefaultServer.getHostPort()), (Object)res[2]);
        res = ForwardedHandlerTestCase.run("host=google.com");
        Assert.assertEquals((Object)"http", (Object)res[0]);
        Assert.assertEquals((Object)"google.com", (Object)res[1]);
        Assert.assertEquals((Object)"google.com:80", (Object)res[2]);
        res = ForwardedHandlerTestCase.run("host=google.com, proto=https");
        Assert.assertEquals((Object)"https", (Object)res[0]);
        Assert.assertEquals((Object)"google.com", (Object)res[1]);
        Assert.assertEquals((Object)"google.com:80", (Object)res[2]);
        res = ForwardedHandlerTestCase.run("for=8.8.8.8:3545");
        Assert.assertEquals((Object)"http", (Object)res[0]);
        Assert.assertEquals((Object)(DefaultServer.getHostAddress() + ":" + DefaultServer.getHostPort()), (Object)res[1]);
        Assert.assertEquals((Object)("/" + InetAddress.getByName(DefaultServer.getHostAddress()).getHostAddress() + ":" + DefaultServer.getHostPort()), (Object)res[2]);
        Assert.assertEquals((Object)"/8.8.8.8:3545", (Object)res[3]);
        res = ForwardedHandlerTestCase.run("for=8.8.8.8:3545, for=9.9.9.9:2343");
        Assert.assertEquals((Object)"http", (Object)res[0]);
        Assert.assertEquals((Object)(DefaultServer.getHostAddress() + ":" + DefaultServer.getHostPort()), (Object)res[1]);
        Assert.assertEquals((Object)("/" + InetAddress.getByName(DefaultServer.getHostAddress()).getHostAddress() + ":" + DefaultServer.getHostPort()), (Object)res[2]);
        Assert.assertEquals((Object)"/8.8.8.8:3545", (Object)res[3]);
        res = ForwardedHandlerTestCase.run("for=[::1]:3545, for=9.9.9.9:2343");
        Assert.assertEquals((Object)"http", (Object)res[0]);
        Assert.assertEquals((Object)(DefaultServer.getHostAddress() + ":" + DefaultServer.getHostPort()), (Object)res[1]);
        Assert.assertEquals((Object)("/" + InetAddress.getByName(DefaultServer.getHostAddress()).getHostAddress() + ":" + DefaultServer.getHostPort()), (Object)res[2]);
        Assert.assertEquals((Object)"/0:0:0:0:0:0:0:1:3545", (Object)res[3]);
        res = ForwardedHandlerTestCase.run("for=[::1]:_foo, for=9.9.9.9:2343");
        Assert.assertEquals((Object)"http", (Object)res[0]);
        Assert.assertEquals((Object)(DefaultServer.getHostAddress() + ":" + DefaultServer.getHostPort()), (Object)res[1]);
        Assert.assertEquals((Object)("/" + InetAddress.getByName(DefaultServer.getHostAddress()).getHostAddress() + ":" + DefaultServer.getHostPort()), (Object)res[2]);
        Assert.assertEquals((Object)"/0:0:0:0:0:0:0:1:0", (Object)res[3]);
        res = ForwardedHandlerTestCase.run("for=[::1], for=9.9.9.9:2343");
        Assert.assertEquals((Object)"http", (Object)res[0]);
        Assert.assertEquals((Object)(DefaultServer.getHostAddress() + ":" + DefaultServer.getHostPort()), (Object)res[1]);
        Assert.assertEquals((Object)("/" + InetAddress.getByName(DefaultServer.getHostAddress()).getHostAddress() + ":" + DefaultServer.getHostPort()), (Object)res[2]);
        Assert.assertEquals((Object)"/0:0:0:0:0:0:0:1:0", (Object)res[3]);
        res = ForwardedHandlerTestCase.run("by=[::1]; for=9.9.9.9:2343");
        Assert.assertEquals((Object)"http", (Object)res[0]);
        Assert.assertEquals((Object)(DefaultServer.getHostAddress() + ":" + DefaultServer.getHostPort()), (Object)res[1]);
        Assert.assertEquals((Object)"/0:0:0:0:0:0:0:1:0", (Object)res[2]);
        Assert.assertEquals((Object)"/9.9.9.9:2343", (Object)res[3]);
        res = ForwardedHandlerTestCase.run("by=[::1]; for=9.9.9.9:2343; host=foo.com");
        Assert.assertEquals((Object)"http", (Object)res[0]);
        Assert.assertEquals((Object)"foo.com", (Object)res[1]);
        Assert.assertEquals((Object)"foo.com:80", (Object)res[2]);
        Assert.assertEquals((Object)"/9.9.9.9:2343", (Object)res[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] run(String ... headers) throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
            for (String i : headers) {
                get.addHeader("Forwarded", i);
            }
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String[] stringArray = HttpClientUtils.readResponse(result).split("\\|");
            return stringArray;
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

