/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.file;

import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.PreCompressedResourceSupplier;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.ResourceSupplier;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.ContentEncodingHttpClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class PreCompressedResourceTestCase {
    @After
    public void clean() throws IOException, URISyntaxException {
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        if (Files.exists(rootPath.resolve("page.html.gz"), new LinkOption[0])) {
            Files.delete(rootPath.resolve("page.html.gz"));
        }
        if (Files.exists(rootPath.resolve("page.html.gzip"), new LinkOption[0])) {
            Files.delete(rootPath.resolve("page.html.gzip"));
        }
        if (Files.exists(rootPath.resolve("page.html.nonsense"), new LinkOption[0])) {
            Files.delete(rootPath.resolve("page.html.nonsense"));
        }
        if (Files.exists(rootPath.resolve("page.html.gzip.nonsense"), new LinkOption[0])) {
            Files.delete(rootPath.resolve("page.html.gzip.nonsense"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContentEncodedResource() throws IOException, URISyntaxException {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/page.html");
        TestHttpClient client = new TestHttpClient();
        ContentEncodingHttpClient compClient = new ContentEncodingHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceSupplier)new PreCompressedResourceSupplier((ResourceManager)new PathResourceManager(rootPath, 0xA00000L)).addEncoding("gzip", ".gz")).setDirectoryListingEnabled(true))));
            String plainResponse = this.assertResponse(client.execute((HttpUriRequest)get), false);
            this.assertResponse(compClient.execute((HttpUriRequest)get), false, plainResponse);
            this.generatePreCompressedResource("gz");
            this.assertResponse(compClient.execute((HttpUriRequest)get), true, plainResponse, "gz");
        }
        finally {
            client.getConnectionManager().shutdown();
            compClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorrectResourceSelected() throws IOException, URISyntaxException {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/page.html");
        TestHttpClient client = new TestHttpClient();
        ContentEncodingHttpClient compClient = new ContentEncodingHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new EncodingHandler(new ContentEncodingRepository().addEncodingHandler("gzip", (ContentEncodingProvider)new GzipEncodingProvider(), 50, Predicates.truePredicate())).setNext((HttpHandler)new ResourceHandler((ResourceSupplier)new PreCompressedResourceSupplier((ResourceManager)new PathResourceManager(rootPath, 0xA00000L)).addEncoding("gzip", ".gzip")).setDirectoryListingEnabled(true)))));
            String plainResponse = this.assertResponse(client.execute((HttpUriRequest)get), false);
            this.assertResponse(compClient.execute((HttpUriRequest)get), true, plainResponse);
            this.generatePreCompressedResource("gzip");
            this.generatePreCompressedResource("nonsense");
            this.generatePreCompressedResource("gzip.nonsense");
            this.assertResponse(compClient.execute((HttpUriRequest)get), true, plainResponse, "gzip");
        }
        finally {
            client.getConnectionManager().shutdown();
            compClient.getConnectionManager().shutdown();
        }
    }

    private void generateGZipFile(Path source, Path target) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream(target.toFile()));
        FileInputStream in = new FileInputStream(source.toFile());
        while ((len = in.read(buffer)) > 0) {
            gzos.write(buffer, 0, len);
        }
        in.close();
        gzos.finish();
        gzos.close();
    }

    private void replaceStringInFile(Path file, String original, String replacement) throws IOException {
        String content = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
        content = content.replaceAll(original, replacement);
        Files.write(file, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private String assertResponse(HttpResponse response, boolean encoding) throws IOException {
        return this.assertResponse(response, encoding, null, null);
    }

    private String assertResponse(HttpResponse response, boolean encoding, String compareWith) throws IOException {
        return this.assertResponse(response, encoding, compareWith, "web");
    }

    private String assertResponse(HttpResponse response, boolean encoding, String compareWith, String extension) throws IOException {
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        String body = HttpClientUtils.readResponse(response);
        Header[] headers = response.getHeaders("Content-Type");
        Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
        if (encoding) {
            Assert.assertEquals((Object)"gzip", (Object)response.getFirstHeader("Content-Encoding").getValue());
        } else {
            Assert.assertNull((Object)response.getFirstHeader("Content-Encoding"));
        }
        if (compareWith != null) {
            Assert.assertEquals((Object)compareWith.replace("\r", "").replace("web", extension), (Object)body.replace("\r", ""));
        }
        return body;
    }

    private void generatePreCompressedResource(String extension) throws IOException, URISyntaxException {
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        Path html = rootPath.resolve("page.html");
        this.replaceStringInFile(html, "web", extension);
        this.generateGZipFile(html, rootPath.resolve("page.html." + extension));
        this.replaceStringInFile(html, extension, "web");
    }
}

