/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.testutils.category.UnitTest;
import io.undertow.util.SameSiteNoneIncompatibleClientChecker;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnitTest.class})
public class SameSiteNoneIncompatibleClientCheckerTestCase {
    String[] incompatibleWebKitUserAgents = new String[]{"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/11.2 Safari/605.1.15", "Mozilla/5.0 (iPhone; CPU iPhone OS 12_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0 Mobile/15E148 Safari/604.1", "Mozilla/5.0 (iPhone; CPU iPhone OS 12_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/69.0.3497.91 Mobile/15E148 Safari/605.1"};
    String[] compatibleWebKitUserAgents = new String[]{"Mozilla/6.0 (Macintosh; U; Intel Mac OS X 10_15_3) AppleWebKit/663.16 (KHTML, like Gecko) Version/10.0 Safari/663.16", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_1_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.1 Mobile/15E148 Safari/604.1", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/77.0.3865.69 Mobile/15E148 Safari/605.1"};
    String[] incompatibleWebKitUserAgents2 = new String[]{"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.62 Safari/537.36", "Mozilla/5.0 (Linux; U; Android 7.0; en-US; ...) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/11.3.8.976 U3/0.8.0 Mobile Safari/534.30", "Mozilla/5.0 (Linux; U; Android 9; en-US; ...) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/57.0.2987.108 UCBrowser/12.13.0.1207 Mobile Safari/537.36"};
    String[] compatibleWebKitUserAgents2 = new String[]{"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36", "Mozilla/5.0 (Linux; U; Android 10; en-US; ...) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/57.0.2987.108 UCBrowser/12.13.4.1214 Mobile Safari/537.36"};

    @Test
    public void testHasWebKitSameSiteBug() {
        boolean result;
        for (String userAgent : this.incompatibleWebKitUserAgents) {
            result = SameSiteNoneIncompatibleClientChecker.hasWebKitSameSiteBug((String)userAgent);
            Assert.assertTrue((String)("Tested user-agent: '" + userAgent + "'"), (boolean)result);
        }
        for (String userAgent : this.compatibleWebKitUserAgents) {
            result = SameSiteNoneIncompatibleClientChecker.hasWebKitSameSiteBug((String)userAgent);
            Assert.assertFalse((String)("Tested user-agent: '" + userAgent + "'"), (boolean)result);
        }
    }

    @Test
    public void testDropsUnrecognizedSameSiteCookies() {
        boolean result;
        for (String userAgent : this.incompatibleWebKitUserAgents2) {
            result = SameSiteNoneIncompatibleClientChecker.dropsUnrecognizedSameSiteCookies((String)userAgent);
            Assert.assertTrue((String)("Tested user-agent: '" + userAgent + "'"), (boolean)result);
        }
        for (String userAgent : this.compatibleWebKitUserAgents2) {
            result = SameSiteNoneIncompatibleClientChecker.dropsUnrecognizedSameSiteCookies((String)userAgent);
            Assert.assertFalse((String)("Tested user-agent: '" + userAgent + "'"), (boolean)result);
        }
    }

    @Test
    public void testShouldSendSameSiteNone() {
        boolean result;
        for (String userAgent : this.incompatibleWebKitUserAgents) {
            result = SameSiteNoneIncompatibleClientChecker.shouldSendSameSiteNone((String)userAgent);
            Assert.assertFalse((String)("Tested user-agent: '" + userAgent + "'"), (boolean)result);
        }
        for (String userAgent : this.compatibleWebKitUserAgents) {
            result = SameSiteNoneIncompatibleClientChecker.shouldSendSameSiteNone((String)userAgent);
            Assert.assertTrue((String)("Tested user-agent: '" + userAgent + "'"), (boolean)result);
        }
        for (String userAgent : this.incompatibleWebKitUserAgents2) {
            result = SameSiteNoneIncompatibleClientChecker.shouldSendSameSiteNone((String)userAgent);
            Assert.assertFalse((String)("Tested user-agent: '" + userAgent + "'"), (boolean)result);
        }
        for (String userAgent : this.compatibleWebKitUserAgents2) {
            result = SameSiteNoneIncompatibleClientChecker.shouldSendSameSiteNone((String)userAgent);
            Assert.assertTrue((String)("Tested user-agent: '" + userAgent + "'"), (boolean)result);
        }
    }

    @Test
    public void testIsSameSiteNoneIncompatible() {
        boolean result;
        for (String userAgent : this.incompatibleWebKitUserAgents) {
            result = SameSiteNoneIncompatibleClientChecker.isSameSiteNoneIncompatible((String)userAgent);
            Assert.assertTrue((String)("Tested user-agent: '" + userAgent + "'"), (boolean)result);
        }
        for (String userAgent : this.compatibleWebKitUserAgents) {
            result = SameSiteNoneIncompatibleClientChecker.isSameSiteNoneIncompatible((String)userAgent);
            Assert.assertFalse((String)("Tested user-agent: '" + userAgent + "'"), (boolean)result);
        }
        for (String userAgent : this.incompatibleWebKitUserAgents2) {
            result = SameSiteNoneIncompatibleClientChecker.isSameSiteNoneIncompatible((String)userAgent);
            Assert.assertTrue((String)("Tested user-agent: '" + userAgent + "'"), (boolean)result);
        }
        for (String userAgent : this.compatibleWebKitUserAgents2) {
            result = SameSiteNoneIncompatibleClientChecker.isSameSiteNoneIncompatible((String)userAgent);
            Assert.assertFalse((String)("Tested user-agent: '" + userAgent + "'"), (boolean)result);
        }
    }
}

