/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.handlers.SameSiteCookieHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.FileUtils;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.junit.Assert;
import org.junit.Test;

public class SameSiteCookieHandlerTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrict() throws IOException {
        DefaultServer.setRootHandler((HttpHandler)new SameSiteCookieHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseCookies().put("foo", new CookieImpl("foo", "bar"));
            }
        }, "Strict", "foo"));
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header header = result.getFirstHeader("set-cookie");
            Assert.assertEquals((Object)"foo=bar; SameSite=Strict", (Object)header.getValue());
            FileUtils.readFile((InputStream)result.getEntity().getContent());
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLax() throws IOException {
        DefaultServer.setRootHandler((HttpHandler)new SameSiteCookieHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseCookies().put("foo", new CookieImpl("foo", "bar"));
            }
        }, "Lax", "foo"));
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header header = result.getFirstHeader("set-cookie");
            Assert.assertEquals((Object)"foo=bar; SameSite=Lax", (Object)header.getValue());
            FileUtils.readFile((InputStream)result.getEntity().getContent());
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNone() throws IOException {
        DefaultServer.setRootHandler((HttpHandler)new SameSiteCookieHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseCookies().put("foo", new CookieImpl("foo", "bar"));
            }
        }, "None", "foo"));
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header header = result.getFirstHeader("set-cookie");
            Assert.assertEquals((Object)"foo=bar; secure; SameSite=None", (Object)header.getValue());
            FileUtils.readFile((InputStream)result.getEntity().getContent());
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidMode() throws IOException {
        DefaultServer.setRootHandler((HttpHandler)new SameSiteCookieHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseCookies().put("foo", new CookieImpl("foo", "bar"));
            }
        }, "invalidmode", "foo"));
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header header = result.getFirstHeader("set-cookie");
            Assert.assertEquals((Object)"foo=bar", (Object)header.getValue());
            FileUtils.readFile((InputStream)result.getEntity().getContent());
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegexPattern() throws IOException {
        DefaultServer.setRootHandler((HttpHandler)new SameSiteCookieHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseCookies().put("foo", new CookieImpl("foo", "bar"));
            }
        }, "Lax", "fo.*"));
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header header = result.getFirstHeader("set-cookie");
            Assert.assertEquals((Object)"foo=bar; SameSite=Lax", (Object)header.getValue());
            FileUtils.readFile((InputStream)result.getEntity().getContent());
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseInsensitivePattern() throws IOException {
        DefaultServer.setRootHandler((HttpHandler)new SameSiteCookieHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseCookies().put("foo", new CookieImpl("foo", "bar"));
            }
        }, "Lax", "FOO", false));
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header header = result.getFirstHeader("set-cookie");
            Assert.assertEquals((Object)"foo=bar; SameSite=Lax", (Object)header.getValue());
            FileUtils.readFile((InputStream)result.getEntity().getContent());
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatternUnmatched() throws IOException {
        DefaultServer.setRootHandler((HttpHandler)new SameSiteCookieHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseCookies().put("foo", new CookieImpl("foo", "bar"));
            }
        }, "Lax", "FO.*"));
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header header = result.getFirstHeader("set-cookie");
            Assert.assertEquals((Object)"foo=bar", (Object)header.getValue());
            FileUtils.readFile((InputStream)result.getEntity().getContent());
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllCookies() throws IOException {
        DefaultServer.setRootHandler((HttpHandler)new SameSiteCookieHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseCookies().put("foo", new CookieImpl("foo", "bar"));
                exchange.getResponseCookies().put("baz", new CookieImpl("baz", "qux"));
                exchange.getResponseCookies().put("test", new CookieImpl("test", "test"));
            }
        }, "Strict"));
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            Header[] headerArray;
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            for (Header h : headerArray = result.getHeaders("set-cookie")) {
                if (h.getValue().contains("foo")) {
                    Assert.assertEquals((Object)"foo=bar; SameSite=Strict", (Object)h.getValue());
                }
                if (h.getValue().contains("baz")) {
                    Assert.assertEquals((Object)"baz=qux; SameSite=Strict", (Object)h.getValue());
                }
                if (!h.getValue().contains("test")) continue;
                Assert.assertEquals((Object)"test=test; SameSite=Strict", (Object)h.getValue());
            }
            FileUtils.readFile((InputStream)result.getEntity().getContent());
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleCookiesMatched() throws IOException {
        DefaultServer.setRootHandler((HttpHandler)new SameSiteCookieHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseCookies().put("foo", new CookieImpl("foo", "bar"));
                exchange.getResponseCookies().put("baz", new CookieImpl("baz", "qux"));
                exchange.getResponseCookies().put("test", new CookieImpl("test", "test"));
            }
        }, "Lax", "foo|baz"));
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            Header[] headerArray;
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            for (Header h : headerArray = result.getHeaders("set-cookie")) {
                if (h.getValue().contains("foo")) {
                    Assert.assertEquals((Object)"foo=bar; SameSite=Lax", (Object)h.getValue());
                }
                if (h.getValue().contains("baz")) {
                    Assert.assertEquals((Object)"baz=qux; SameSite=Lax", (Object)h.getValue());
                }
                if (!h.getValue().contains("test")) continue;
                Assert.assertEquals((Object)"test=test", (Object)h.getValue());
            }
            FileUtils.readFile((InputStream)result.getEntity().getContent());
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoneIncompatibleUA() throws IOException {
        DefaultServer.setRootHandler((HttpHandler)new SameSiteCookieHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseCookies().put("foo", new CookieImpl("foo", "bar"));
            }
        }, "None", "foo"));
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
            get.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.62 Safari/537.36");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header header = result.getFirstHeader("set-cookie");
            Assert.assertEquals((Object)"foo=bar", (Object)header.getValue());
            FileUtils.readFile((InputStream)result.getEntity().getContent());
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoneUACheckerDisabled() throws IOException {
        DefaultServer.setRootHandler((HttpHandler)new SameSiteCookieHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseCookies().put("foo", new CookieImpl("foo", "bar"));
            }
        }, "None", "foo", true, false, true));
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
            get.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.62 Safari/537.36");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header header = result.getFirstHeader("set-cookie");
            Assert.assertEquals((Object)"foo=bar; secure; SameSite=None", (Object)header.getValue());
            FileUtils.readFile((InputStream)result.getEntity().getContent());
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoneUACheckerEnabledAlthoughUAHeaderEmpty() throws IOException {
        DefaultServer.setRootHandler((HttpHandler)new SameSiteCookieHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseCookies().put("foo", new CookieImpl("foo", "bar"));
            }
        }, "None", "foo"));
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
            get.setHeader(Headers.USER_AGENT.toString(), "");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header header = result.getFirstHeader("set-cookie");
            Assert.assertEquals((Object)"foo=bar; secure; SameSite=None", (Object)header.getValue());
            FileUtils.readFile((InputStream)result.getEntity().getContent());
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoneUACheckerEnabledAlthoughUAHeaderNotSet() throws IOException {
        DefaultServer.setRootHandler((HttpHandler)new SameSiteCookieHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseCookies().put("foo", new CookieImpl("foo", "bar"));
            }
        }, "None", "foo"));
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient(){

            @Override
            protected HttpParams createHttpParams() {
                HttpParams params = super.createHttpParams();
                params.removeParameter("http.useragent");
                HttpConnectionParams.setSoTimeout((HttpParams)params, (int)30000);
                return params;
            }
        };
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header header = result.getFirstHeader("set-cookie");
            Assert.assertEquals((Object)"foo=bar; secure; SameSite=None", (Object)header.getValue());
            FileUtils.readFile((InputStream)result.getEntity().getContent());
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoneWithoutSecure() throws IOException {
        DefaultServer.setRootHandler((HttpHandler)new SameSiteCookieHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseCookies().put("foo", new CookieImpl("foo", "bar"));
            }
        }, "None", "foo", true, true, false));
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header header = result.getFirstHeader("set-cookie");
            Assert.assertEquals((Object)"foo=bar; SameSite=None", (Object)header.getValue());
            FileUtils.readFile((InputStream)result.getEntity().getContent());
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }
}

