/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.UndertowClient;
import io.undertow.io.Receiver;
import io.undertow.io.Sender;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import io.undertow.util.StringReadChannelListener;
import io.undertow.util.StringWriteChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
public class Http2ClientTestCase {
    private static final String message = "Hello World!";
    public static final String MESSAGE = "/message";
    public static final String POST = "/post";
    private static XnioWorker worker;
    private static Undertow server;
    private static final OptionMap DEFAULT_OPTIONS;
    private static URI ADDRESS;
    private static final AttachmentKey<String> RESPONSE_BODY;

    static void sendMessage(HttpServerExchange exchange) {
        exchange.setStatusCode(200);
        Sender sender = exchange.getResponseSender();
        sender.send(message);
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        XnioWorker xnioWorker;
        int port = DefaultServer.getHostPort("default");
        final PathHandler path = new PathHandler().addExactPath(MESSAGE, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                Http2ClientTestCase.sendMessage(exchange);
            }
        }).addExactPath(POST, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getRequestReceiver().receiveFullString(new Receiver.FullStringCallback(){

                    public void handle(HttpServerExchange exchange, String message) {
                        exchange.getResponseSender().send(message);
                    }
                });
            }
        });
        server = Undertow.builder().addHttpsListener(port + 1, DefaultServer.getHostAddress("default"), DefaultServer.getServerSslContext()).setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (!exchange.getProtocol().equals(Protocols.HTTP_2_0)) {
                    throw new RuntimeException("Not HTTP/2");
                }
                path.handleRequest(exchange);
            }
        }).build();
        server.start();
        try {
            ADDRESS = new URI("https://" + DefaultServer.getHostAddress() + ":" + (port + 1));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        Xnio xnio = Xnio.getInstance();
        worker = xnioWorker = xnio.createWorker(null, DEFAULT_OPTIONS);
    }

    @AfterClass
    public static void afterClass() {
        if (server != null) {
            server.stop();
        }
        if (worker != null) {
            worker.shutdown();
        }
    }

    static UndertowClient createClient() {
        return Http2ClientTestCase.createClient(OptionMap.EMPTY);
    }

    static UndertowClient createClient(OptionMap options) {
        return UndertowClient.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleBasic() throws Exception {
        UndertowClient client = Http2ClientTestCase.createClient();
        final CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        final CountDownLatch latch = new CountDownLatch(10);
        final ClientConnection connection = (ClientConnection)client.connect(ADDRESS, worker, (XnioSsl)new UndertowXnioSsl(worker.getXnio(), OptionMap.EMPTY, DefaultServer.getClientSSLContext()), DefaultServer.getBufferPool(), OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true)).get();
        try {
            connection.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 10; ++i) {
                        ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(Http2ClientTestCase.MESSAGE);
                        request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                        connection.sendRequest(request, Http2ClientTestCase.this.createClientCallback(responses, latch));
                    }
                }
            });
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)10L, (long)responses.size());
            for (ClientResponse response : responses) {
                Assert.assertEquals((Object)message, (Object)response.getAttachment(RESPONSE_BODY));
            }
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeadRequest() throws Exception {
        UndertowClient client = Http2ClientTestCase.createClient();
        final CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        final CountDownLatch latch = new CountDownLatch(10);
        final ClientConnection connection = (ClientConnection)client.connect(ADDRESS, worker, (XnioSsl)new UndertowXnioSsl(worker.getXnio(), OptionMap.EMPTY, DefaultServer.getClientSSLContext()), DefaultServer.getBufferPool(), OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true)).get();
        try {
            connection.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 10; ++i) {
                        ClientRequest request = new ClientRequest().setMethod(Methods.HEAD).setPath(Http2ClientTestCase.MESSAGE);
                        request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                        connection.sendRequest(request, Http2ClientTestCase.this.createClientCallback(responses, latch));
                    }
                }
            });
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)10L, (long)responses.size());
            for (ClientResponse response : responses) {
                Assert.assertEquals((Object)"", (Object)response.getAttachment(RESPONSE_BODY));
            }
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostRequest() throws Exception {
        UndertowClient client = Http2ClientTestCase.createClient();
        String postMessage = "This is a post request";
        final CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        final CountDownLatch latch = new CountDownLatch(10);
        final ClientConnection connection = (ClientConnection)client.connect(ADDRESS, worker, (XnioSsl)new UndertowXnioSsl(worker.getXnio(), OptionMap.EMPTY, DefaultServer.getClientSSLContext()), DefaultServer.getBufferPool(), OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true)).get();
        try {
            connection.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 10; ++i) {
                        ClientRequest request = new ClientRequest().setMethod(Methods.POST).setPath(Http2ClientTestCase.POST);
                        request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                        request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, "chunked");
                        connection.sendRequest(request, (ClientCallback)new ClientCallback<ClientExchange>(){

                            public void completed(ClientExchange result) {
                                new StringWriteChannelListener("This is a post request").setup(result.getRequestChannel());
                                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                                    public void completed(ClientExchange result) {
                                        new StringReadChannelListener(DefaultServer.getBufferPool()){

                                            protected void stringDone(String string) {
                                                responses.add(string);
                                                latch.countDown();
                                            }

                                            protected void error(IOException e) {
                                                e.printStackTrace();
                                                latch.countDown();
                                            }
                                        }.setup(result.getResponseChannel());
                                    }

                                    public void failed(IOException e) {
                                        e.printStackTrace();
                                        latch.countDown();
                                    }
                                });
                            }

                            public void failed(IOException e) {
                                e.printStackTrace();
                                latch.countDown();
                            }
                        });
                    }
                }
            });
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)10L, (long)responses.size());
            for (String response : responses) {
                Assert.assertEquals((Object)"This is a post request", (Object)response);
            }
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    private ClientCallback<ClientExchange> createClientCallback(final List<ClientResponse> responses, final CountDownLatch latch) {
        return new ClientCallback<ClientExchange>(){

            public void completed(ClientExchange result) {
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(final ClientExchange result) {
                        responses.add(result.getResponse());
                        new StringReadChannelListener(result.getConnection().getBufferPool()){

                            protected void stringDone(String string) {
                                result.getResponse().putAttachment(RESPONSE_BODY, (Object)string);
                                latch.countDown();
                            }

                            protected void error(IOException e) {
                                e.printStackTrace();
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    public void failed(IOException e) {
                        e.printStackTrace();
                        latch.countDown();
                    }
                });
                try {
                    result.getRequestChannel().shutdownWrites();
                    if (!result.getRequestChannel().flush()) {
                        result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    latch.countDown();
                }
            }

            public void failed(IOException e) {
                e.printStackTrace();
                latch.countDown();
            }
        };
    }

    static {
        RESPONSE_BODY = AttachmentKey.create(String.class);
        OptionMap.Builder builder = OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.TCP_NODELAY, true).set(Options.KEEP_ALIVE, true).set(Options.WORKER_NAME, (Object)"Client");
        DEFAULT_OPTIONS = builder.getMap();
    }
}

