/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.Headers;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class HeadBlockingExchangeTestCase {
    @BeforeClass
    public static void setup() {
        DefaultServer.setRootHandler((HttpHandler)new BlockingHandler(exchange -> exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "100")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sendHttpHead() throws IOException {
        HttpHead head = new HttpHead(DefaultServer.getDefaultServerURL());
        TestHttpClient client = new TestHttpClient();
        try {
            CloseableHttpResponse result = client.execute((HttpUriRequest)head);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"", (Object)HttpClientUtils.readResponse((HttpResponse)result));
            Assert.assertEquals((Object)"100", (Object)result.getFirstHeader("Content-Length").getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

