/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowOptions;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.HttpRequestParser;
import io.undertow.server.protocol.http.ParseState;
import io.undertow.testutils.category.UnitTest;
import io.undertow.util.BadRequestException;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Deque;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.xnio.Option;
import org.xnio.OptionMap;

@Category(value={UnitTest.class})
public class SimpleParserTestCase {
    private final ParseState parseState = new ParseState(-1);

    @Test
    public void testEncodedSlashDisallowed() throws BadRequestException {
        byte[] in = "GET /somepath%2FotherPath HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/somepath%2FotherPath", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/somepath%2FotherPath", (Object)result.getRequestPath());
    }

    @Test
    public void testEncodedSlashAllowed() throws BadRequestException {
        byte[] in = "GET /somepath%2fotherPath HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/somepath/otherPath", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"/somepath%2fotherPath", (Object)result.getRequestURI());
    }

    @Test
    public void testColonSlashInURL() throws BadRequestException {
        byte[] in = "GET /a/http://myurl.com/b/c HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/a/http://myurl.com/b/c", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"/a/http://myurl.com/b/c", (Object)result.getRequestURI());
    }

    @Test
    public void testColonSlashInFullURL() throws BadRequestException {
        byte[] in = "GET http://foo.com/a/http://myurl.com/b/c HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/a/http://myurl.com/b/c", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"http://foo.com/a/http://myurl.com/b/c", (Object)result.getRequestURI());
    }

    @Test
    public void testMatrixParamFlag() throws BadRequestException {
        byte[] in = "GET /somepath;p1 HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/somepath;p1", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/somepath", (Object)result.getRequestPath());
        Assert.assertEquals((long)1L, (long)result.getPathParameters().size());
        Assert.assertEquals((Object)"p1", (Object)result.getPathParameters().keySet().toArray()[0]);
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertFalse((boolean)result.isHostIncludedInRequestURI());
    }

    @Test
    public void testMatrixParamFlagEndingWithNormalPath() throws BadRequestException {
        byte[] in = "GET /somepath;p1/more HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/somepath;p1/more", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/somepath/more", (Object)result.getRequestPath());
        Assert.assertEquals((long)1L, (long)result.getPathParameters().size());
        Assert.assertEquals((Object)"p1", (Object)result.getPathParameters().keySet().toArray()[0]);
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertFalse((boolean)result.isHostIncludedInRequestURI());
    }

    @Test
    public void testMultipleMatrixParamsOfSameName() throws BadRequestException {
        byte[] in = "GET /somepath;p1=v1;p1=v2 HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/somepath;p1=v1;p1=v2", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/somepath", (Object)result.getRequestPath());
        Assert.assertEquals((long)1L, (long)result.getPathParameters().size());
        Assert.assertEquals((Object)"p1", (Object)result.getPathParameters().keySet().toArray()[0]);
        Assert.assertEquals((Object)"v1", ((Deque)result.getPathParameters().get("p1")).getFirst());
        Assert.assertEquals((Object)"v2", ((Deque)result.getPathParameters().get("p1")).getLast());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertFalse((boolean)result.isHostIncludedInRequestURI());
    }

    @Test
    public void testCommaSeparatedParamValues() throws BadRequestException {
        byte[] in = "GET /somepath;p1=v1,v2 HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/somepath;p1=v1,v2", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/somepath", (Object)result.getRequestPath());
        Assert.assertEquals((long)1L, (long)result.getPathParameters().size());
        Assert.assertEquals((Object)"p1", (Object)result.getPathParameters().keySet().toArray()[0]);
        Assert.assertEquals((Object)"v1", ((Deque)result.getPathParameters().get("p1")).getFirst());
        Assert.assertEquals((Object)"v2", ((Deque)result.getPathParameters().get("p1")).getLast());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertFalse((boolean)result.isHostIncludedInRequestURI());
    }

    @Test
    public void testServletURLWithPathParam() throws BadRequestException {
        byte[] in = "GET http://localhost:7777/servletContext/aaaa/b;param=1 HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"http://localhost:7777/servletContext/aaaa/b;param=1", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/servletContext/aaaa/b", (Object)result.getRequestPath());
        Assert.assertEquals((long)1L, (long)result.getPathParameters().size());
        Assert.assertEquals((Object)"param", (Object)result.getPathParameters().keySet().toArray()[0]);
        Assert.assertEquals((Object)"1", ((Deque)result.getPathParameters().get("param")).getFirst());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertTrue((boolean)result.isHostIncludedInRequestURI());
    }

    @Test
    public void testServletURLWithPathParamEndingWithNormalPath() throws BadRequestException {
        byte[] in = "GET http://localhost:7777/servletContext/aaaa/b;param=1/cccc HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"http://localhost:7777/servletContext/aaaa/b;param=1/cccc", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/servletContext/aaaa/b/cccc", (Object)result.getRequestPath());
        Assert.assertEquals((long)1L, (long)result.getPathParameters().size());
        Assert.assertEquals((Object)"param", (Object)result.getPathParameters().keySet().toArray()[0]);
        Assert.assertEquals((Object)"1", ((Deque)result.getPathParameters().get("param")).getFirst());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertTrue((boolean)result.isHostIncludedInRequestURI());
    }

    @Test
    public void testServletURLWithPathParams() throws BadRequestException {
        byte[] in = "GET http://localhost:7777/servletContext/aa/b;foo=bar;mysessioncookie=mSwrYUX8_e3ukAylNMkg3oMRglB4-YjxqeWqXQsI HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"http://localhost:7777/servletContext/aa/b;foo=bar;mysessioncookie=mSwrYUX8_e3ukAylNMkg3oMRglB4-YjxqeWqXQsI", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/servletContext/aa/b", (Object)result.getRequestPath());
        Assert.assertEquals((long)2L, (long)result.getPathParameters().size());
        Assert.assertEquals((Object)"bar", ((Deque)result.getPathParameters().get("foo")).getFirst());
        Assert.assertEquals((Object)"mSwrYUX8_e3ukAylNMkg3oMRglB4-YjxqeWqXQsI", ((Deque)result.getPathParameters().get("mysessioncookie")).getFirst());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertTrue((boolean)result.isHostIncludedInRequestURI());
    }

    @Test
    public void testServletPathWithPathParam() throws BadRequestException {
        byte[] in = "GET /servletContext/aaaa/b;param=1 HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/servletContext/aaaa/b;param=1", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/servletContext/aaaa/b", (Object)result.getRequestPath());
        Assert.assertEquals((long)1L, (long)result.getPathParameters().size());
        Assert.assertEquals((Object)"param", (Object)result.getPathParameters().keySet().toArray()[0]);
        Assert.assertEquals((Object)"1", ((Deque)result.getPathParameters().get("param")).getFirst());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertFalse((boolean)result.isHostIncludedInRequestURI());
    }

    @Test
    public void testServletPathWithPathParams() throws BadRequestException {
        byte[] in = "GET /servletContext/aa/b;foo=bar;mysessioncookie=mSwrYUX8_e3ukAylNMkg3oMRglB4-YjxqeWqXQsI HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/servletContext/aa/b;foo=bar;mysessioncookie=mSwrYUX8_e3ukAylNMkg3oMRglB4-YjxqeWqXQsI", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/servletContext/aa/b", (Object)result.getRequestPath());
        Assert.assertEquals((long)2L, (long)result.getPathParameters().size());
        Assert.assertEquals((Object)"bar", ((Deque)result.getPathParameters().get("foo")).getFirst());
        Assert.assertEquals((Object)"mSwrYUX8_e3ukAylNMkg3oMRglB4-YjxqeWqXQsI", ((Deque)result.getPathParameters().get("mysessioncookie")).getFirst());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertFalse((boolean)result.isHostIncludedInRequestURI());
    }

    @Test
    public void testRootMatrixParam() throws BadRequestException {
        byte[] in = "GET ; HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)";", (Object)result.getRequestURI());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
    }

    @Test
    public void testMatrixParametersWithQueryString() throws BadRequestException {
        byte[] in = "GET /somepath;p1=v1;p2=v2?q1=v3 HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/somepath;p1=v1;p2=v2", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/somepath", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"v1", ((Deque)result.getPathParameters().get("p1")).getFirst());
        Assert.assertEquals((Object)"v2", ((Deque)result.getPathParameters().get("p2")).getFirst());
        Assert.assertEquals((Object)"q1=v3", (Object)result.getQueryString());
        Assert.assertEquals((Object)"v3", ((Deque)result.getQueryParameters().get("q1")).getFirst());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertFalse((boolean)result.isHostIncludedInRequestURI());
    }

    @Test
    public void testMultiLevelMatrixParameter() throws BadRequestException {
        byte[] in = "GET /some;p1=v1/path;p1=v2?q1=v3 HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/some;p1=v1/path;p1=v2", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/some/path", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"q1=v3", (Object)result.getQueryString());
        Assert.assertEquals((Object)"v1", ((Deque)result.getPathParameters().get("p1")).getFirst());
        Assert.assertEquals((Object)"v2", ((Deque)result.getPathParameters().get("p1")).getLast());
        Assert.assertEquals((Object)"v3", ((Deque)result.getQueryParameters().get("q1")).getFirst());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertFalse((boolean)result.isHostIncludedInRequestURI());
    }

    @Test
    public void testServletURLMultiLevelMatrixParameter() throws BadRequestException {
        byte[] in = "GET http://localhost:7777/some;p1=v1/path;p1=v2?q1=v3 HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"http://localhost:7777/some;p1=v1/path;p1=v2", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/some/path", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"q1=v3", (Object)result.getQueryString());
        Assert.assertEquals((Object)"v1", ((Deque)result.getPathParameters().get("p1")).getFirst());
        Assert.assertEquals((Object)"v2", ((Deque)result.getPathParameters().get("p1")).getLast());
        Assert.assertEquals((Object)"v3", ((Deque)result.getQueryParameters().get("q1")).getFirst());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertTrue((boolean)result.isHostIncludedInRequestURI());
    }

    @Test
    public void testMultiLevelMatrixParameters() throws BadRequestException {
        byte[] in = "GET /some;p1=v1/path;p2=v2?q1=v3 HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/some;p1=v1/path;p2=v2", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/some/path", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"q1=v3", (Object)result.getQueryString());
        Assert.assertEquals((Object)"v1", ((Deque)result.getPathParameters().get("p1")).getFirst());
        Assert.assertEquals((Object)"v2", ((Deque)result.getPathParameters().get("p2")).getFirst());
        Assert.assertEquals((Object)"v3", ((Deque)result.getQueryParameters().get("q1")).getFirst());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertFalse((boolean)result.isHostIncludedInRequestURI());
    }

    @Test
    public void testMultiLevelMatrixParameterEndingWithNormalPathAndQuery() throws BadRequestException {
        byte[] in = "GET /some;p1=v1/path;p1=v2/more?q1=v3 HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/some;p1=v1/path;p1=v2/more", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/some/path/more", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"q1=v3", (Object)result.getQueryString());
        Assert.assertEquals((Object)"v1", ((Deque)result.getPathParameters().get("p1")).getFirst());
        Assert.assertEquals((Object)"v2", ((Deque)result.getPathParameters().get("p1")).getLast());
        Assert.assertEquals((Object)"v3", ((Deque)result.getQueryParameters().get("q1")).getFirst());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertFalse((boolean)result.isHostIncludedInRequestURI());
    }

    @Test
    public void testServletURLMultiLevelMatrixParameterEndingWithNormalPathAndQuery() throws BadRequestException {
        byte[] in = "GET http://localhost:7777/some;p1=v1/path;p1=v2/more?q1=v3 HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"http://localhost:7777/some;p1=v1/path;p1=v2/more", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/some/path/more", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"q1=v3", (Object)result.getQueryString());
        Assert.assertEquals((Object)"v1", ((Deque)result.getPathParameters().get("p1")).getFirst());
        Assert.assertEquals((Object)"v2", ((Deque)result.getPathParameters().get("p1")).getLast());
        Assert.assertEquals((Object)"v3", ((Deque)result.getQueryParameters().get("q1")).getFirst());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertTrue((boolean)result.isHostIncludedInRequestURI());
    }

    @Test
    public void testFullUrlRootPath() throws BadRequestException {
        byte[] in = "GET http://myurl.com HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"http://myurl.com", (Object)result.getRequestURI());
        Assert.assertTrue((boolean)result.isHostIncludedInRequestURI());
    }

    @Test
    public void testSth() throws BadRequestException {
        byte[] in = "GET http://myurl.com/goo;foo=bar;blah=foobar HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/goo", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"http://myurl.com/goo;foo=bar;blah=foobar", (Object)result.getRequestURI());
        Assert.assertEquals((long)2L, (long)result.getPathParameters().size());
        Assert.assertTrue((boolean)result.isHostIncludedInRequestURI());
    }

    @Test(expected=BadRequestException.class)
    public void testLineEndingInsteadOfSpacesAfterVerb() throws BadRequestException {
        byte[] in = "GET\r/somepath HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test(expected=BadRequestException.class)
    public void testLineEndingInsteadOfSpacesAfterPath() throws BadRequestException {
        byte[] in = "GET /somepath\rHTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test(expected=BadRequestException.class)
    public void testLineEndingInsteadOfSpacesAfterVerb2() throws BadRequestException {
        byte[] in = "GET\n/somepath HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test(expected=BadRequestException.class)
    public void testLineEndingInsteadOfSpacesAfterVerb3() throws BadRequestException {
        byte[] in = "FOO\n/somepath HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test(expected=BadRequestException.class)
    public void testLineEndingInsteadOfSpacesAfterPath2() throws BadRequestException {
        byte[] in = "GET /somepath\nHTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test
    public void testSimpleRequest() throws BadRequestException {
        byte[] in = "GET /somepath HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test
    public void testDifferentCaseHeaders() throws BadRequestException {
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        byte[] in = "GET /somepath HTTP/1.1\r\nHost: www.somehost.net\r\nhost: other\r\n\r\n".getBytes();
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertArrayEquals((Object[])result.getRequestHeaders().get("HOST").toArray(), (Object[])new String[]{"www.somehost.net", "other"});
    }

    @Test(expected=BadRequestException.class)
    public void testTabInsteadOfSpaceAfterVerb() throws BadRequestException {
        byte[] in = "GET\t/somepath HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test(expected=BadRequestException.class)
    public void testTabInsteadOfSpaceAfterVerb2() throws BadRequestException {
        byte[] in = "FOO\t/somepath HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test(expected=BadRequestException.class)
    public void testTabInsteadOfSpaceAfterPath() throws BadRequestException {
        byte[] in = "GET\t/somepath HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test(expected=BadRequestException.class)
    public void testInvalidCharacterInPath() throws BadRequestException {
        byte[] in = "GET /some>path HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test(expected=BadRequestException.class)
    public void testInvalidCharacterInQueryString1() throws BadRequestException {
        byte[] in = "GET /somepath?foo>f=bar HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test(expected=BadRequestException.class)
    public void testInvalidCharacterInQueryString2() throws BadRequestException {
        byte[] in = "GET /somepath?foo=ba>r HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test(expected=BadRequestException.class)
    public void testInvalidCharacterInPathParam1() throws BadRequestException {
        byte[] in = "GET /somepath;foo>f=bar HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test(expected=BadRequestException.class)
    public void testInvalidCharacterInPathParam2() throws BadRequestException {
        byte[] in = "GET /somepath;foo=ba>r HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test
    public void testSimpleRequestWithHeaderCaching() throws BadRequestException {
        byte[] in = "GET /somepath HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: foo\r\n\r\n".getBytes();
        this.runTest(in, "foo");
        in = "GET /somepath HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader:       foo\r\n\r\n".getBytes();
        this.runTest(in, "foo");
        in = "GET /somepath HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader:      some value\r\n\r\n".getBytes();
        this.runTest(in);
        in = "GET /somepath HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some value\r\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test
    public void testCarriageReturnLineEnds() throws BadRequestException {
        byte[] in = "GET /somepath HTTP/1.1\rHost:   www.somehost.net\rOtherHeader: some\r    value\r\r\n".getBytes();
        this.runTest(in);
    }

    @Test
    public void testLineFeedsLineEnds() throws BadRequestException {
        byte[] in = "GET /somepath HTTP/1.1\nHost:   www.somehost.net\nOtherHeader: some\n    value\n\n".getBytes();
        this.runTest(in);
    }

    @Test(expected=BadRequestException.class)
    public void testTabWhitespace() throws BadRequestException {
        byte[] in = "GET\t/somepath\tHTTP/1.1\nHost: \t www.somehost.net\nOtherHeader:\tsome\n \t  value\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test
    public void testCanonicalPath() throws BadRequestException {
        byte[] in = "GET http://www.somehost.net/somepath HTTP/1.1\nHost: \t www.somehost.net\nOtherHeader:\tsome\n \t  value\n\r\n".getBytes();
        ParseState context = new ParseState(5);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertEquals((Object)"/somepath", (Object)result.getRelativePath());
        Assert.assertEquals((Object)"http://www.somehost.net/somepath", (Object)result.getRequestURI());
    }

    @Test
    public void testNoHeaders() throws BadRequestException {
        byte[] in = "GET /aa HTTP/1.1\n\n\n".getBytes();
        ParseState context = new ParseState(0);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertTrue((boolean)context.isComplete());
        Assert.assertEquals((Object)"/aa", (Object)result.getRelativePath());
    }

    @Test
    public void testQueryParams() throws BadRequestException {
        byte[] in = "GET http://www.somehost.net/somepath?a=b&b=c&d&e&f= HTTP/1.1\nHost: \t www.somehost.net\nOtherHeader:\tsome\n \t  value\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertEquals((Object)"/somepath", (Object)result.getRelativePath());
        Assert.assertEquals((Object)"http://www.somehost.net/somepath", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"a=b&b=c&d&e&f=", (Object)result.getQueryString());
        Assert.assertEquals((Object)"b", ((Deque)result.getQueryParameters().get("a")).getFirst());
        Assert.assertEquals((Object)"c", ((Deque)result.getQueryParameters().get("b")).getFirst());
        Assert.assertEquals((Object)"", ((Deque)result.getQueryParameters().get("d")).getFirst());
        Assert.assertEquals((Object)"", ((Deque)result.getQueryParameters().get("e")).getFirst());
        Assert.assertEquals((Object)"", ((Deque)result.getQueryParameters().get("f")).getFirst());
    }

    @Test
    public void testSameHttpStringReturned() throws BadRequestException {
        byte[] in = "GET http://www.somehost.net/somepath HTTP/1.1\nHost: \t www.somehost.net\nAccept-Charset:\tsome\n \t  value\n\r\n".getBytes();
        ParseState context1 = new ParseState(10);
        HttpServerExchange result1 = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), context1, result1);
        ParseState context2 = new ParseState(10);
        HttpServerExchange result2 = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), context2, result2);
        Assert.assertSame((Object)result1.getProtocol(), (Object)result2.getProtocol());
        Assert.assertSame((Object)result1.getRequestMethod(), (Object)result2.getRequestMethod());
        for (HttpString header : result1.getRequestHeaders().getHeaderNames()) {
            boolean found = false;
            for (HttpString header2 : result1.getRequestHeaders().getHeaderNames()) {
                if (header != header2) continue;
                found = true;
                break;
            }
            if (header.equals(Headers.HOST)) {
                Assert.assertSame((Object)Headers.HOST, (Object)header);
            }
            Assert.assertTrue((String)("Could not found header " + header), (boolean)found);
        }
    }

    @Test
    public void testPlusSignVsSpaceEncodingInPath() throws BadRequestException {
        byte[] in = "GET http://myurl.com/+/mypath%20with%20spaces HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((String)"+ in path shouldn't be treated as space, caused probably by https://issues.jboss.org/browse/UNDERTOW-1193", (Object)"/+/mypath with spaces", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"http://myurl.com/+/mypath%20with%20spaces", (Object)result.getRequestURI());
    }

    @Test
    public void testEmptyQueryParams() throws BadRequestException {
        byte[] in = "GET /clusterbench/requestinfo//?;?=44&test=OK;devil=3&&&&&&&&&&&&&&&&&&&&&&&&&&&&777=666 HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/clusterbench/requestinfo//", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/clusterbench/requestinfo//", (Object)result.getRequestPath());
        Assert.assertEquals((long)3L, (long)result.getQueryParameters().size());
        Assert.assertEquals((Object)"OK;devil=3", ((Deque)result.getQueryParameters().get("test")).getFirst());
        Assert.assertEquals((Object)"666", ((Deque)result.getQueryParameters().get("777")).getFirst());
        Assert.assertEquals((Object)"44", ((Deque)result.getQueryParameters().get(";?")).getFirst());
    }

    @Test(expected=BadRequestException.class)
    public void testNonEncodedAsciiCharacters() throws UnsupportedEncodingException, BadRequestException {
        byte[] in = "GET /b\u00c3\u00a5r HTTP/1.1\r\n\r\n".getBytes("ISO-8859-1");
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), context, result);
    }

    @Test
    public void testNonEncodedAsciiCharactersExplicitlyAllowed() throws UnsupportedEncodingException, BadRequestException {
        byte[] in = "GET /b\u00c3\u00a5r HTTP/1.1\r\n\r\n".getBytes("ISO-8859-1");
        ParseState context = new ParseState(10);
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_UNESCAPED_CHARACTERS_IN_URL, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/b\u00e5r", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"/b\u00c3\u00a5r", (Object)result.getRequestURI());
    }

    private void runTest(byte[] in) throws BadRequestException {
        this.runTest(in, "some value");
    }

    private void runTest(byte[] in, String lastHeader) throws BadRequestException {
        this.parseState.reset();
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), this.parseState, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/somepath", (Object)result.getRequestURI());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertEquals((long)2L, (long)result.getRequestHeaders().getHeaderNames().size());
        Assert.assertEquals((Object)"www.somehost.net", (Object)result.getRequestHeaders().getFirst(new HttpString("Host")));
        Assert.assertEquals((Object)lastHeader, (Object)result.getRequestHeaders().getFirst(new HttpString("OtherHeader")));
        Assert.assertEquals((long)8L, (long)this.parseState.state);
    }
}

