/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.NetworkUtils;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import org.junit.Assert;
import org.junit.Test;

public class NetworkUtilsAddressParsingTestCase {
    @Test
    public void testIpV4Address() throws IOException {
        InetAddress res = NetworkUtils.parseIpv4Address((String)"1.123.255.2");
        Assert.assertTrue((boolean)(res instanceof Inet4Address));
        Assert.assertEquals((long)1L, (long)res.getAddress()[0]);
        Assert.assertEquals((long)123L, (long)res.getAddress()[1]);
        Assert.assertEquals((long)-1L, (long)res.getAddress()[2]);
        Assert.assertEquals((long)2L, (long)res.getAddress()[3]);
        Assert.assertEquals((Object)"/1.123.255.2", (Object)res.toString());
        res = NetworkUtils.parseIpv4Address((String)"127.0.0.1");
        Assert.assertTrue((boolean)(res instanceof Inet4Address));
        Assert.assertEquals((long)127L, (long)res.getAddress()[0]);
        Assert.assertEquals((long)0L, (long)res.getAddress()[1]);
        Assert.assertEquals((long)0L, (long)res.getAddress()[2]);
        Assert.assertEquals((long)1L, (long)res.getAddress()[3]);
        Assert.assertEquals((Object)"/127.0.0.1", (Object)res.toString());
    }

    @Test(expected=IOException.class)
    public void testIpV4AddressWithLeadingZero() throws IOException {
        NetworkUtils.parseIpv4Address((String)"01.123.255.2");
    }

    @Test(expected=IOException.class)
    public void testIpV4AddressToSmall() throws IOException {
        NetworkUtils.parseIpv4Address((String)"01.123.255");
    }

    @Test(expected=IOException.class)
    public void testIpV4AddressToLarge() throws IOException {
        NetworkUtils.parseIpv4Address((String)"01.123.255.1.1");
    }

    @Test(expected=IOException.class)
    public void testIpV4AddressMultipleDots() throws IOException {
        NetworkUtils.parseIpv4Address((String)"1..255.2");
    }

    @Test(expected=IOException.class)
    public void testIpV4AddressMultipleDots2() throws IOException {
        NetworkUtils.parseIpv4Address((String)"1..3.255.2");
    }

    @Test(expected=IOException.class)
    public void testIpV4Hostname() throws IOException {
        NetworkUtils.parseIpv4Address((String)"localhost");
    }

    @Test(expected=IOException.class)
    public void testIpV4Hostname2() throws IOException {
        NetworkUtils.parseIpv4Address((String)"ff");
    }

    @Test(expected=IOException.class)
    public void testIpV4AddressStartsWithDot() throws IOException {
        NetworkUtils.parseIpv4Address((String)".1.123.255.2");
    }

    @Test
    public void testIpv6Address() throws IOException {
        int i;
        String addressString = "2001:1db8:100:3:6:ff00:42:8329";
        InetAddress res = NetworkUtils.parseIpv6Address((String)addressString);
        Assert.assertTrue((boolean)(res instanceof Inet6Address));
        int[] parts = new int[]{8193, 7608, 256, 3, 6, 65280, 66, 33577};
        for (i = 0; i < parts.length; ++i) {
            Assert.assertEquals((long)((byte)(parts[i] >> 8)), (long)res.getAddress()[i * 2]);
            Assert.assertEquals((long)((byte)parts[i]), (long)res.getAddress()[i * 2 + 1]);
        }
        Assert.assertEquals((Object)("/" + addressString), (Object)res.toString());
        addressString = "2001:1db8:100::6:ff00:42:8329";
        res = NetworkUtils.parseIpv6Address((String)addressString);
        Assert.assertTrue((boolean)(res instanceof Inet6Address));
        parts = new int[]{8193, 7608, 256, 0, 6, 65280, 66, 33577};
        for (i = 0; i < parts.length; ++i) {
            Assert.assertEquals((long)((byte)(parts[i] >> 8)), (long)res.getAddress()[i * 2]);
            Assert.assertEquals((long)((byte)parts[i]), (long)res.getAddress()[i * 2 + 1]);
        }
        Assert.assertEquals((Object)"/2001:1db8:100:0:6:ff00:42:8329", (Object)res.toString());
        addressString = "2001:1db8:100::ff00:42:8329";
        res = NetworkUtils.parseIpv6Address((String)addressString);
        Assert.assertTrue((boolean)(res instanceof Inet6Address));
        parts = new int[]{8193, 7608, 256, 0, 0, 65280, 66, 33577};
        for (i = 0; i < parts.length; ++i) {
            Assert.assertEquals((long)((byte)(parts[i] >> 8)), (long)res.getAddress()[i * 2]);
            Assert.assertEquals((long)((byte)parts[i]), (long)res.getAddress()[i * 2 + 1]);
        }
        Assert.assertEquals((Object)"/2001:1db8:100:0:0:ff00:42:8329", (Object)res.toString());
        addressString = "2001:1db8:0100:0000:0000:ff00:0042:8329";
        res = NetworkUtils.parseIpv6Address((String)addressString);
        Assert.assertTrue((boolean)(res instanceof Inet6Address));
        parts = new int[]{8193, 7608, 256, 0, 0, 65280, 66, 33577};
        for (i = 0; i < parts.length; ++i) {
            Assert.assertEquals((long)((byte)(parts[i] >> 8)), (long)res.getAddress()[i * 2]);
            Assert.assertEquals((long)((byte)parts[i]), (long)res.getAddress()[i * 2 + 1]);
        }
        Assert.assertEquals((Object)"/2001:1db8:100:0:0:ff00:42:8329", (Object)res.toString());
        addressString = "::1";
        res = NetworkUtils.parseIpv6Address((String)addressString);
        Assert.assertTrue((boolean)(res instanceof Inet6Address));
        parts = new int[]{0, 0, 0, 0, 0, 0, 0, 1};
        for (i = 0; i < parts.length; ++i) {
            Assert.assertEquals((long)((byte)(parts[i] >> 8)), (long)res.getAddress()[i * 2]);
            Assert.assertEquals((long)((byte)parts[i]), (long)res.getAddress()[i * 2 + 1]);
        }
        Assert.assertEquals((Object)"/0:0:0:0:0:0:0:1", (Object)res.toString());
    }

    @Test(expected=IOException.class)
    public void testIpV6AddressToSmall() throws IOException {
        NetworkUtils.parseIpv6Address((String)"2001:1db8:3:6:ff00:42:8329");
    }

    @Test(expected=IOException.class)
    public void testIpV6AddressToLarge() throws IOException {
        NetworkUtils.parseIpv6Address((String)"2001:1db8:100:3:6:7:ff00:42:8329");
    }

    @Test(expected=IOException.class)
    public void testIpV6AddressMultipleColons() throws IOException {
        NetworkUtils.parseIpv6Address((String)"2001:1db8:100::3:6:ff00:42:8329");
    }

    @Test(expected=IOException.class)
    public void testIpV6AddressMultipleColons2() throws IOException {
        NetworkUtils.parseIpv6Address((String)"2001::100::329");
    }

    @Test(expected=IOException.class)
    public void testIpV6Hostname() throws IOException {
        NetworkUtils.parseIpv6Address((String)"localhost");
    }

    @Test(expected=IOException.class)
    public void testIpV6Hostname2() throws IOException {
        NetworkUtils.parseIpv6Address((String)"ff");
    }

    @Test(expected=IOException.class)
    public void testIpV6AddressStartsWithColon() throws IOException {
        NetworkUtils.parseIpv6Address((String)":2001:1db8:100:3:6:ff00:42:8329");
    }
}

