/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.HttpContinueReadHandler;
import io.undertow.testutils.DefaultServer;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class HttpContinueConduitWrappingHandlerBufferLeakTestCase {
    static Socket persistentSocket;

    @BeforeClass
    public static void setup() {
        BlockingHandler blockingHandler = new BlockingHandler();
        HttpContinueReadHandler handler = new HttpContinueReadHandler((HttpHandler)blockingHandler);
        DefaultServer.setRootHandler((HttpHandler)handler);
        blockingHandler.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                try {
                    if (exchange.getQueryParameters().containsKey("reject")) {
                        exchange.getRequestChannel();
                        exchange.setStatusCode(417);
                        exchange.getOutputStream().close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Before
    public void before() {
        Assume.assumeFalse((boolean)DefaultServer.isAjp());
    }

    @Test
    public void testHttpContinueRejectedBodySentAnywayNoBufferLeak() throws IOException {
        persistentSocket = new Socket(DefaultServer.getHostAddress(), DefaultServer.getHostPort());
        String message = "POST /path?reject=true HTTP/1.1\r\nExpect: 100-continue\r\nContent-Length: 16\r\nContent-Type: text/plain; charset=ISO-8859-1\r\nHost: localhost:7777\r\nConnection: Keep-Alive\r\n\r\nMy HTTP Request!";
        persistentSocket.getOutputStream().write(message.getBytes(StandardCharsets.UTF_8));
        persistentSocket.getOutputStream().flush();
        persistentSocket.getInputStream().read();
    }

    @Test
    public void testHttpContinueBodySentAnywayNoLeak() throws IOException {
        persistentSocket = new Socket(DefaultServer.getHostAddress(), DefaultServer.getHostPort());
        String message = "POST /path HTTP/1.1\r\nExpect: 100-continue\r\nContent-Length: 16\r\nContent-Type: text/plain; charset=ISO-8859-1\r\nHost: localhost:7777\r\nConnection: Keep-Alive\r\n\r\nMy HTTP Request!";
        persistentSocket.getOutputStream().write(message.getBytes(StandardCharsets.UTF_8));
        persistentSocket.getOutputStream().flush();
        persistentSocket.getInputStream().read();
    }
}

