/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.encoding;

import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class EncodingSelectionTestCase {
    private static final String HEADER = "Content-Encoding";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicEncodingSelect() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            EncodingHandler handler = new EncodingHandler(new ContentEncodingRepository().addEncodingHandler("compress", ContentEncodingProvider.IDENTITY, 50).addEncodingHandler("bzip", ContentEncodingProvider.IDENTITY, 100)).setNext(new HttpHandler(){

                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    exchange.getResponseSender().send("hi");
                }
            });
            DefaultServer.setRootHandler((HttpHandler)handler);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header[] header = result.getHeaders(HEADER);
            Assert.assertEquals((long)0L, (long)header.length);
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "bzip");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            header = result.getHeaders(HEADER);
            Assert.assertEquals((Object)"bzip", (Object)header[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "bzip compress identity someOtherEncoding");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            header = result.getHeaders(HEADER);
            Assert.assertEquals((Object)"bzip", (Object)header[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", " compress, identity, someOtherEncoding,  bzip  , ");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            header = result.getHeaders(HEADER);
            Assert.assertEquals((Object)"bzip", (Object)header[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "boo; compress, identity; someOtherEncoding,   , ");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            header = result.getHeaders(HEADER);
            Assert.assertEquals((Object)"compress", (Object)header[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "boo; compress; identity; someOtherEncoding,   , ");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            header = result.getHeaders(HEADER);
            Assert.assertEquals((Object)"compress", (Object)header[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncodingSelectWithQValue() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            EncodingHandler handler = new EncodingHandler(new ContentEncodingRepository().addEncodingHandler("compress", ContentEncodingProvider.IDENTITY, 100).addEncodingHandler("bzip", ContentEncodingProvider.IDENTITY, 50)).setNext(new HttpHandler(){

                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    exchange.getResponseSender().send("hi");
                }
            });
            DefaultServer.setRootHandler((HttpHandler)handler);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "bzip, compress;q=0.6");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header[] header = result.getHeaders(HEADER);
            Assert.assertEquals((Object)"bzip", (Object)header[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "*;q=0.00");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)406L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "*;q=0.00 bzip");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            header = result.getHeaders(HEADER);
            Assert.assertEquals((Object)"bzip", (Object)header[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "*;q=0.00 bzip;q=0.3");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            header = result.getHeaders(HEADER);
            Assert.assertEquals((Object)"bzip", (Object)header[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "compress;q=0.1 bzip;q=0.05");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            header = result.getHeaders(HEADER);
            Assert.assertEquals((Object)"compress", (Object)header[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "compress;q=0.1, bzip;q=1.000");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            header = result.getHeaders(HEADER);
            Assert.assertEquals((Object)"bzip", (Object)header[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncodingSelectionWithQValueAndPredicate() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            EncodingHandler handler = new EncodingHandler(new ContentEncodingRepository().addEncodingHandler("compress", ContentEncodingProvider.IDENTITY, 100, Predicates.falsePredicate()).addEncodingHandler("bzip", ContentEncodingProvider.IDENTITY, 50)).setNext(new HttpHandler(){

                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    exchange.getResponseSender().send("hi");
                }
            });
            DefaultServer.setRootHandler((HttpHandler)handler);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "bzip, compress;q=0.6");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header[] header = result.getHeaders(HEADER);
            Assert.assertEquals((Object)"bzip", (Object)header[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "*;q=0.00");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)406L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "compress");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            header = result.getHeaders(HEADER);
            Assert.assertEquals((long)0L, (long)header.length);
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "*;q=0.00 bzip;q=0.3");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            header = result.getHeaders(HEADER);
            Assert.assertEquals((Object)"bzip", (Object)header[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "compress;q=0.1 bzip;q=0.05");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            header = result.getHeaders(HEADER);
            Assert.assertEquals((Object)"bzip", (Object)header[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Accept-Encoding", "compress;q=0.1, bzip;q=1.000");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            header = result.getHeaders(HEADER);
            Assert.assertEquals((Object)"bzip", (Object)header[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

