/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.blocking;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class BlockingServerStreamClosureTestCase {
    @Test
    public void testFlushAfterContentLengthReached() throws IOException {
        AtomicReference thrown = new AtomicReference();
        DefaultServer.setRootHandler((HttpHandler)new BlockingHandler(exchange -> {
            exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "1");
            try {
                OutputStream out = exchange.getOutputStream();
                out.write(65);
                out.flush();
                out.close();
            }
            catch (Throwable t) {
                thrown.set(t);
                throw t;
            }
        }));
        BlockingServerStreamClosureTestCase.makeSuccessfulRequest("A");
        Throwable maybeFailure = (Throwable)thrown.get();
        if (maybeFailure != null) {
            throw new AssertionError("Unexpected failure", maybeFailure);
        }
    }

    @Test
    public void testEmptyWriteAfterContentLength() throws IOException {
        AtomicReference thrown = new AtomicReference();
        DefaultServer.setRootHandler((HttpHandler)new BlockingHandler(exchange -> {
            exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "1");
            try {
                OutputStream out = exchange.getOutputStream();
                out.write(65);
                out.write(new byte[10], 2, 0);
                out.close();
            }
            catch (Throwable t) {
                thrown.set(t);
                throw t;
            }
        }));
        BlockingServerStreamClosureTestCase.makeSuccessfulRequest("A");
        Throwable maybeFailure = (Throwable)thrown.get();
        if (maybeFailure != null) {
            throw new AssertionError("Unexpected failure", maybeFailure);
        }
    }

    @Test
    public void testFlushAfterClose() throws IOException {
        AtomicReference thrown = new AtomicReference();
        DefaultServer.setRootHandler((HttpHandler)new BlockingHandler(exchange -> {
            try {
                OutputStream out = exchange.getOutputStream();
                out.write(65);
                out.close();
                out.flush();
            }
            catch (Throwable t) {
                thrown.set(t);
                throw t;
            }
        }));
        BlockingServerStreamClosureTestCase.makeSuccessfulRequest("A");
        Throwable maybeFailure = (Throwable)thrown.get();
        if (maybeFailure != null) {
            throw new AssertionError("Unexpected failure", maybeFailure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeSuccessfulRequest(String expectedContent) throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)expectedContent, (Object)HttpClientUtils.readResponse((HttpResponse)result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

