/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.testutils.category.UnitTest;
import io.undertow.util.FlexBase64;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnitTest.class})
public class FlexBase64TestCase {
    @Test
    public void testReadStopsAtTerminator() throws Exception {
        String source = "ZWxsbw===";
        byte[] target = new byte[1024];
        FlexBase64.Decoder decoder = FlexBase64.createDecoder();
        int read = decoder.decode(source, 0, source.length(), target, 0, target.length);
        Assert.assertEquals((long)4L, (long)read);
        Assert.assertEquals((Object)"ello", (Object)new String(target, 0, read));
        Assert.assertEquals((long)8L, (long)decoder.getLastInputPosition());
    }

    @Test
    public void testEncodeURLWithByteBufferUsesUrlTable() {
        ByteBuffer source = ByteBuffer.wrap(new byte[]{0, 1, 0, 0, 16, 0, 0, 2, 0, 0, 0, 1, 0, 4, 0, 0, -1, -1, 0, 5, 0, 0, 64, 0});
        String target = FlexBase64.encodeStringURL((ByteBuffer)source, (boolean)false);
        Assert.assertEquals((Object)"AAEAABAAAAIAAAABAAQAAP__AAUAAEAA", (Object)target);
    }
}

