/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.ssl;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.NameVirtualHostHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.error.SimpleErrorPageHandler;
import io.undertow.server.handlers.file.FileHandlerTestCase;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@AjpIgnore
@RunWith(value=DefaultServer.class)
public class ComplexSSLTestCase {
    private static final String MESSAGE = "My HTTP Request!";
    private static volatile String message;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void complexSSLTestCase() throws IOException, GeneralSecurityException, URISyntaxException, InterruptedException {
        NameVirtualHostHandler virtualHostHandler;
        PathHandler pathHandler = new PathHandler();
        Path rootPath = Paths.get(FileHandlerTestCase.class.getResource("page.html").toURI()).getParent();
        NameVirtualHostHandler root = virtualHostHandler = new NameVirtualHostHandler();
        root = new SimpleErrorPageHandler((HttpHandler)root);
        root = new CanonicalPathHandler((HttpHandler)root);
        virtualHostHandler.addHost("default-host", (HttpHandler)pathHandler);
        virtualHostHandler.setDefaultHandler((HttpHandler)pathHandler);
        pathHandler.addPrefixPath("/", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(rootPath, 0xA00000L)).setDirectoryListingEnabled(true));
        DefaultServer.setRootHandler((HttpHandler)root);
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            HttpGet getFileList = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
            CloseableHttpResponse resultList = client.execute((HttpUriRequest)getFileList);
            Assert.assertEquals((long)200L, (long)resultList.getStatusLine().getStatusCode());
            String responseList = HttpClientUtils.readResponse((HttpResponse)resultList);
            Assert.assertTrue((String)responseList, (boolean)responseList.contains("page.html"));
            Header[] headersList = resultList.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html; charset=UTF-8", (Object)headersList[0].getValue());
            HttpGet getFile = new HttpGet(DefaultServer.getDefaultServerSSLAddress() + "/page.html");
            CloseableHttpResponse result = client.execute((HttpUriRequest)getFile);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Header[] headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
            Assert.assertTrue((String)response, (boolean)response.contains("A web page"));
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testSslLotsOfData() throws IOException, GeneralSecurityException, URISyntaxException {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (exchange.isInIoThread()) {
                    exchange.dispatch((HttpHandler)this);
                    return;
                }
                exchange.startBlocking();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[100];
                int res = 0;
                while ((res = exchange.getInputStream().read(buf)) > 0) {
                    out.write(buf, 0, res);
                }
                System.out.println("WRITE " + out.size());
                exchange.getOutputStream().write(out.toByteArray());
                System.out.println("DONE " + out.size());
            }
        });
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            ComplexSSLTestCase.generateMessage(1000000);
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerSSLAddress());
            post.setEntity((HttpEntity)new StringEntity(message));
            CloseableHttpResponse resultList = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)resultList.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)resultList);
            Assert.assertEquals((long)message.length(), (long)response.length());
            Assert.assertEquals((Object)message, (Object)response);
            ComplexSSLTestCase.generateMessage(100000);
            post = new HttpPost(DefaultServer.getDefaultServerSSLAddress());
            post.setEntity((HttpEntity)new StringEntity(message));
            resultList = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)resultList.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)resultList);
            Assert.assertEquals((long)message.length(), (long)response.length());
            Assert.assertEquals((Object)message, (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }

    private static void generateMessage(int repetitions) {
        StringBuilder builder = new StringBuilder(repetitions * MESSAGE.length());
        for (int i = 0; i < repetitions; ++i) {
            builder.append(MESSAGE);
        }
        message = builder.toString();
    }
}

