/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.Undertow;
import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.client.ALPNClientSelector;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientProvider;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.http.HttpClientProvider;
import io.undertow.client.http2.DoSHttp2ClientConnection;
import io.undertow.client.http2.Http2ClientConnection;
import io.undertow.connector.ByteBufferPool;
import io.undertow.io.Sender;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.http2.Http2GoAwayStreamSourceChannel;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.StopServerWithExternalWorkerUtils;
import io.undertow.testutils.category.UnitTest;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.StringReadChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.security.AccessController;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.ssl.SslConnection;

@Category(value={UnitTest.class})
public class RapidResetDDoSUnitTestCase {
    private static final String message = "Hello World!";
    public static final String MESSAGE = "/message";
    public static final String POST = "/post";
    private static XnioWorker worker;
    private static Undertow defaultConfigServer;
    private static Undertow overwrittenConfigServer;
    private static final OptionMap DEFAULT_OPTIONS;
    private static URI defaultConfigServerAddress;
    private static URI overwrittenConfigServerAddress;
    private static final AttachmentKey<String> RESPONSE_BODY;
    private static volatile DoSHttp2ClientConnection clientConnection;
    private IOException exception;

    static void sendMessage(HttpServerExchange exchange) {
        exchange.setStatusCode(200);
        Sender sender = exchange.getResponseSender();
        sender.send(message);
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        int port = DefaultServer.getHostPort("default");
        PathHandler path = new PathHandler().addExactPath(MESSAGE, RapidResetDDoSUnitTestCase::sendMessage).addExactPath(POST, exchange -> exchange.getRequestReceiver().receiveFullString((exchange1, message) -> exchange1.getResponseSender().send(message)));
        defaultConfigServer = Undertow.builder().addHttpsListener(port + 1, DefaultServer.getHostAddress("default"), DefaultServer.getServerSslContext()).setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler(arg_0 -> ((PathHandler)path).handleRequest(arg_0)).build();
        defaultConfigServer.start();
        overwrittenConfigServer = Undertow.builder().addHttpsListener(port + 2, DefaultServer.getHostAddress("default"), DefaultServer.getServerSslContext()).setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true).setServerOption(UndertowOptions.RST_FRAMES_TIME_WINDOW, (Object)5000).setServerOption(UndertowOptions.MAX_RST_FRAMES_PER_WINDOW, (Object)50).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler(arg_0 -> ((PathHandler)path).handleRequest(arg_0)).build();
        overwrittenConfigServer.start();
        defaultConfigServerAddress = new URI("https://" + DefaultServer.getHostAddress() + ":" + (port + 1));
        overwrittenConfigServerAddress = new URI("https://" + DefaultServer.getHostAddress() + ":" + (port + 2));
        worker = Xnio.getInstance().createWorker(null, DEFAULT_OPTIONS);
    }

    @AfterClass
    public static void afterClass() {
        if (defaultConfigServer != null) {
            defaultConfigServer.stop();
        }
        if (overwrittenConfigServer != null) {
            overwrittenConfigServer.stop();
        }
        if (worker != null) {
            StopServerWithExternalWorkerUtils.stopWorker(worker);
        }
    }

    @Test
    public void testGoAwayWithDefaultConfig() throws Exception {
        System.out.println("go away with default config");
        this.assertDoSRstFramesHandled(300, 200, true, defaultConfigServerAddress);
    }

    @Test
    public void testNoErrorWithDefaultConfig() throws Exception {
        System.out.println("no error with default config");
        this.assertDoSRstFramesHandled(150, 200, false, defaultConfigServerAddress);
    }

    @Test
    public void testGoAwayWithOverwrittenConfig() throws Exception {
        System.out.println("go away with overwritten config");
        this.assertDoSRstFramesHandled(100, 50, true, overwrittenConfigServerAddress);
    }

    @Test
    public void testNoErrorWithOverwrittenConfig() throws Exception {
        System.out.println("no error with overwritten config");
        this.assertDoSRstFramesHandled(50, 50, false, overwrittenConfigServerAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertDoSRstFramesHandled(int totalNumberOfRequests, int rstStreamLimit, boolean errorExpected, URI serverAddress) throws Exception {
        CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        CountDownLatch latch = new CountDownLatch(totalNumberOfRequests);
        ServiceLoader providers = AccessController.doPrivileged(() -> ServiceLoader.load(ClientProvider.class, this.getClass().getClassLoader()));
        ClientProvider clientProvider = null;
        block4: for (ClientProvider provider : providers) {
            for (String scheme : provider.handlesSchemes()) {
                if (!scheme.equals(serverAddress.getScheme())) continue;
                clientProvider = provider;
                continue block4;
            }
        }
        Assert.assertNotNull(clientProvider);
        final FutureResult result = new FutureResult();
        ClientCallback<ClientConnection> listener = new ClientCallback<ClientConnection>(){

            public void completed(ClientConnection r) {
                result.setResult((Object)r);
            }

            public void failed(IOException e) {
                result.setException(e);
            }
        };
        UndertowXnioSsl ssl = new UndertowXnioSsl(worker.getXnio(), OptionMap.EMPTY, DefaultServer.getClientSSLContext());
        OptionMap tlsOptions = OptionMap.builder().set(UndertowOptions.ENDPOINT_IDENTIFICATION_ALGORITHM, (Object)(HttpClientProvider.DISABLE_HTTPS_ENDPOINT_IDENTIFICATION ? "" : "HTTPS")).set(Options.SSL_STARTTLS, true).getMap();
        ChannelListener openListener = arg_0 -> RapidResetDDoSUnitTestCase.lambda$assertDoSRstFramesHandled$4((ClientCallback)listener, serverAddress, tlsOptions, arg_0);
        ssl.openSslConnection(worker, new InetSocketAddress(serverAddress.getHost(), serverAddress.getPort()), openListener, tlsOptions).addNotifier((arg_0, arg_1) -> RapidResetDDoSUnitTestCase.lambda$assertDoSRstFramesHandled$5((ClientCallback)listener, arg_0, arg_1), null);
        ClientConnection connection = (ClientConnection)result.getIoFuture().get();
        try {
            connection.getIoThread().execute(() -> {
                for (int i = 0; i < totalNumberOfRequests; ++i) {
                    ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(MESSAGE);
                    request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                    connection.sendRequest(request, this.createClientCallback(responses, latch));
                }
            });
            latch.await(200L, TimeUnit.SECONDS);
            if (responses.isEmpty()) {
                Assert.assertTrue((boolean)errorExpected);
                Assert.assertNotNull((Object)this.exception);
                Assert.assertTrue((boolean)(this.exception instanceof ClosedChannelException));
                return;
            }
            Assert.assertEquals((long)(errorExpected ? (long)(rstStreamLimit + 1) : (long)totalNumberOfRequests), (long)responses.size());
            for (ClientResponse response : responses) {
                String responseBody = (String)response.getAttachment(RESPONSE_BODY);
                Assert.assertTrue((String)("Unexpected response body: " + responseBody), (responseBody.isEmpty() || responseBody.equals(message) ? 1 : 0) != 0);
            }
            if (errorExpected) {
                Assert.assertNotNull((Object)this.exception);
                Assert.assertTrue((boolean)(this.exception instanceof ClosedChannelException));
                Http2GoAwayStreamSourceChannel http2GoAwayStreamSourceChannel = clientConnection.getGoAwayStreamSourceChannel();
                Assert.assertNotNull((Object)http2GoAwayStreamSourceChannel);
                Assert.assertEquals((long)11L, (long)http2GoAwayStreamSourceChannel.getStatus());
            } else {
                Assert.assertNull((Object)this.exception);
                Assert.assertNull((Object)clientConnection.getGoAwayStreamSourceChannel());
            }
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    public static ALPNClientSelector.ALPNProtocol alpnProtocol(ClientCallback<ClientConnection> listener, String defaultHost, ByteBufferPool bufferPool, OptionMap options) {
        return new ALPNClientSelector.ALPNProtocol(connection -> listener.completed((Object)RapidResetDDoSUnitTestCase.createHttp2Channel((StreamConnection)connection, bufferPool, options, defaultHost)), "h2");
    }

    private static Http2ClientConnection createHttp2Channel(StreamConnection connection, ByteBufferPool bufferPool, OptionMap options, String defaultHost) {
        Http2Channel http2Channel = new Http2Channel(connection, null, bufferPool, null, true, false, options);
        clientConnection = new DoSHttp2ClientConnection(http2Channel, false, defaultHost, null, true);
        return clientConnection;
    }

    private ClientCallback<ClientExchange> createClientCallback(final List<ClientResponse> responses, final CountDownLatch latch) {
        return new ClientCallback<ClientExchange>(){

            public void completed(ClientExchange result) {
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(final ClientExchange result) {
                        responses.add(result.getResponse());
                        new StringReadChannelListener(result.getConnection().getBufferPool()){

                            protected void stringDone(String string) {
                                result.getResponse().putAttachment(RESPONSE_BODY, (Object)string);
                                latch.countDown();
                            }

                            protected void error(IOException e) {
                                e.printStackTrace();
                                RapidResetDDoSUnitTestCase.this.exception = e;
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    public void failed(IOException e) {
                        e.printStackTrace();
                        RapidResetDDoSUnitTestCase.this.exception = e;
                        latch.countDown();
                    }
                });
                try {
                    result.getRequestChannel().shutdownWrites();
                    if (!result.getRequestChannel().flush()) {
                        result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    RapidResetDDoSUnitTestCase.this.exception = e;
                    latch.countDown();
                }
            }

            public void failed(IOException e) {
                e.printStackTrace();
                RapidResetDDoSUnitTestCase.this.exception = e;
                latch.countDown();
            }
        };
    }

    private static /* synthetic */ void lambda$assertDoSRstFramesHandled$5(ClientCallback listener, IoFuture ioFuture, Object o) {
        if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
            listener.failed(ioFuture.getException());
        }
    }

    private static /* synthetic */ void lambda$assertDoSRstFramesHandled$4(ClientCallback listener, URI serverAddress, OptionMap tlsOptions, StreamConnection connection) {
        ALPNClientSelector.runAlpn((SslConnection)((SslConnection)connection), connection1 -> {
            UndertowLogger.ROOT_LOGGER.alpnConnectionFailed(connection1);
            IoUtils.safeClose((Closeable)connection1);
        }, (ClientCallback)listener, (ALPNClientSelector.ALPNProtocol[])new ALPNClientSelector.ALPNProtocol[]{RapidResetDDoSUnitTestCase.alpnProtocol((ClientCallback<ClientConnection>)listener, serverAddress.getHost(), DefaultServer.getBufferPool(), tlsOptions)});
    }

    static {
        RESPONSE_BODY = AttachmentKey.create(String.class);
        OptionMap.Builder builder = OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.TCP_NODELAY, true).set(Options.KEEP_ALIVE, true).set(Options.WORKER_NAME, (Object)"Client");
        DEFAULT_OPTIONS = builder.getMap();
    }
}

