/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.testutils;

import io.undertow.testutils.DefaultServer;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.Statement;

public class RunDefaultServer
extends Statement {
    private final Statement next;
    private final RunNotifier runNotifier;
    private boolean stopTheServer;

    RunDefaultServer(Statement next, RunNotifier runNotifier) {
        this.next = next;
        this.runNotifier = runNotifier;
    }

    public void stopTheServerWhenDone() {
        this.stopTheServer = true;
    }

    public void evaluate() throws Throwable {
        if (DefaultServer.startServer() && !this.stopTheServer) {
            this.runNotifier.addListener(new RunListener(){

                public void testRunFinished(Result result) {
                    DefaultServer.stopServer();
                }
            });
        }
        try {
            this.next.evaluate();
        }
        finally {
            if (this.stopTheServer) {
                DefaultServer.stopServer();
            }
        }
    }
}

