package io.undertow.websockets.core;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import java.io.UnsupportedEncodingException;
import io.undertow.websockets.core.WebSocketFrameCorruptedException;
import java.io.IOException;
import java.lang.String;
import java.util.zip.DataFormatException;
import io.undertow.websockets.core.WebSocketInvalidCloseCodeException;
import java.util.Collection;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketHandshakeException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2024-04-19T02:59:37-0300")
public class WebSocketMessages_$bundle implements WebSocketMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected WebSocketMessages_$bundle() {}
    public static final WebSocketMessages_$bundle INSTANCE = new WebSocketMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String channelClosed$str() {
        return "UT002002: Channel is closed";
    }
    @Override
    public final IOException channelClosed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), channelClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidTextFrameEncoding$str() {
        return "UT002003: Text frame contains non UTF-8 data";
    }
    @Override
    public final UnsupportedEncodingException invalidTextFrameEncoding() {
        final UnsupportedEncodingException result = new UnsupportedEncodingException(String.format(getLoggingLocale(), invalidTextFrameEncoding$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fragmentedControlFrame$str() {
        return "UT002005: Fragmented control frame";
    }
    @Override
    public final io.undertow.websockets.core.WebSocketFrameCorruptedException fragmentedControlFrame() {
        final io.undertow.websockets.core.WebSocketFrameCorruptedException result = new io.undertow.websockets.core.WebSocketFrameCorruptedException(String.format(getLoggingLocale(), fragmentedControlFrame$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String toBigControlFrame$str() {
        return "UT002006: Control frame with payload length > 125 octets";
    }
    @Override
    public final io.undertow.websockets.core.WebSocketFrameCorruptedException toBigControlFrame() {
        final io.undertow.websockets.core.WebSocketFrameCorruptedException result = new io.undertow.websockets.core.WebSocketFrameCorruptedException(String.format(getLoggingLocale(), toBigControlFrame$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String reservedOpCodeInControlFrame$str() {
        return "UT002007: Control frame using reserved opcode = %s";
    }
    @Override
    public final io.undertow.websockets.core.WebSocketFrameCorruptedException reservedOpCodeInControlFrame(final int opCode) {
        final io.undertow.websockets.core.WebSocketFrameCorruptedException result = new io.undertow.websockets.core.WebSocketFrameCorruptedException(String.format(getLoggingLocale(), reservedOpCodeInControlFrame$str(), opCode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String controlFrameWithPayloadLen1$str() {
        return "UT002008: Received close control frame with payload len 1";
    }
    @Override
    public final io.undertow.websockets.core.WebSocketFrameCorruptedException controlFrameWithPayloadLen1() {
        final io.undertow.websockets.core.WebSocketFrameCorruptedException result = new io.undertow.websockets.core.WebSocketFrameCorruptedException(String.format(getLoggingLocale(), controlFrameWithPayloadLen1$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String reservedOpCodeInDataFrame$str() {
        return "UT002009: Data frame using reserved opcode = %s";
    }
    @Override
    public final io.undertow.websockets.core.WebSocketFrameCorruptedException reservedOpCodeInDataFrame(final int opCode) {
        final io.undertow.websockets.core.WebSocketFrameCorruptedException result = new io.undertow.websockets.core.WebSocketFrameCorruptedException(String.format(getLoggingLocale(), reservedOpCodeInDataFrame$str(), opCode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String continuationFrameOutsideFragmented$str() {
        return "UT002010: Received continuation data frame outside fragmented message";
    }
    @Override
    public final io.undertow.websockets.core.WebSocketFrameCorruptedException continuationFrameOutsideFragmented() {
        final io.undertow.websockets.core.WebSocketFrameCorruptedException result = new io.undertow.websockets.core.WebSocketFrameCorruptedException(String.format(getLoggingLocale(), continuationFrameOutsideFragmented$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonContinuationFrameInsideFragmented$str() {
        return "UT002011: Received non-continuation data frame while inside fragmented message";
    }
    @Override
    public final io.undertow.websockets.core.WebSocketFrameCorruptedException nonContinuationFrameInsideFragmented() {
        final io.undertow.websockets.core.WebSocketFrameCorruptedException result = new io.undertow.websockets.core.WebSocketFrameCorruptedException(String.format(getLoggingLocale(), nonContinuationFrameInsideFragmented$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedOpCode$str() {
        return "UT002013: Cannot decode web socket frame with opcode: %s";
    }
    @Override
    public final IllegalStateException unsupportedOpCode(final int opCode) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unsupportedOpCode$str(), opCode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedFrameType$str() {
        return "UT002014: WebSocketFrameType %s is not supported by this WebSocketChannel\"";
    }
    @Override
    public final IllegalArgumentException unsupportedFrameType(final io.undertow.websockets.core.WebSocketFrameType type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unsupportedFrameType$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String extensionsNotAllowed$str() {
        return "UT002015: Extensions not allowed but received rsv of %s";
    }
    @Override
    public final io.undertow.websockets.core.WebSocketFrameCorruptedException extensionsNotAllowed(final int rsv) {
        final io.undertow.websockets.core.WebSocketFrameCorruptedException result = new io.undertow.websockets.core.WebSocketFrameCorruptedException(String.format(getLoggingLocale(), extensionsNotAllowed$str(), rsv));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedProtocol$str() {
        return "UT002016: Could not find supported protocol in request list %s. Supported protocols are %s";
    }
    @Override
    public final io.undertow.websockets.core.WebSocketHandshakeException unsupportedProtocol(final String requestedSubprotocols, final Collection<String> subprotocols) {
        final io.undertow.websockets.core.WebSocketHandshakeException result = new io.undertow.websockets.core.WebSocketHandshakeException(String.format(getLoggingLocale(), unsupportedProtocol$str(), requestedSubprotocols, subprotocols));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPayloadLengthForPing$str() {
        return "UT002019: Invalid payload for PING (payload length must be <= 125, was %s)";
    }
    @Override
    public final IllegalArgumentException invalidPayloadLengthForPing(final long payloadLength) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPayloadLengthForPing$str(), payloadLength));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String extensionsNotSupported$str() {
        return "UT002023: Extensions not supported";
    }
    @Override
    public final UnsupportedOperationException extensionsNotSupported() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), extensionsNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCloseFrameStatusCode$str() {
        return "UT002026: Invalid close frame status code: %s";
    }
    @Override
    public final io.undertow.websockets.core.WebSocketInvalidCloseCodeException invalidCloseFrameStatusCode(final int statusCode) {
        final io.undertow.websockets.core.WebSocketInvalidCloseCodeException result = new io.undertow.websockets.core.WebSocketInvalidCloseCodeException(String.format(getLoggingLocale(), invalidCloseFrameStatusCode$str(), statusCode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String streamIsBroken$str() {
        return "UT002027: Could not send data, as the underlying web socket connection has been broken";
    }
    @Override
    public final IOException streamIsBroken() {
        final IOException result = new IOException(String.format(getLoggingLocale(), streamIsBroken$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String frameNotMasked$str() {
        return "UT002034: Web socket frame was not masked";
    }
    @Override
    public final io.undertow.websockets.core.WebSocketFrameCorruptedException frameNotMasked() {
        final io.undertow.websockets.core.WebSocketFrameCorruptedException result = new io.undertow.websockets.core.WebSocketFrameCorruptedException(String.format(getLoggingLocale(), frameNotMasked$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noWebSocketUpgradeHeader$str() {
        return "UT002035: The response did not contain an 'Upgrade: websocket' header";
    }
    @Override
    public final IOException noWebSocketUpgradeHeader() {
        final IOException result = new IOException(String.format(getLoggingLocale(), noWebSocketUpgradeHeader$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noWebSocketConnectionHeader$str() {
        return "UT002036: The response did not contain a 'Connection: upgrade' header";
    }
    @Override
    public final IOException noWebSocketConnectionHeader() {
        final IOException result = new IOException(String.format(getLoggingLocale(), noWebSocketConnectionHeader$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String webSocketAcceptKeyMismatch$str() {
        return "UT002037: Sec-WebSocket-Accept mismatch, expecting %s, received %s";
    }
    @Override
    public final IOException webSocketAcceptKeyMismatch(final String dKey, final String acceptKey) {
        final IOException result = new IOException(String.format(getLoggingLocale(), webSocketAcceptKeyMismatch$str(), dKey, acceptKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String messageToBig$str() {
        return "UT002040: Message exceeded max message size of %s";
    }
    @Override
    public final String messageToBig(final long maxMessageSize) {
        return String.format(getLoggingLocale(), messageToBig$str(), maxMessageSize);
    }
    protected String badCompressedPayload$str() {
        return "UT002044: Compressed message payload is corrupted";
    }
    @Override
    public final IOException badCompressedPayload(final DataFormatException cause) {
        final IOException result = new IOException(String.format(getLoggingLocale(), badCompressedPayload$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToSendOnNewChannel$str() {
        return "UT002045: Unable to send on newly created channel!";
    }
    @Override
    public final IllegalStateException unableToSendOnNewChannel() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToSendOnNewChannel$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String messageCloseWebSocket$str() {
        return "UT002046: Closing WebSocket, peer went away.";
    }
    @Override
    public final String messageCloseWebSocket() {
        return String.format(getLoggingLocale(), messageCloseWebSocket$str());
    }
}
