/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http2;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.logging.LogLevel;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http2.Http2ServerConnection;
import io.undertow.server.protocol.http2.Http2UpgradeHandler;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.util.HttpString;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.Options;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
public class HTTP2ViaUpgradeTestCase {
    static Undertow server;
    static volatile String message;
    private static final LinkedBlockingDeque<String> messages;

    @BeforeClass
    public static void setup() throws URISyntaxException {
        SessionCookieConfig sessionConfig = new SessionCookieConfig();
        int port = DefaultServer.getHostPort("default");
        server = Undertow.builder().addHttpListener(port + 1, DefaultServer.getHostAddress("default")).setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler((HttpHandler)Handlers.header((HttpHandler)new Http2UpgradeHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (!(exchange.getConnection() instanceof Http2ServerConnection)) {
                    throw new RuntimeException("Not HTTP2");
                }
                exchange.getResponseHeaders().add(new HttpString("X-Custom-Header"), "foo");
                exchange.getResponseSender().send(message);
            }
        }, new String[]{"h2c", "h2c-17"}), (String)"Sec-WebSocket-Accept", (String)"fake")).build();
        server.start();
    }

    @AfterClass
    public static void stop() {
        server.stop();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttp2WithNettyClient() throws Exception {
        message = "Hello World";
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        Http2ClientInitializer initializer = new Http2ClientInitializer(Integer.MAX_VALUE);
        try {
            Bootstrap b = new Bootstrap();
            b.group((EventLoopGroup)workerGroup);
            b.channel(NioSocketChannel.class);
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            int port = DefaultServer.getHostPort("default") + 1;
            String host = DefaultServer.getHostAddress("default");
            b.remoteAddress(host, port);
            b.handler((ChannelHandler)initializer);
            Channel channel = b.connect().syncUninterruptibly().channel();
            Http2SettingsHandler http2SettingsHandler = initializer.settingsHandler();
            http2SettingsHandler.awaitSettings(5L, TimeUnit.SECONDS);
            HttpResponseHandler responseHandler = initializer.responseHandler();
            int streamId = 3;
            URI hostName = URI.create("http://" + host + ':' + port);
            System.err.println("Sending request(s)...");
            ChannelPromise promise = channel.newPromise();
            responseHandler.put(streamId, promise);
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, hostName.toString());
            request.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)hostName);
            request.headers().add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP);
            request.headers().add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.DEFLATE);
            channel.writeAndFlush((Object)request);
            streamId += 2;
            promise.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)message, (Object)messages.poll());
            System.out.println("Finished HTTP/2 request(s)");
            channel.close().syncUninterruptibly();
        }
        finally {
            workerGroup.shutdownGracefully();
        }
    }

    static {
        messages = new LinkedBlockingDeque();
    }

    static class HttpResponseHandler
    extends SimpleChannelInboundHandler<FullHttpResponse> {
        private SortedMap<Integer, ChannelPromise> streamidPromiseMap = new TreeMap<Integer, ChannelPromise>();

        HttpResponseHandler() {
        }

        public ChannelPromise put(int streamId, ChannelPromise promise) {
            return this.streamidPromiseMap.put(streamId, promise);
        }

        public void awaitResponses(long timeout, TimeUnit unit) {
            Iterator<Map.Entry<Integer, ChannelPromise>> itr = this.streamidPromiseMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<Integer, ChannelPromise> entry = itr.next();
                ChannelPromise promise = entry.getValue();
                if (!promise.awaitUninterruptibly(timeout, unit)) {
                    throw new IllegalStateException("Timed out waiting for response on stream id " + entry.getKey());
                }
                if (!promise.isSuccess()) {
                    throw new RuntimeException(promise.cause());
                }
                System.out.println("---Stream id: " + entry.getKey() + " received---");
                itr.remove();
            }
        }

        protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
            Integer streamId = msg.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
            if (streamId == null) {
                System.err.println("HttpResponseHandler unexpected message received: " + msg);
                return;
            }
            ChannelPromise promise = (ChannelPromise)this.streamidPromiseMap.get(streamId);
            if (promise == null) {
                System.err.println("Message received for unknown stream id " + streamId);
            } else {
                ByteBuf content = msg.content();
                if (content.isReadable()) {
                    int contentLength = content.readableBytes();
                    byte[] arr = new byte[contentLength];
                    content.readBytes(arr);
                    messages.add(new String(arr, StandardCharsets.UTF_8));
                }
                promise.setSuccess();
            }
        }
    }

    static class Http2SettingsHandler
    extends SimpleChannelInboundHandler<Http2Settings> {
        private ChannelPromise promise;

        Http2SettingsHandler(ChannelPromise promise) {
            this.promise = promise;
        }

        public void awaitSettings(long timeout, TimeUnit unit) throws Exception {
            if (!this.promise.awaitUninterruptibly(timeout, unit)) {
                throw new IllegalStateException("Timed out waiting for settings");
            }
            if (!this.promise.isSuccess()) {
                throw new RuntimeException(this.promise.cause());
            }
        }

        protected void channelRead0(ChannelHandlerContext ctx, Http2Settings msg) throws Exception {
            this.promise.setSuccess();
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    static class Http2ClientInitializer
    extends ChannelInitializer<SocketChannel> {
        private static final Http2FrameLogger logger = new Http2FrameLogger(LogLevel.INFO, Http2ClientInitializer.class);
        private final int maxContentLength;
        private HttpToHttp2ConnectionHandler connectionHandler;
        private HttpResponseHandler responseHandler;
        private Http2SettingsHandler settingsHandler;

        Http2ClientInitializer(int maxContentLength) {
            this.maxContentLength = maxContentLength;
        }

        public void initChannel(SocketChannel ch) throws Exception {
            DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
            this.connectionHandler = new HttpToHttp2ConnectionHandlerBuilder().connection((Http2Connection)connection).frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener((Http2Connection)connection, (Http2FrameListener)new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).maxContentLength(this.maxContentLength).propagateSettings(true).build())).build();
            this.responseHandler = new HttpResponseHandler();
            this.settingsHandler = new Http2SettingsHandler(ch.newPromise());
            this.configureClearText(ch);
        }

        public HttpResponseHandler responseHandler() {
            return this.responseHandler;
        }

        public Http2SettingsHandler settingsHandler() {
            return this.settingsHandler;
        }

        protected void configureEndOfPipeline(ChannelPipeline pipeline) {
            pipeline.addLast(new ChannelHandler[]{this.settingsHandler, this.responseHandler});
        }

        private void configureClearText(SocketChannel ch) {
            HttpClientCodec sourceCodec = new HttpClientCodec();
            Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec((Http2ConnectionHandler)this.connectionHandler);
            HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 65536);
            ch.pipeline().addLast(new ChannelHandler[]{sourceCodec, upgradeHandler, new UpgradeRequestHandler(), new UserEventLogger()});
        }

        protected String fetchUpgradeHandlerURL() {
            return "/sdf";
        }

        private static Http2FrameReader frameReader() {
            return new Http2InboundFrameLogger((Http2FrameReader)new DefaultHttp2FrameReader(), logger);
        }

        private static Http2FrameWriter frameWriter() {
            return new Http2OutboundFrameLogger((Http2FrameWriter)new DefaultHttp2FrameWriter(), logger);
        }

        private static class UserEventLogger
        extends ChannelInboundHandlerAdapter {
            private UserEventLogger() {
            }

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                System.out.println("User Event Triggered: " + evt);
                ctx.fireUserEventTriggered(evt);
            }
        }

        private final class UpgradeRequestHandler
        extends ChannelInboundHandlerAdapter {
            private UpgradeRequestHandler() {
            }

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                DefaultFullHttpRequest upgradeRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, Http2ClientInitializer.this.fetchUpgradeHandlerURL());
                upgradeRequest.headers().add("Host", (Object)"default");
                ctx.writeAndFlush((Object)upgradeRequest);
                ctx.fireChannelActive();
                ctx.pipeline().remove((ChannelHandler)this);
                Http2ClientInitializer.this.configureEndOfPipeline(ctx.pipeline());
            }
        }
    }
}

