/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.testutils.category.UnitTest;
import io.undertow.util.PathMatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnitTest.class})
public class PathMatcherTestCase {
    @Test
    public void testSimplePrefixCase() {
        PathMatcher pathMatcher = new PathMatcher();
        pathMatcher.addPrefixPath("prefix", (Object)"response");
        Assert.assertEquals((Object)"response", (Object)pathMatcher.getPrefixPath("prefix"));
        Assert.assertEquals((Object)"response", (Object)pathMatcher.getPrefixPath("/prefix"));
        Assert.assertEquals((Object)"response", (Object)pathMatcher.getPrefixPath("/prefix/"));
        pathMatcher.addPrefixPath("/prefix", (Object)"new response");
        Assert.assertEquals((Object)"new response", (Object)pathMatcher.getPrefixPath("prefix"));
        Assert.assertEquals((Object)"new response", (Object)pathMatcher.getPrefixPath("/prefix"));
        Assert.assertEquals((Object)"new response", (Object)pathMatcher.getPrefixPath("/prefix/"));
        pathMatcher.addPrefixPath("/prefix/", (Object)"different response");
        Assert.assertEquals((Object)"different response", (Object)pathMatcher.getPrefixPath("prefix"));
        Assert.assertEquals((Object)"different response", (Object)pathMatcher.getPrefixPath("/prefix"));
        Assert.assertEquals((Object)"different response", (Object)pathMatcher.getPrefixPath("/prefix/"));
        pathMatcher.addPrefixPath("/prefix//////////////////////", (Object)"last response");
        Assert.assertEquals((Object)"last response", (Object)pathMatcher.getPrefixPath("prefix"));
        Assert.assertEquals((Object)"last response", (Object)pathMatcher.getPrefixPath("/prefix"));
        Assert.assertEquals((Object)"last response", (Object)pathMatcher.getPrefixPath("/prefix/"));
        pathMatcher.clearPaths();
        Assert.assertNull((Object)pathMatcher.getPrefixPath("prefix"));
        Assert.assertNull((Object)pathMatcher.getPrefixPath("/prefix"));
        Assert.assertNull((Object)pathMatcher.getPrefixPath("/prefix/"));
    }

    @Test
    public void testSimpleMatchCase() {
        PathMatcher pathMatcher = new PathMatcher();
        pathMatcher.addPrefixPath("prefix", (Object)"response");
        Assert.assertEquals((Object)"response", (Object)pathMatcher.match("/prefix").getValue());
        Assert.assertEquals((Object)"response", (Object)pathMatcher.match("/prefix/").getValue());
        pathMatcher.addPrefixPath("/prefix", (Object)"new response");
        Assert.assertEquals((Object)"new response", (Object)pathMatcher.match("/prefix").getValue());
        Assert.assertEquals((Object)"new response", (Object)pathMatcher.match("/prefix/").getValue());
        pathMatcher.addPrefixPath("/prefix/", (Object)"different response");
        Assert.assertEquals((Object)"different response", (Object)pathMatcher.match("/prefix").getValue());
        Assert.assertEquals((Object)"different response", (Object)pathMatcher.match("/prefix/").getValue());
        pathMatcher.addPrefixPath("/prefix//////////////////////", (Object)"last response");
        Assert.assertEquals((Object)"last response", (Object)pathMatcher.match("/prefix").getValue());
        Assert.assertEquals((Object)"last response", (Object)pathMatcher.match("/prefix/").getValue());
        pathMatcher.clearPaths();
        Assert.assertNull((Object)pathMatcher.match("/prefix").getValue());
        Assert.assertNull((Object)pathMatcher.match("/prefix/").getValue());
    }

    @Test
    public void testSimpleDefaultCase() {
        PathMatcher pathMatcher = new PathMatcher();
        pathMatcher.addPrefixPath("/", (Object)"default");
        Assert.assertEquals((Object)"default", (Object)pathMatcher.getPrefixPath("/"));
        Assert.assertEquals((Object)"default", (Object)pathMatcher.match("/").getValue());
        pathMatcher.addPrefixPath("//////", (Object)"needs normalize default");
        Assert.assertEquals((Object)"needs normalize default", (Object)pathMatcher.getPrefixPath("/"));
        Assert.assertEquals((Object)"needs normalize default", (Object)pathMatcher.match("/").getValue());
        pathMatcher.clearPaths();
        Assert.assertNull((Object)pathMatcher.getPrefixPath("/"));
    }

    @Test
    public void testDefaultFallthrough() {
        PathMatcher pathMatcher = new PathMatcher((Object)"default");
        Assert.assertEquals((Object)"default", (Object)pathMatcher.getPrefixPath("/"));
        Assert.assertEquals((Object)"default", (Object)pathMatcher.match("/").getValue());
        pathMatcher.addPrefixPath("/test1", (Object)"test1");
        pathMatcher.addPrefixPath("/test2", (Object)"test2");
        pathMatcher.addPrefixPath("/test3", (Object)"test3");
        pathMatcher.addPrefixPath("/test4", (Object)"test4");
        Assert.assertEquals((Object)"default", (Object)pathMatcher.match("/adsfasdfdsaf").getValue());
        Assert.assertEquals((Object)"default", (Object)pathMatcher.match("/   ").getValue());
        Assert.assertEquals((Object)"default", (Object)pathMatcher.match("/drooadfas").getValue());
        Assert.assertEquals((Object)"default", (Object)pathMatcher.match("/thing/thing").getValue());
        Assert.assertEquals((Object)"default", (Object)pathMatcher.match("").getValue());
        Assert.assertEquals((Object)"test1", (Object)pathMatcher.match("/test1").getValue());
        Assert.assertEquals((Object)"test2", (Object)pathMatcher.match("/test2").getValue());
        Assert.assertEquals((Object)"test3", (Object)pathMatcher.match("/test3").getValue());
        Assert.assertEquals((Object)"test4", (Object)pathMatcher.match("/test4").getValue());
    }
}

