/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.net.URLEncoder;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.OptionMap;

@RunWith(value=DefaultServer.class)
@AjpIgnore
public class DefaultMaxHeaderTestCase {
    private static final String MESSAGE = "HelloUrl";
    private static final int COUNT = 10000;

    @BeforeClass
    public static void setup() {
        Assume.assumeTrue((System.getProperty("io.undertow.http2-max-header-size") == null ? 1 : 0) != 0);
        BlockingHandler blockingHandler = new BlockingHandler();
        DefaultServer.setRootHandler((HttpHandler)blockingHandler);
        blockingHandler.setRootHandler(exchange -> exchange.getResponseSender().send(exchange.getRelativePath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeURL() throws IOException {
        StringBuffer message = new StringBuffer();
        for (int i = 0; i < 10000; ++i) {
            message.append(MESSAGE);
        }
        try (TestHttpClient client = new TestHttpClient();){
            try {
                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/" + message);
                this.assertStatus(client.execute((HttpUriRequest)get).getStatusLine().getStatusCode());
            }
            finally {
                client.getConnectionManager().shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLotsOfQueryParameters_MaxParameters_Ok() throws IOException {
        OptionMap existing = DefaultServer.getUndertowOptions();
        try (TestHttpClient client = new TestHttpClient();){
            try {
                StringBuilder qs = new StringBuilder();
                for (int i = 0; i < 1000; ++i) {
                    qs.append("QUERY").append(i);
                    qs.append("=");
                    qs.append(URLEncoder.encode("Hello Query" + i, "UTF-8"));
                    qs.append("&");
                }
                qs.deleteCharAt(qs.length() - 1);
                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path?" + qs);
                this.assertStatus(client.execute((HttpUriRequest)get).getStatusLine().getStatusCode());
            }
            finally {
                DefaultServer.setUndertowOptions(existing);
                client.getConnectionManager().shutdown();
            }
        }
    }

    private void assertStatus(int statusCode) {
        if (DefaultServer.isH2()) {
            if (DefaultServer.isH2upgrade()) {
                Assert.assertTrue((statusCode == 400 || statusCode == 503 && DefaultServer.isProxy() || statusCode == 200 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((statusCode == 400 || statusCode == 503 && DefaultServer.isProxy() ? 1 : 0) != 0);
            }
        } else {
            Assert.assertEquals((long)200L, (long)statusCode);
        }
    }
}

