/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.form.EagerFormParsingHandler;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormEncodedDataDefinition;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.handlers.form.MultiPartParserDefinition;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.HeaderValues;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.IoUtils;

@RunWith(value=DefaultServer.class)
public class MultipartFormDataParserTestCase {
    private static HttpHandler createHandler() {
        return new HttpHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                FormDataParser parser = FormParserFactory.builder().build().createParser(exchange);
                try {
                    FormData.FormValue file;
                    FormData data = parser.parseBlocking();
                    exchange.setStatusCode(500);
                    if (data.getFirst("formValue").getValue().equals("myValue") && (file = data.getFirst("file")).isFile() && file.getPath() != null && new String(Files.readAllBytes(file.getPath())).startsWith("file contents")) {
                        exchange.setStatusCode(200);
                    }
                    exchange.endExchange();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    exchange.setStatusCode(500);
                    exchange.endExchange();
                }
                finally {
                    IoUtils.safeClose((Closeable)parser);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileUpload() throws Exception {
        DefaultServer.setRootHandler((HttpHandler)new BlockingHandler(MultipartFormDataParserTestCase.createHandler()));
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart("formValue", (ContentBody)new StringBody("myValue", "text/plain", StandardCharsets.UTF_8));
            entity.addPart("file", (ContentBody)new FileBody(new File(MultipartFormDataParserTestCase.class.getResource("uploadfile.txt").getFile())));
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuotedBoundary() throws Exception {
        DefaultServer.setRootHandler((HttpHandler)new BlockingHandler(MultipartFormDataParserTestCase.createHandler()));
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
            post.setHeader("Content-Type", "multipart/form-data; boundary=\"s58IGsuzbg6GBG1yIgUO8;n4WkVf7clWMje\"");
            StringEntity entity = new StringEntity("--s58IGsuzbg6GBG1yIgUO8;n4WkVf7clWMje\r\nContent-Disposition: form-data; name=\"formValue\"\r\n\r\nmyValue\r\n--s58IGsuzbg6GBG1yIgUO8;n4WkVf7clWMje\r\nContent-Disposition: form-data; name=\"file\"; filename=\"uploadfile.txt\"\r\nContent-Type: application/octet-stream\r\n\r\nfile contents\r\n\r\n--s58IGsuzbg6GBG1yIgUO8;n4WkVf7clWMje--\r\n");
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileUploadWithEagerParsing() throws Exception {
        DefaultServer.setRootHandler((HttpHandler)new EagerFormParsingHandler().setNext(MultipartFormDataParserTestCase.createHandler()));
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart("formValue", (ContentBody)new StringBody("myValue", "text/plain", StandardCharsets.UTF_8));
            entity.addPart("file", (ContentBody)new FileBody(new File(MultipartFormDataParserTestCase.class.getResource("uploadfile.txt").getFile())));
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileUploadWithEagerParsingAndNonASCIIFilename() throws Exception {
        DefaultServer.setRootHandler((HttpHandler)new EagerFormParsingHandler().setNext(MultipartFormDataParserTestCase.createHandler()));
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
            MultipartEntity entity = new MultipartEntity();
            entity.addPart("formValue", (ContentBody)new StringBody("myValue", "text/plain", StandardCharsets.UTF_8));
            File uploadfile = new File(MultipartFormDataParserTestCase.class.getResource("uploadfile.txt").getFile());
            FormBodyPart filePart = new FormBodyPart("file", (ContentBody)new FileBody(uploadfile, "\u03c4\u03b5\u03c3\u03c4", "application/octet-stream", Charsets.UTF_8.toString()));
            filePart.addField("Content-Disposition", "form-data; name=\"file\"; filename*=\"utf-8''%CF%84%CE%B5%CF%83%CF%84.txt\"");
            entity.addPart(filePart);
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private static HttpHandler createInMemoryReadingHandler(final long fileSizeThreshold) {
        return new HttpHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                MultiPartParserDefinition multiPartParserDefinition = new MultiPartParserDefinition();
                multiPartParserDefinition.setFileSizeThreshold(fileSizeThreshold);
                FormDataParser parser = FormParserFactory.builder((boolean)false).addParsers(new FormParserFactory.ParserDefinition[]{new FormEncodedDataDefinition(), multiPartParserDefinition}).build().createParser(exchange);
                try {
                    FormData.FormValue file;
                    FormData data = parser.parseBlocking();
                    exchange.setStatusCode(500);
                    if (data.getFirst("formValue").getValue().equals("myValue") && (file = data.getFirst("file")).isFileItem()) {
                        exchange.setStatusCode(200);
                        this.logResult(exchange, file.getFileItem().isInMemory(), file.getFileName(), this.stream2String(file));
                    }
                    exchange.endExchange();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    exchange.setStatusCode(500);
                    exchange.endExchange();
                }
                finally {
                    IoUtils.safeClose((Closeable)parser);
                }
            }

            private String stream2String(FormData.FormValue file) throws IOException {
                try (InputStream is = file.getFileItem().getInputStream();){
                    StringWriter sw = new StringWriter();
                    IOUtils.copy((InputStream)is, (Writer)sw, (String)"UTF-8");
                    String string = sw.toString();
                    return string;
                }
            }

            private String getFileName(FormData.FormValue data) {
                HeaderValues cdHeaders = data.getHeaders().get("content-disposition");
                for (String cdHeader : cdHeaders) {
                    if (!cdHeader.startsWith("form-data")) continue;
                    return cdHeader.substring(cdHeader.indexOf("filename=") + "filename=".length()).replace("\"", "");
                }
                return null;
            }

            private void logResult(HttpServerExchange exchange, boolean inMemory, String fileName, String content) throws IOException {
                String res = String.format("in_memory:%s;file_name:%s;hash:%s", inMemory, fileName, DigestUtils.md5Hex((String)content));
                OutputStream outputStream = exchange.getOutputStream();
                outputStream.write(res.getBytes());
                outputStream.close();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileUploadWithSmallFileSizeThreshold() throws Exception {
        DefaultServer.setRootHandler((HttpHandler)new BlockingHandler(MultipartFormDataParserTestCase.createInMemoryReadingHandler(10L)));
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart("formValue", (ContentBody)new StringBody("myValue", "text/plain", StandardCharsets.UTF_8));
            entity.addPart("file", (ContentBody)new FileBody(new File(MultipartFormDataParserTestCase.class.getResource("uploadfile.txt").getFile())));
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String resp = HttpClientUtils.readResponse((HttpResponse)result);
            Map<String, String> parsedResponse = this.parse(resp);
            Assert.assertEquals((Object)"false", (Object)parsedResponse.get("in_memory"));
            Assert.assertEquals((Object)"uploadfile.txt", (Object)parsedResponse.get("file_name"));
            Assert.assertEquals((Object)DigestUtils.md5Hex((InputStream)new FileInputStream(new File(MultipartFormDataParserTestCase.class.getResource("uploadfile.txt").getFile()))), (Object)parsedResponse.get("hash"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileUploadWithLargeFileSizeThreshold() throws Exception {
        DefaultServer.setRootHandler((HttpHandler)new BlockingHandler(MultipartFormDataParserTestCase.createInMemoryReadingHandler(10000L)));
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart("formValue", (ContentBody)new StringBody("myValue", "text/plain", StandardCharsets.UTF_8));
            entity.addPart("file", (ContentBody)new FileBody(new File(MultipartFormDataParserTestCase.class.getResource("uploadfile.txt").getFile())));
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String resp = HttpClientUtils.readResponse((HttpResponse)result);
            Map<String, String> parsedResponse = this.parse(resp);
            Assert.assertEquals((Object)"true", (Object)parsedResponse.get("in_memory"));
            Assert.assertEquals((Object)"uploadfile.txt", (Object)parsedResponse.get("file_name"));
            Assert.assertEquals((Object)DigestUtils.md5Hex((InputStream)new FileInputStream(new File(MultipartFormDataParserTestCase.class.getResource("uploadfile.txt").getFile()))), (Object)parsedResponse.get("hash"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileUploadWithMediumFileSizeThresholdAndLargeFile() throws Exception {
        int fileSizeThreshold = 1000;
        DefaultServer.setRootHandler((HttpHandler)new BlockingHandler(MultipartFormDataParserTestCase.createInMemoryReadingHandler(fileSizeThreshold)));
        TestHttpClient client = new TestHttpClient();
        File file = new File("tmp_upload_file.txt");
        file.createNewFile();
        try {
            this.writeLargeFileContent(file, fileSizeThreshold * 2);
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart("formValue", (ContentBody)new StringBody("myValue", "text/plain", StandardCharsets.UTF_8));
            entity.addPart("file", (ContentBody)new FileBody(file));
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String resp = HttpClientUtils.readResponse((HttpResponse)result);
            Map<String, String> parsedResponse = this.parse(resp);
            Assert.assertEquals((Object)"false", (Object)parsedResponse.get("in_memory"));
            Assert.assertEquals((Object)"tmp_upload_file.txt", (Object)parsedResponse.get("file_name"));
            Assert.assertEquals((Object)DigestUtils.md5Hex((InputStream)new FileInputStream(file)), (Object)parsedResponse.get("hash"));
        }
        finally {
            file.delete();
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeContentWithoutFileNameWithSmallFileSizeThreshold() throws Exception {
        DefaultServer.setRootHandler((HttpHandler)new BlockingHandler(MultipartFormDataParserTestCase.createInMemoryReadingHandler(10L)));
        File file = new File("tmp_upload_file.txt");
        try (TestHttpClient client = new TestHttpClient();){
            file.createNewFile();
            this.writeLargeFileContent(file, 32768);
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
            HttpEntity entity = MultipartEntityBuilder.create().addTextBody("formValue", "myValue", ContentType.TEXT_PLAIN).addBinaryBody("file", Files.newInputStream(file.toPath(), new OpenOption[0])).build();
            post.setEntity(entity);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String resp = HttpClientUtils.readResponse((HttpResponse)result);
            Map<String, String> parsedResponse = this.parse(resp);
            Assert.assertEquals((Object)"false", (Object)parsedResponse.get("in_memory"));
            Assert.assertEquals((Object)DigestUtils.md5Hex((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0])), (Object)parsedResponse.get("hash"));
            Assert.assertEquals((Object)parsedResponse.get("file_name"), (Object)"null");
        }
        finally {
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    private void writeLargeFileContent(File file, int size) throws IOException {
        int textLength = "content".getBytes().length;
        FileOutputStream fos = new FileOutputStream(file);
        for (int i = 0; i < size / textLength; ++i) {
            fos.write("content".getBytes());
        }
        fos.flush();
        fos.close();
    }

    private Map<String, String> parse(String resp) {
        String[] split;
        HashMap<String, String> parsed = new HashMap<String, String>();
        for (String s : split = resp.split(";")) {
            String[] pair = s.split(":");
            parsed.put(pair[0], pair[1]);
        }
        return parsed;
    }
}

