/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.conduits.ChunkedStreamSinkConduit;
import io.undertow.conduits.ConduitListener;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.testutils.category.UnitTest;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.Attachable;
import io.undertow.util.HeaderMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.WriteReadyHandler;

@Category(value={UnitTest.class})
public class ChunkedStreamSinkConduitTest {
    @Test
    public void testChunkedStreamSinkConduit() throws IOException {
        DefaultByteBufferPool pool = new DefaultByteBufferPool(false, 1024, -1, -1);
        final AtomicLong written = new AtomicLong();
        final AtomicInteger flushes = new AtomicInteger();
        AtomicInteger listenerInvocations = new AtomicInteger();
        StreamSinkConduit next = new StreamSinkConduit(){

            public long transferFrom(FileChannel src, long position, long count) throws IOException {
                written.addAndGet(count);
                return count;
            }

            public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
                written.addAndGet(count);
                return count;
            }

            public int write(ByteBuffer src) {
                int remaining = src.remaining();
                src.position(src.position() + remaining);
                written.addAndGet(remaining);
                return remaining;
            }

            public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
                int written2;
                long total = 0L;
                for (int i = offs; i < len && (written2 = this.write(srcs[i])) != 0; ++i) {
                    total += (long)written2;
                }
                return total;
            }

            public int writeFinal(ByteBuffer src) throws IOException {
                return this.write(src);
            }

            public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
                return this.write(srcs, offset, length);
            }

            public void terminateWrites() {
            }

            public boolean isWriteShutdown() {
                return false;
            }

            public void resumeWrites() {
            }

            public void suspendWrites() {
            }

            public void wakeupWrites() {
            }

            public boolean isWriteResumed() {
                return false;
            }

            public void awaitWritable() {
            }

            public void awaitWritable(long time, TimeUnit timeUnit) {
            }

            public XnioIoThread getWriteThread() {
                return null;
            }

            public void setWriteReadyHandler(WriteReadyHandler handler) {
            }

            public void truncateWrites() {
            }

            public boolean flush() {
                flushes.incrementAndGet();
                return true;
            }

            public XnioWorker getWorker() {
                return null;
            }
        };
        ConduitListener listener = channel -> listenerInvocations.incrementAndGet();
        ChunkedStreamSinkConduit conduit = new ChunkedStreamSinkConduit(next, (ByteBufferPool)pool, false, false, new HeaderMap(), listener, (Attachable)new AbstractAttachable(){});
        Assert.assertEquals((long)5L, (long)conduit.write(ByteBuffer.wrap("Hello".getBytes(StandardCharsets.UTF_8))));
        Assert.assertEquals((String)"Expected 11 bytes to be flushed including chunk headers", (long)11L, (long)written.get());
        Assert.assertEquals((long)0L, (long)flushes.get());
        conduit.terminateWrites();
        Assert.assertTrue((boolean)conduit.flush());
        int flushesAfterTerminate = flushes.get();
        Assert.assertTrue((boolean)conduit.flush());
        Assert.assertEquals((String)"Expected flushing after termination not to have any impact", (long)flushesAfterTerminate, (long)flushes.get());
        Assert.assertEquals((long)1L, (long)listenerInvocations.get());
    }
}

