/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import junit.textui.TestRunner;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=DefaultServer.Parameterized.class)
public class FormDataParserTestCase {
    private final HttpHandler rootHandler;

    public FormDataParserTestCase(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> handlerChains() {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        final FormParserFactory parserFactory = FormParserFactory.builder().withDefaultCharset("UTF-8").build();
        HttpHandler fd = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                FormDataParser parser = parserFactory.createParser(exchange);
                parser.parse(new HttpHandler(){

                    public void handleRequest(HttpServerExchange exchange) throws Exception {
                        FormData data = (FormData)exchange.getAttachment(FormDataParser.FORM_DATA);
                        StringBuilder response = new StringBuilder();
                        for (String fd : data) {
                            for (FormData.FormValue val : data.get(fd)) {
                                if (response.length() > 0) {
                                    response.append("\n");
                                }
                                response.append(fd).append(":").append(val.getValue());
                            }
                        }
                        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain; charset=UTF-8");
                        exchange.getResponseSender().send(response.toString(), StandardCharsets.UTF_8);
                    }
                });
            }
        };
        ret.add(new Object[]{fd});
        BlockingHandler blocking = new BlockingHandler();
        blocking.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                FormDataParser parser = parserFactory.createParser(exchange);
                try {
                    FormData data = parser.parseBlocking();
                    StringBuilder response = new StringBuilder();
                    for (String fd : data) {
                        for (FormData.FormValue val : data.get(fd)) {
                            if (response.length() > 0) {
                                response.append("\n");
                            }
                            response.append(fd).append(":").append(val.getValue());
                        }
                    }
                    exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain; charset=UTF-8");
                    exchange.getResponseSender().send(response.toString(), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    exchange.setStatusCode(500);
                }
            }
        });
        ret.add(new Object[]{blocking});
        return ret;
    }

    @Test
    public void testFormDataParsing() throws Exception {
        this.runTestUrlEncoded(new NameValuePair[]{new BasicNameValuePair("name", "A Value")});
        this.runTestUrlEncoded(new NameValuePair[]{new BasicNameValuePair("name", "A Value"), new BasicNameValuePair("Single-value", null)});
        this.runTestUrlEncoded(new NameValuePair[]{new BasicNameValuePair("name", "A Value"), new BasicNameValuePair("A/name/with_special*chars", "A $ value&& with=SomeCharacters")});
        this.runTestUrlEncoded(new NameValuePair[]{new BasicNameValuePair("name", "A Value"), new BasicNameValuePair("Single-value", null), new BasicNameValuePair("A/name/with_special*chars", "A $ value&& with=SomeCharacters")});
    }

    @Test
    public void testRawFormDataParsingIncorrectValue() throws Exception {
        this.testRawFormDataParsing((NameValuePair)new BasicNameValuePair("name", "%"));
        this.testRawFormDataParsing((NameValuePair)new BasicNameValuePair("Name%", "value"));
    }

    @Test
    public void testUTF8FormDataParsing() throws Exception {
        String name = "abcA\u00a9\u00e9\u0301\u0941\ud835\udd0a%20+123";
        String value = "test";
        BasicNameValuePair test = new BasicNameValuePair(name.replaceAll("%20", " ").replaceAll("\\+", " "), value);
        this.runTest(Collections.singletonList(test), (HttpEntity)new ByteArrayEntity((name + "=" + value).getBytes(StandardCharsets.UTF_8), ContentType.APPLICATION_FORM_URLENCODED));
        name = "test";
        value = "abcA\u00a9\u00e9\u0301\u0941\ud835\udd0a%20+123";
        test = new BasicNameValuePair(name, value.replaceAll("%20", " ").replaceAll("\\+", " "));
        this.runTest(Collections.singletonList(test), (HttpEntity)new ByteArrayEntity((name + "=" + value).getBytes(StandardCharsets.UTF_8), ContentType.APPLICATION_FORM_URLENCODED));
    }

    private void testRawFormDataParsing(NameValuePair wrongPair) throws Exception {
        BasicNameValuePair correctPair = new BasicNameValuePair("correctName", "A Value");
        BasicNameValuePair correctPair2 = new BasicNameValuePair("correctName2", "A Value2");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URLEncodedUtils.format(Collections.singleton(correctPair), (Charset)HTTP.DEF_CONTENT_CHARSET)).append("&").append(wrongPair.getName()).append("=").append(wrongPair.getValue()).append("&").append(URLEncodedUtils.format(Collections.singleton(correctPair2), (Charset)HTTP.DEF_CONTENT_CHARSET));
        ArrayList<NameValuePair> expectedData = new ArrayList<NameValuePair>();
        expectedData.add((NameValuePair)correctPair);
        expectedData.add((NameValuePair)correctPair2);
        this.runTest(expectedData, (HttpEntity)new StringEntity(stringBuilder.toString(), ContentType.APPLICATION_FORM_URLENCODED));
    }

    private void runTestUrlEncoded(NameValuePair ... pairs) throws Exception {
        ArrayList<NameValuePair> data = new ArrayList<NameValuePair>(Arrays.asList(pairs));
        this.runTest(data, (HttpEntity)new UrlEncodedFormEntity(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(List<NameValuePair> data, HttpEntity entity) throws Exception {
        DefaultServer.setRootHandler(this.rootHandler);
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
            post.setHeader("Content-Type", "application/x-www-form-urlencoded");
            post.setEntity(entity);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            this.checkResult(data, (HttpResponse)result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private void checkResult(List<NameValuePair> data, HttpResponse result) throws IOException {
        HashMap<String, String> res = new HashMap<String, String>();
        String content = HttpClientUtils.readResponse(result);
        for (String value : content.split("\n")) {
            String[] split = value.split(":");
            res.put(split[0], split.length == 1 ? "" : split[1]);
        }
        Assert.assertEquals((long)data.size(), (long)res.size());
        for (NameValuePair vp : data) {
            Assert.assertEquals((Object)(vp.getValue() == null ? "" : vp.getValue()), res.get(vp.getName()));
        }
    }

    static class AggregateRunner
    extends TestRunner {
        AggregateRunner() {
        }
    }
}

