/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.UndertowClient;
import io.undertow.io.Sender;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.handlers.PathHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.testutils.StopServerWithExternalWorkerUtils;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.StringReadChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

@RunWith(value=DefaultServer.class)
@ProxyIgnore
public class HttpClientSNITestCase {
    public static final String SNI = "/sni";
    private static final OptionMap DEFAULT_OPTIONS;
    private static final AttachmentKey<String> RESPONSE_BODY;
    private static URL ADDRESS;
    private static XnioWorker worker;
    private static Undertow server;

    @BeforeClass
    public static void beforeClass() throws IOException {
        XnioWorker xnioWorker;
        Xnio xnio = Xnio.getInstance();
        worker = xnioWorker = xnio.createWorker(null, DEFAULT_OPTIONS);
        int port = DefaultServer.getHostPort("default") + 1;
        server = Undertow.builder().setByteBufferPool(DefaultServer.getBufferPool()).addHttpsListener(port, DefaultServer.getHostAddress("default"), DefaultServer.getServerSslContext()).setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler((HttpHandler)new PathHandler().addExactPath(SNI, exchange -> {
            List<SNIServerName> names;
            StringBuilder sb = new StringBuilder();
            SSLSessionInfo ssl = exchange.getConnection().getSslSessionInfo();
            if (ssl != null && ssl.getSSLSession() instanceof ExtendedSSLSession && (names = ((ExtendedSSLSession)ssl.getSSLSession()).getRequestedServerNames()) != null) {
                for (SNIServerName name : names) {
                    if (!(name instanceof SNIHostName)) continue;
                    if (sb.length() > 0) {
                        sb.append(":");
                    }
                    sb.append(((SNIHostName)name).getAsciiName());
                }
            }
            exchange.setStatusCode(200);
            Sender sender = exchange.getResponseSender();
            sender.send(sb.toString(), StandardCharsets.UTF_8);
        })).build();
        server.start();
        ADDRESS = new URL("https://" + DefaultServer.getHostAddress() + ":" + port);
    }

    @AfterClass
    public static void afterClass() {
        if (server != null) {
            server.stop();
        }
        if (worker != null) {
            StopServerWithExternalWorkerUtils.stopWorker(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSNIWhenHostname() throws Exception {
        InetAddress address = InetAddress.getByName(ADDRESS.getHost());
        Assume.assumeTrue((String)"Assuming the test if no resolution for the address", (!address.getHostName().equals(address.getHostAddress()) ? 1 : 0) != 0);
        UndertowClient client = UndertowClient.getInstance();
        CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        CountDownLatch latch = new CountDownLatch(1);
        ClientConnection connection = (ClientConnection)client.connect(new URI("https://" + address.getHostName() + ":" + ADDRESS.getPort()), worker, (XnioSsl)new UndertowXnioSsl(worker.getXnio(), OptionMap.EMPTY, DefaultServer.getClientSSLContext()), DefaultServer.getBufferPool(), OptionMap.EMPTY).get();
        try {
            connection.getIoThread().execute(() -> {
                ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(SNI);
                request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                connection.sendRequest(request, this.createClientCallback(responses, latch));
            });
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)responses.size());
            Assert.assertEquals((long)200L, (long)((ClientResponse)responses.get(0)).getResponseCode());
            Assert.assertEquals((Object)address.getHostName(), (Object)((ClientResponse)responses.get(0)).getAttachment(RESPONSE_BODY));
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoSNIWhenIP() throws Exception {
        InetAddress address = InetAddress.getByName(ADDRESS.getHost());
        Assume.assumeTrue((String)"Assuming the test if no resolution for the address", (!address.getHostName().equals(address.getHostAddress()) ? 1 : 0) != 0);
        Object hostname = address instanceof Inet6Address ? "[" + address.getHostAddress() + "]" : address.getHostAddress();
        UndertowClient client = UndertowClient.getInstance();
        CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        CountDownLatch latch = new CountDownLatch(1);
        ClientConnection connection = (ClientConnection)client.connect(new URI("https://" + (String)hostname + ":" + ADDRESS.getPort()), worker, (XnioSsl)new UndertowXnioSsl(worker.getXnio(), OptionMap.EMPTY, DefaultServer.getClientSSLContext()), DefaultServer.getBufferPool(), OptionMap.EMPTY).get();
        try {
            connection.getIoThread().execute(() -> {
                ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(SNI);
                request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                connection.sendRequest(request, this.createClientCallback(responses, latch));
            });
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)responses.size());
            Assert.assertEquals((long)200L, (long)((ClientResponse)responses.get(0)).getResponseCode());
            Assert.assertEquals((Object)"", (Object)((ClientResponse)responses.get(0)).getAttachment(RESPONSE_BODY));
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForcingSNIForIP() throws Exception {
        InetAddress address = InetAddress.getByName(ADDRESS.getHost());
        Assume.assumeTrue((String)"Assuming the test if no resolution for the address", (!address.getHostName().equals(address.getHostAddress()) ? 1 : 0) != 0);
        Object hostname = address instanceof Inet6Address ? "[" + address.getHostAddress() + "]" : address.getHostAddress();
        UndertowClient client = UndertowClient.getInstance();
        CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        CountDownLatch latch = new CountDownLatch(1);
        ClientConnection connection = (ClientConnection)client.connect(new URI("https://" + (String)hostname + ":" + ADDRESS.getPort()), worker, (XnioSsl)new UndertowXnioSsl(worker.getXnio(), OptionMap.EMPTY, DefaultServer.getClientSSLContext()), DefaultServer.getBufferPool(), OptionMap.create((Option)UndertowOptions.SSL_SNI_HOSTNAME, (Object)address.getHostName())).get();
        try {
            connection.getIoThread().execute(() -> {
                ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(SNI);
                request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                connection.sendRequest(request, this.createClientCallback(responses, latch));
            });
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)responses.size());
            Assert.assertEquals((long)200L, (long)((ClientResponse)responses.get(0)).getResponseCode());
            Assert.assertEquals((Object)address.getHostName(), (Object)((ClientResponse)responses.get(0)).getAttachment(RESPONSE_BODY));
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForcingSNIForHostname() throws Exception {
        InetAddress address = InetAddress.getByName(ADDRESS.getHost());
        Assume.assumeTrue((String)"Assuming the test if no resolution for the address", (!address.getHostName().equals(address.getHostAddress()) ? 1 : 0) != 0);
        UndertowClient client = UndertowClient.getInstance();
        CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        CountDownLatch latch = new CountDownLatch(1);
        ClientConnection connection = (ClientConnection)client.connect(new URI("https://" + address.getHostName() + ":" + ADDRESS.getPort()), worker, (XnioSsl)new UndertowXnioSsl(worker.getXnio(), OptionMap.EMPTY, DefaultServer.getClientSSLContext()), DefaultServer.getBufferPool(), OptionMap.create((Option)UndertowOptions.SSL_SNI_HOSTNAME, (Object)"server")).get();
        try {
            connection.getIoThread().execute(() -> {
                ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(SNI);
                request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                connection.sendRequest(request, this.createClientCallback(responses, latch));
            });
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)responses.size());
            Assert.assertEquals((long)200L, (long)((ClientResponse)responses.get(0)).getResponseCode());
            Assert.assertEquals((Object)"server", (Object)((ClientResponse)responses.get(0)).getAttachment(RESPONSE_BODY));
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    private ClientCallback<ClientExchange> createClientCallback(final List<ClientResponse> responses, final CountDownLatch latch) {
        return new ClientCallback<ClientExchange>(){

            public void completed(ClientExchange result) {
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(final ClientExchange result) {
                        new StringReadChannelListener(result.getConnection().getBufferPool()){

                            protected void stringDone(String string) {
                                result.getResponse().putAttachment(RESPONSE_BODY, (Object)string);
                                responses.add(result.getResponse());
                                latch.countDown();
                            }

                            protected void error(IOException e) {
                                e.printStackTrace();
                                responses.add(result.getResponse());
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    public void failed(IOException e) {
                        e.printStackTrace();
                        latch.countDown();
                    }
                });
                try {
                    result.getRequestChannel().shutdownWrites();
                    if (!result.getRequestChannel().flush()) {
                        result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    latch.countDown();
                }
            }

            public void failed(IOException e) {
                e.printStackTrace();
                latch.countDown();
            }
        };
    }

    static {
        RESPONSE_BODY = AttachmentKey.create(String.class);
        DEFAULT_OPTIONS = OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.TCP_NODELAY, true).set(Options.KEEP_ALIVE, true).set(Options.WORKER_NAME, (Object)"Client").getMap();
    }
}

