/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.testutils.category.UnitTest;
import io.undertow.util.PathTemplate;
import java.util.HashMap;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnitTest.class})
public class PathTemplateTestCase {
    @Test
    public void testMatches() {
        this.testMatch("/docs/mydoc", "/docs/mydoc", new String[0]);
        this.testMatch("/docs/{docId}", "/docs/mydoc", "docId", "mydoc");
        this.testMatch("/docs/{docId}/{op}", "/docs/mydoc/read", "docId", "mydoc", "op", "read");
        this.testMatch("/docs/{docId}/{op}/{allowed}", "/docs/mydoc/read/true", "docId", "mydoc", "op", "read", "allowed", "true");
        this.testMatch("/docs/{docId}/operation/{op}", "/docs/mydoc/operation/read", "docId", "mydoc", "op", "read");
        this.testMatch("/docs/{docId}/read", "/docs/mydoc/read", "docId", "mydoc");
        this.testMatch("/docs/{docId}/read", "/docs/mydoc/read?myQueryParam", "docId", "mydoc");
        this.testMatch("docs/mydoc", "/docs/mydoc", new String[0]);
        this.testMatch("docs/{docId}", "/docs/mydoc", "docId", "mydoc");
        this.testMatch("docs/{docId}/{op}", "/docs/mydoc/read", "docId", "mydoc", "op", "read");
        this.testMatch("docs/{docId}/{op}/{allowed}", "/docs/mydoc/read/true", "docId", "mydoc", "op", "read", "allowed", "true");
        this.testMatch("docs/{docId}/operation/{op}", "/docs/mydoc/operation/read", "docId", "mydoc", "op", "read");
        this.testMatch("docs/{docId}/read", "/docs/mydoc/read", "docId", "mydoc");
        this.testMatch("docs/{docId}/read", "/docs/mydoc/read?myQueryParam", "docId", "mydoc");
        this.testMatch("/docs/mydoc/", "/docs/mydoc/", new String[0]);
        this.testMatch("/docs/{docId}/", "/docs/mydoc/", "docId", "mydoc");
        this.testMatch("/docs/{docId}/{op}/", "/docs/mydoc/read/", "docId", "mydoc", "op", "read");
        this.testMatch("/docs/{docId}/{op}/{allowed}/", "/docs/mydoc/read/true/", "docId", "mydoc", "op", "read", "allowed", "true");
        this.testMatch("/docs/{docId}/operation/{op}/", "/docs/mydoc/operation/read/", "docId", "mydoc", "op", "read");
        this.testMatch("/docs/{docId}/read/", "/docs/mydoc/read/", "docId", "mydoc");
        this.testMatch("/{foo}", "/bob", "foo", "bob");
        this.testMatch("{foo}", "/bob", "foo", "bob");
        this.testMatch("/{foo}/", "/bob/", "foo", "bob");
        this.testMatch("/{value}", "/{value}", "value", "{value}");
    }

    @Test
    public void wildCardTests() {
        this.testMatch("/*", "/docs/mydoc/test", "*", "docs/mydoc/test");
        this.testMatch("/docs/*", "/docs/mydoc/test", "*", "mydoc/test");
        this.testMatch("/docs*", "/docs/mydoc/test", "*", "/mydoc/test");
        this.testMatch("/docs/*", "/docs/mydoc/test/test2", "*", "mydoc/test/test2");
        this.testMatch("/docs/{docId}/*", "/docs/mydoc/test", "docId", "mydoc", "*", "test");
        this.testMatch("/docs/{docId}/*", "/docs/mydoc/", "docId", "mydoc", "*", "");
        this.testMatch("/docs/{docId}/*", "/docs/mydoc/test/test2/test3/test4", "docId", "mydoc", "*", "test/test2/test3/test4");
        this.testMatch("/docs/{docId}/{docId2}/*", "/docs/mydoc/test/test2/test3/test4", "docId", "mydoc", "docId2", "test", "*", "test2/test3/test4");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullPath() {
        PathTemplate.create(null);
    }

    @Test
    public void testDetectDuplicates() {
        TreeSet<PathTemplate> seen = new TreeSet<PathTemplate>();
        seen.add(PathTemplate.create((String)"/bob/{foo}"));
        Assert.assertTrue((boolean)seen.contains(PathTemplate.create((String)"/bob/{ak}")));
        Assert.assertFalse((boolean)seen.contains(PathTemplate.create((String)"/bob/{ak}/other")));
    }

    @Test
    public void testTrailingSlash() {
        PathTemplate template = PathTemplate.create((String)"/bob/");
        Assert.assertFalse((boolean)template.matches("/bob", new HashMap()));
        Assert.assertTrue((boolean)template.matches("/bob/", new HashMap()));
        template = PathTemplate.create((String)"/bob/{id}/");
        Assert.assertFalse((boolean)template.matches("/bob/1", new HashMap()));
        Assert.assertTrue((boolean)template.matches("/bob/1/", new HashMap()));
    }

    private void testMatch(String template, String path, String ... pathParams) {
        Assert.assertEquals((long)0L, (long)(pathParams.length % 2));
        HashMap<String, String> expected = new HashMap<String, String>();
        for (int i = 0; i < pathParams.length; i += 2) {
            expected.put(pathParams[i], pathParams[i + 1]);
        }
        HashMap params = new HashMap();
        PathTemplate pathTemplate = PathTemplate.create((String)template);
        Assert.assertTrue((String)("Failed. Template: " + pathTemplate), (boolean)pathTemplate.matches(path, params));
        Assert.assertEquals(expected, params);
        if (template.endsWith("*") && !template.contains("{")) {
            Assert.assertEquals((String)("Failed. Template: " + pathTemplate + "Must have a part representing the wildcard"), (long)1L, (long)new PathTemplateFriend(pathTemplate).getPartAmount());
        }
    }

    static class PathTemplateFriend {
        private final PathTemplate template;

        PathTemplateFriend(PathTemplate template) {
            this.template = template;
        }

        int getPartAmount() {
            return this.template.parts.size();
        }
    }
}

