/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.HttpString;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@AjpIgnore(apacheOnly=true)
public class LotsOfHeadersResponseTestCase {
    private static final String HEADER = "HEADER";
    private static final String MESSAGE = "Hello Header";
    private static final int COUNT = 10000;

    @BeforeClass
    public static void setup() {
        Assume.assumeNotNull((Object[])new Object[]{System.getProperty("io.undertow.http2-max-header-size")});
        BlockingHandler blockingHandler = new BlockingHandler();
        DefaultServer.setRootHandler((HttpHandler)blockingHandler);
        blockingHandler.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                for (int i = 0; i < 10000; ++i) {
                    exchange.getResponseHeaders().put(HttpString.tryFromString((String)(LotsOfHeadersResponseTestCase.HEADER + i)), LotsOfHeadersResponseTestCase.MESSAGE + i);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLotsOfHeadersInResponse() throws IOException {
        Assume.assumeFalse((boolean)System.getProperty("os.name").startsWith("Windows"));
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            for (int i = 0; i < 10000; ++i) {
                Header[] header = result.getHeaders(HEADER + i);
                if (header.length == 0) {
                    Assert.fail((String)("Header HEADER" + i + " not found"));
                }
                Assert.assertEquals((Object)(MESSAGE + i), (Object)header[0].getValue());
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

