/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http2;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientStatistics;
import io.undertow.client.http2.Http2ClientConnection;
import io.undertow.client.http2.Http2ClientExchange;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.http2.AbstractHttp2StreamSourceChannel;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.http2.Http2GoAwayStreamSourceChannel;
import io.undertow.protocols.http2.Http2HeadersStreamSinkChannel;
import io.undertow.protocols.http2.Http2PingStreamSourceChannel;
import io.undertow.protocols.http2.Http2PushPromiseStreamSourceChannel;
import io.undertow.protocols.http2.Http2RstStreamStreamSourceChannel;
import io.undertow.protocols.http2.Http2StreamSinkChannel;
import io.undertow.protocols.http2.Http2StreamSourceChannel;
import io.undertow.server.protocol.http.HttpAttachments;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSourceChannel;

public class DoSHttp2ClientConnection
extends Http2ClientConnection
implements ClientConnection {
    private final Http2Channel http2Channel;
    private final ChannelListener.SimpleSetter<ClientConnection> closeSetter = new ChannelListener.SimpleSetter();
    private final Map<Integer, Http2ClientExchange> currentExchanges = new ConcurrentHashMap<Integer, Http2ClientExchange>();
    private static final AtomicLong PING_COUNTER = new AtomicLong();
    private Http2GoAwayStreamSourceChannel goAwayStreamSourceChannel = null;
    private boolean initialUpgradeRequest;
    private final String defaultHost;
    private final ClientStatistics clientStatistics;
    private final List<ChannelListener<ClientConnection>> closeListeners = new CopyOnWriteArrayList<ChannelListener<ClientConnection>>();
    private final boolean secure;
    private final Map<PingKey, ClientConnection.PingListener> outstandingPings = new HashMap<PingKey, ClientConnection.PingListener>();

    public DoSHttp2ClientConnection(Http2Channel http2Channel, boolean initialUpgradeRequest, String defaultHost, ClientStatistics clientStatistics, boolean secure) {
        super(http2Channel, initialUpgradeRequest, defaultHost, clientStatistics, secure);
        this.http2Channel = http2Channel;
        this.defaultHost = defaultHost;
        this.clientStatistics = clientStatistics;
        this.secure = secure;
        http2Channel.getReceiveSetter().set((ChannelListener)new Http2ReceiveListener());
        http2Channel.resumeReceives();
        ChannelListener closeTask = channel -> {
            ChannelListeners.invokeChannelListener((Channel)((Object)this), (ChannelListener)this.closeSetter.get());
            for (ChannelListener<ClientConnection> channelListener : this.closeListeners) {
                channelListener.handleEvent((Channel)((Object)this));
            }
            for (Map.Entry entry : this.currentExchanges.entrySet()) {
                ((Http2ClientExchange)entry.getValue()).failed((IOException)new ClosedChannelException());
            }
            this.currentExchanges.clear();
        };
        http2Channel.addCloseTask(closeTask);
        this.initialUpgradeRequest = initialUpgradeRequest;
    }

    public void sendRequest(ClientRequest request, ClientCallback<ClientExchange> clientCallback) {
        Http2HeadersStreamSinkChannel sinkChannel;
        String host;
        if (!this.http2Channel.isOpen()) {
            clientCallback.failed((IOException)new ClosedChannelException());
            return;
        }
        request.getRequestHeaders().put(Http2Channel.METHOD, request.getMethod().toString());
        boolean connectRequest = request.getMethod().equals(Methods.CONNECT);
        if (!connectRequest) {
            request.getRequestHeaders().put(Http2Channel.PATH, request.getPath());
            request.getRequestHeaders().put(Http2Channel.SCHEME, this.secure ? "https" : "http");
        }
        if ((host = request.getRequestHeaders().getFirst(Headers.HOST)) != null) {
            request.getRequestHeaders().put(Http2Channel.AUTHORITY, host);
        } else {
            request.getRequestHeaders().put(Http2Channel.AUTHORITY, this.defaultHost);
        }
        request.getRequestHeaders().remove(Headers.HOST);
        boolean hasContent = true;
        String fixedLengthString = request.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
        String transferEncodingString = request.getRequestHeaders().getLast(Headers.TRANSFER_ENCODING);
        if (fixedLengthString != null) {
            try {
                long length = Long.parseLong(fixedLengthString);
                hasContent = length != 0L;
            }
            catch (NumberFormatException e) {
                this.handleError(new IOException(e));
                return;
            }
        } else if (transferEncodingString == null && !connectRequest) {
            hasContent = false;
        }
        request.getRequestHeaders().remove(Headers.CONNECTION);
        request.getRequestHeaders().remove(Headers.KEEP_ALIVE);
        request.getRequestHeaders().remove(Headers.TRANSFER_ENCODING);
        try {
            sinkChannel = this.http2Channel.createStream(request.getRequestHeaders());
        }
        catch (Throwable t) {
            IOException e = t instanceof IOException ? (IOException)t : new IOException(t);
            clientCallback.failed(e);
            return;
        }
        Http2ClientExchange exchange = new Http2ClientExchange((ClientConnection)this, (Http2StreamSinkChannel)sinkChannel, request);
        this.currentExchanges.put(sinkChannel.getStreamId(), exchange);
        sinkChannel.setTrailersProducer(() -> {
            HeaderMap attachment = (HeaderMap)exchange.getAttachment(HttpAttachments.RESPONSE_TRAILERS);
            Supplier supplier = (Supplier)exchange.getAttachment(HttpAttachments.RESPONSE_TRAILER_SUPPLIER);
            if (attachment != null && supplier == null) {
                return attachment;
            }
            if (attachment == null && supplier != null) {
                return (HeaderMap)supplier.get();
            }
            if (attachment != null) {
                HeaderMap supplied = (HeaderMap)supplier.get();
                for (HeaderValues k : supplied) {
                    attachment.putAll(k.getHeaderName(), (Collection)k);
                }
                return attachment;
            }
            return null;
        });
        try {
            sinkChannel.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.http2Channel.sendRstStream(sinkChannel.getStreamId(), 8);
        if (clientCallback != null) {
            clientCallback.completed((Object)exchange);
        }
        if (!hasContent) {
            try {
                sinkChannel.shutdownWrites();
                if (!sinkChannel.flush()) {
                    sinkChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, (channel, exception) -> this.handleError(exception)));
                    sinkChannel.resumeWrites();
                }
            }
            catch (Throwable e) {
                this.handleError(e);
            }
        }
    }

    private void handleError(Throwable t) {
        IOException e = t instanceof IOException ? (IOException)t : new IOException(t);
        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
        IoUtils.safeClose((Closeable)((Object)this));
        for (Map.Entry<Integer, Http2ClientExchange> entry : this.currentExchanges.entrySet()) {
            try {
                entry.getValue().failed(e);
            }
            catch (Exception ex) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(new IOException(ex));
            }
        }
    }

    public StreamConnection performUpgrade() {
        throw UndertowMessages.MESSAGES.upgradeNotSupported();
    }

    public ByteBufferPool getBufferPool() {
        return this.http2Channel.getBufferPool();
    }

    public SocketAddress getPeerAddress() {
        return this.http2Channel.getPeerAddress();
    }

    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return (A)this.http2Channel.getPeerAddress(type);
    }

    public ChannelListener.Setter<? extends ClientConnection> getCloseSetter() {
        return this.closeSetter;
    }

    public SocketAddress getLocalAddress() {
        return this.http2Channel.getLocalAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return (A)this.http2Channel.getLocalAddress(type);
    }

    public XnioWorker getWorker() {
        return this.http2Channel.getWorker();
    }

    public XnioIoThread getIoThread() {
        return this.http2Channel.getIoThread();
    }

    public boolean isOpen() {
        return this.http2Channel.isOpen() && !this.http2Channel.isPeerGoneAway() && !this.http2Channel.isThisGoneAway();
    }

    public void close() throws IOException {
        try {
            this.http2Channel.sendGoAway(0);
        }
        finally {
            for (Map.Entry<Integer, Http2ClientExchange> entry : this.currentExchanges.entrySet()) {
                entry.getValue().failed((IOException)new ClosedChannelException());
            }
            this.currentExchanges.clear();
        }
    }

    public <T> T getOption(Option<T> option) {
        return null;
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException {
        return null;
    }

    public ClientStatistics getStatistics() {
        return this.clientStatistics;
    }

    public void addCloseListener(ChannelListener<ClientConnection> listener) {
        this.closeListeners.add(listener);
    }

    public void sendPing(ClientConnection.PingListener listener, long timeout, TimeUnit timeUnit) {
        long count = PING_COUNTER.incrementAndGet();
        byte[] data = new byte[]{(byte)count, (byte)(count << 8), (byte)(count << 16), (byte)(count << 24), (byte)(count << 32), (byte)(count << 40), (byte)(count << 48), (byte)(count << 54)};
        PingKey key = new PingKey(data);
        this.outstandingPings.put(key, listener);
        if (timeout > 0L) {
            this.http2Channel.getIoThread().executeAfter(() -> {
                ClientConnection.PingListener listener1 = this.outstandingPings.remove(key);
                if (listener1 != null) {
                    listener1.failed(UndertowMessages.MESSAGES.pingTimeout());
                }
            }, timeout, timeUnit);
        }
        this.http2Channel.sendPing(data, (channel, exception) -> listener.failed(exception));
    }

    public Http2GoAwayStreamSourceChannel getGoAwayStreamSourceChannel() {
        return this.goAwayStreamSourceChannel;
    }

    private static final class PingKey {
        private final byte[] data;

        private PingKey(byte[] data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PingKey pingKey = (PingKey)o;
            return Arrays.equals(this.data, pingKey.data);
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }

    private class Http2ReceiveListener
    implements ChannelListener<Http2Channel> {
        private Http2ReceiveListener() {
        }

        public void handleEvent(Http2Channel channel) {
            try {
                AbstractHttp2StreamSourceChannel result = (AbstractHttp2StreamSourceChannel)channel.receive();
                if (result instanceof Http2StreamSourceChannel) {
                    Http2StreamSourceChannel streamSourceChannel = (Http2StreamSourceChannel)result;
                    int statusCode = Integer.parseInt(Objects.requireNonNull(streamSourceChannel.getHeaders().getFirst(Http2Channel.STATUS)));
                    Http2ClientExchange request = DoSHttp2ClientConnection.this.currentExchanges.get(streamSourceChannel.getStreamId());
                    if (statusCode < 200) {
                        if (statusCode == 100) {
                            request.setContinueResponse(request.createResponse(streamSourceChannel));
                            streamSourceChannel.getReadSetter().set((ChannelListener)new ContinueReceiveListener(DoSHttp2ClientConnection.this.http2Channel));
                            streamSourceChannel.resumeReads();
                        }
                        Channels.drain((StreamSourceChannel)result, (long)Long.MAX_VALUE);
                        return;
                    }
                    this.handleFinalResponse(channel, request, streamSourceChannel);
                } else if (result instanceof Http2PingStreamSourceChannel) {
                    this.handlePing((Http2PingStreamSourceChannel)result);
                } else if (result instanceof Http2RstStreamStreamSourceChannel) {
                    Http2RstStreamStreamSourceChannel rstStream = (Http2RstStreamStreamSourceChannel)result;
                    int stream = rstStream.getStreamId();
                    UndertowLogger.REQUEST_LOGGER.debugf("Client received RST_STREAM for stream %s", stream);
                    Http2ClientExchange exchange = DoSHttp2ClientConnection.this.currentExchanges.remove(stream);
                    if (exchange != null) {
                        exchange.failed(UndertowMessages.MESSAGES.http2StreamWasReset());
                    }
                    Channels.drain((StreamSourceChannel)result, (long)Long.MAX_VALUE);
                } else if (result instanceof Http2PushPromiseStreamSourceChannel) {
                    Http2PushPromiseStreamSourceChannel stream = (Http2PushPromiseStreamSourceChannel)result;
                    Http2ClientExchange request = DoSHttp2ClientConnection.this.currentExchanges.get(stream.getAssociatedStreamId());
                    if (request == null) {
                        channel.sendGoAway(1);
                    } else if (request.getPushCallback() == null) {
                        channel.sendRstStream(stream.getPushedStreamId(), 7);
                    } else {
                        ClientRequest cr = new ClientRequest();
                        cr.setMethod(new HttpString(stream.getHeaders().getFirst(Http2Channel.METHOD)));
                        cr.setPath(stream.getHeaders().getFirst(Http2Channel.PATH));
                        cr.setProtocol(Protocols.HTTP_1_1);
                        for (HeaderValues header : stream.getHeaders()) {
                            cr.getRequestHeaders().putAll(header.getHeaderName(), (Collection)header);
                        }
                        Http2ClientExchange newExchange = new Http2ClientExchange((ClientConnection)DoSHttp2ClientConnection.this, null, cr);
                        if (!request.getPushCallback().handlePush((ClientExchange)request, (ClientExchange)newExchange)) {
                            channel.sendRstStream(stream.getPushedStreamId(), 7);
                            IoUtils.safeClose((Closeable)stream);
                        } else if (!DoSHttp2ClientConnection.this.http2Channel.addPushPromiseStream(stream.getPushedStreamId())) {
                            channel.sendGoAway(1);
                        } else {
                            DoSHttp2ClientConnection.this.currentExchanges.put(stream.getPushedStreamId(), newExchange);
                        }
                    }
                    Channels.drain((StreamSourceChannel)result, (long)Long.MAX_VALUE);
                } else if (result instanceof Http2GoAwayStreamSourceChannel) {
                    DoSHttp2ClientConnection.this.goAwayStreamSourceChannel = (Http2GoAwayStreamSourceChannel)result;
                    DoSHttp2ClientConnection.this.close();
                } else if (result != null) {
                    Channels.drain((StreamSourceChannel)result, (long)Long.MAX_VALUE);
                }
            }
            catch (Throwable t) {
                this.handleThrowable(t);
            }
        }

        private void handleFinalResponse(Http2Channel channel, Http2ClientExchange request, Http2StreamSourceChannel response) throws IOException {
            response.setTrailersHandler(headerMap -> request.putAttachment(HttpAttachments.REQUEST_TRAILERS, (Object)headerMap));
            response.addCloseTask(channel1 -> DoSHttp2ClientConnection.this.currentExchanges.remove(response.getStreamId()));
            response.setCompletionListener(channel12 -> DoSHttp2ClientConnection.this.currentExchanges.remove(response.getStreamId()));
            if (request == null && DoSHttp2ClientConnection.this.initialUpgradeRequest) {
                Channels.drain((StreamSourceChannel)response, (long)Long.MAX_VALUE);
                DoSHttp2ClientConnection.this.initialUpgradeRequest = false;
                return;
            }
            if (request == null) {
                channel.sendGoAway(1);
                IoUtils.safeClose((Closeable)((Object)DoSHttp2ClientConnection.this));
                return;
            }
            request.responseReady(response);
        }

        private void handlePing(Http2PingStreamSourceChannel frame) {
            byte[] id = frame.getData();
            if (!frame.isAck()) {
                frame.getHttp2Channel().sendPing(id);
            } else {
                ClientConnection.PingListener listener = DoSHttp2ClientConnection.this.outstandingPings.remove(new PingKey(id));
                if (listener != null) {
                    listener.acknowledged();
                }
            }
        }

        private void handleThrowable(Throwable t) {
            IOException e = t instanceof IOException ? (IOException)t : new IOException(t);
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            IoUtils.safeClose((Closeable)((Object)DoSHttp2ClientConnection.this));
            for (Map.Entry<Integer, Http2ClientExchange> entry : DoSHttp2ClientConnection.this.currentExchanges.entrySet()) {
                try {
                    entry.getValue().failed(e);
                }
                catch (Throwable ex) {
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(new IOException(ex));
                }
            }
        }

        private class ContinueReceiveListener
        implements ChannelListener<AbstractHttp2StreamSourceChannel> {
            private final Http2Channel http2Channel;

            ContinueReceiveListener(Http2Channel http2Channel) {
                this.http2Channel = http2Channel;
            }

            public void handleEvent(AbstractHttp2StreamSourceChannel sourceChannel) {
                assert (sourceChannel instanceof Http2StreamSourceChannel);
                try {
                    Http2StreamSourceChannel channel = (Http2StreamSourceChannel)sourceChannel;
                    if (channel.getHeaders().getFirst(Http2Channel.STATUS) == null) {
                        Channels.drain((StreamSourceChannel)channel, (long)Long.MAX_VALUE);
                        if (channel.getHeaders().getFirst(Http2Channel.STATUS) == null) {
                            return;
                        }
                    }
                    int statusCode = Integer.parseInt(Objects.requireNonNull(channel.getHeaders().getFirst(Http2Channel.STATUS)));
                    Http2ClientExchange request = DoSHttp2ClientConnection.this.currentExchanges.get(channel.getStreamId());
                    if (statusCode < 200) {
                        if (statusCode == 100) {
                            request.setContinueResponse(request.createResponse(channel));
                        }
                        Channels.drain((StreamSourceChannel)channel, (long)Long.MAX_VALUE);
                        return;
                    }
                    Http2ReceiveListener.this.handleFinalResponse(this.http2Channel, request, channel);
                }
                catch (Throwable t) {
                    Http2ReceiveListener.this.handleThrowable(t);
                }
            }
        }
    }
}

