/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.Undertow;
import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.client.ALPNClientSelector;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientProvider;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.PushCallback;
import io.undertow.client.http.HttpClientProvider;
import io.undertow.client.http2.Http2ClientConnection;
import io.undertow.connector.ByteBufferPool;
import io.undertow.io.Sender;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.StopServerWithExternalWorkerUtils;
import io.undertow.testutils.category.UnitTest;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.StringReadChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.AccessController;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.ssl.SslConnection;

@Category(value={UnitTest.class})
@RunWith(value=DefaultServer.class)
@Ignore
public class PushResourceRSTTestCase {
    private static final Logger log = Logger.getLogger(PushResourceRSTTestCase.class);
    private static final String PUSHER = "/pusher";
    private static final String PUSHER_MSG;
    private static final String TRIGGER = "/trigger";
    private static XnioWorker worker;
    private static Undertow defaultConfigServer;
    private static final OptionMap DEFAULT_OPTIONS;
    private static URI defaultConfigServerAddress;
    private static volatile Http2ClientConnection clientConnection;
    private IOException exception;
    private static final AttachmentKey<String> RESPONSE_BODY;

    @BeforeClass
    public static void beforeClass() throws Exception {
        int port = DefaultServer.getHostPort("default");
        PathHandler path = new PathHandler().addExactPath(PUSHER, PushResourceRSTTestCase::sendMessage).addExactPath(TRIGGER, exchange -> exchange.getRequestReceiver().receiveFullString((exchange1, message) -> exchange1.getConnection().pushResource(PUSHER, Methods.GET, exchange1.getRequestHeaders())));
        defaultConfigServer = Undertow.builder().addHttpsListener(port + 1, DefaultServer.getHostAddress("default"), DefaultServer.getServerSslContext()).setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true).setServerOption(UndertowOptions.RST_FRAMES_TIME_WINDOW, (Object)5000).setServerOption(UndertowOptions.MAX_RST_FRAMES_PER_WINDOW, (Object)10).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler(arg_0 -> ((PathHandler)path).handleRequest(arg_0)).build();
        defaultConfigServer.start();
        defaultConfigServerAddress = new URI("https://" + DefaultServer.getHostAddress() + ":" + (port + 1));
        worker = Xnio.getInstance().createWorker(null, DEFAULT_OPTIONS);
    }

    @AfterClass
    public static void afterClass() {
        if (defaultConfigServer != null) {
            defaultConfigServer.stop();
        }
        if (worker != null) {
            StopServerWithExternalWorkerUtils.stopWorker(worker);
        }
    }

    static void sendMessage(HttpServerExchange exchange) {
        exchange.setStatusCode(200);
        Sender sender = exchange.getResponseSender();
        sender.send(PUSHER_MSG);
    }

    public static ALPNClientSelector.ALPNProtocol alpnProtocol(ClientCallback<ClientConnection> listener, String defaultHost, ByteBufferPool bufferPool, OptionMap options) {
        return new ALPNClientSelector.ALPNProtocol(connection -> listener.completed((Object)PushResourceRSTTestCase.createHttp2Channel((StreamConnection)connection, bufferPool, options, defaultHost)), "h2");
    }

    private static Http2ClientConnection createHttp2Channel(StreamConnection connection, ByteBufferPool bufferPool, OptionMap options, String defaultHost) {
        Http2Channel http2Channel = new Http2Channel(connection, null, bufferPool, null, true, false, options);
        clientConnection = new Http2ClientConnection(http2Channel, false, defaultHost, null, true);
        return clientConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRstOnPush() throws Exception {
        Assume.assumeFalse((boolean)System.getProperty("os.name").startsWith("Windows"));
        int totalNumberOfRequests = 250;
        CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        CountDownLatch latch = new CountDownLatch(500);
        AtomicInteger pushRstCount = new AtomicInteger(0);
        ServiceLoader providers = AccessController.doPrivileged(() -> ServiceLoader.load(ClientProvider.class, this.getClass().getClassLoader()));
        ClientProvider clientProvider = null;
        block3: for (ClientProvider provider : providers) {
            for (String scheme : provider.handlesSchemes()) {
                if (!scheme.equals(defaultConfigServerAddress.getScheme())) continue;
                clientProvider = provider;
                continue block3;
            }
        }
        Assert.assertNotNull(clientProvider);
        final FutureResult result = new FutureResult();
        ClientCallback<ClientConnection> listener = new ClientCallback<ClientConnection>(){

            public void completed(ClientConnection r) {
                result.setResult((Object)r);
            }

            public void failed(IOException e) {
                result.setException(e);
            }
        };
        UndertowXnioSsl ssl = new UndertowXnioSsl(worker.getXnio(), OptionMap.EMPTY, DefaultServer.getClientSSLContext());
        OptionMap tlsOptions = OptionMap.builder().set(UndertowOptions.ENDPOINT_IDENTIFICATION_ALGORITHM, (Object)(HttpClientProvider.DISABLE_HTTPS_ENDPOINT_IDENTIFICATION ? "" : "HTTPS")).set(Options.SSL_STARTTLS, true).getMap();
        ChannelListener openListener = arg_0 -> PushResourceRSTTestCase.lambda$testRstOnPush$5((ClientCallback)listener, tlsOptions, arg_0);
        ssl.openSslConnection(worker, new InetSocketAddress(defaultConfigServerAddress.getHost(), defaultConfigServerAddress.getPort()), openListener, tlsOptions).addNotifier((arg_0, arg_1) -> PushResourceRSTTestCase.lambda$testRstOnPush$6((ClientCallback)listener, arg_0, arg_1), null);
        ClientConnection connection = (ClientConnection)result.getIoFuture().get();
        try {
            connection.getIoThread().execute(() -> {
                for (int i = 0; i < 250; ++i) {
                    ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(TRIGGER);
                    request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                    connection.sendRequest(request, this.createClientCallback(responses, latch, pushRstCount));
                }
            });
            latch.await(25L, TimeUnit.SECONDS);
            Assert.assertEquals((long)250L, (long)pushRstCount.get());
            Assert.assertNull((Object)this.exception);
            Assert.assertTrue((boolean)clientConnection.isOpen());
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    private ClientCallback<ClientExchange> createClientCallback(final List<ClientResponse> responses, final CountDownLatch latch, final AtomicInteger pushRstCount) {
        return new ClientCallback<ClientExchange>(){

            public void completed(final ClientExchange result) {
                result.setPushHandler(new PushCallback(){

                    public boolean handlePush(ClientExchange originalRequest, ClientExchange pushedRequest) {
                        pushRstCount.incrementAndGet();
                        log.debugf("Handling push %d", pushRstCount.get());
                        latch.countDown();
                        this.setUpResponseListenerAndShutdownWrites(result);
                        return false;
                    }
                });
            }

            public void failed(IOException e) {
                e.printStackTrace();
                PushResourceRSTTestCase.this.exception = e;
                latch.countDown();
            }

            private void setUpResponseListenerAndShutdownWrites(ClientExchange result) {
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(final ClientExchange result) {
                        log.debugf("Got result %s", (Object)result);
                        responses.add(result.getResponse());
                        new StringReadChannelListener(result.getConnection().getBufferPool()){

                            protected void stringDone(String string) {
                                result.getResponse().putAttachment(RESPONSE_BODY, (Object)string);
                                latch.countDown();
                            }

                            protected void error(IOException e) {
                                e.printStackTrace();
                                PushResourceRSTTestCase.this.exception = e;
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    public void failed(IOException e) {
                        e.printStackTrace();
                        PushResourceRSTTestCase.this.exception = e;
                        latch.countDown();
                    }
                });
                try {
                    result.getRequestChannel().shutdownWrites();
                    if (!result.getRequestChannel().flush()) {
                        result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    PushResourceRSTTestCase.this.exception = e;
                    latch.countDown();
                }
            }
        };
    }

    private static /* synthetic */ void lambda$testRstOnPush$6(ClientCallback listener, IoFuture ioFuture, Object o) {
        if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
            listener.failed(ioFuture.getException());
        }
    }

    private static /* synthetic */ void lambda$testRstOnPush$5(ClientCallback listener, OptionMap tlsOptions, StreamConnection connection) {
        ALPNClientSelector.runAlpn((SslConnection)((SslConnection)connection), connection1 -> {
            UndertowLogger.ROOT_LOGGER.alpnConnectionFailed(connection1);
            IoUtils.safeClose((Closeable)connection1);
        }, (ClientCallback)listener, (ALPNClientSelector.ALPNProtocol[])new ALPNClientSelector.ALPNProtocol[]{PushResourceRSTTestCase.alpnProtocol((ClientCallback<ClientConnection>)listener, defaultConfigServerAddress.getHost(), DefaultServer.getBufferPool(), tlsOptions)});
    }

    static {
        RESPONSE_BODY = AttachmentKey.create(String.class);
        OptionMap.Builder builder = OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.TCP_NODELAY, true).set(Options.KEEP_ALIVE, true).set(Options.WORKER_NAME, (Object)"Client");
        DEFAULT_OPTIONS = builder.getMap();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 50000; ++i) {
            sb.append(i).append('\n');
        }
        PUSHER_MSG = sb.toString();
    }
}

