/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.IOException;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@ProxyIgnore
public class StatusLineTestCase {
    private static final String DEFAULT_PROTOCOL_NAME = "HTTP";
    private static final String DEFAULT_PROTOCOL_MAJOR = "1";
    private static final String DEFAULT_PROTOCOL_MINOR = "1";
    private static final String PROTOCOL_NAME = "HTTP";
    private static final String PROTOCOL_MAJOR = "3";
    private static final String PROTOCOL_MINOR = "4";
    private static final String PROTOCOL_STRING = "HTTP/3.4";
    private static final String REASON_PHRASE = "Reason-Phrase";
    private static final String MESSAGE = "My HTTP Request!";
    private static volatile ServerConnection connection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyStatusLine() throws IOException {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (connection == null) {
                    connection = exchange.getConnection();
                } else if (!DefaultServer.isAjp() && !DefaultServer.isProxy() && connection != exchange.getConnection()) {
                    Sender sender = exchange.getResponseSender();
                    sender.send("Connection not persistent");
                    return;
                }
                exchange.setProtocol(new HttpString(StatusLineTestCase.PROTOCOL_STRING));
                exchange.setReasonPhrase(StatusLineTestCase.REASON_PHRASE);
                exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "" + StatusLineTestCase.MESSAGE.length());
                Sender sender = exchange.getResponseSender();
                sender.send(StatusLineTestCase.MESSAGE);
            }
        });
        connection = null;
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
        TestHttpClient client = new TestHttpClient();
        try {
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            ProtocolVersion protocolVersion = result.getStatusLine().getProtocolVersion();
            Assert.assertEquals((Object)"HTTP", (Object)protocolVersion.getProtocol());
            Assert.assertEquals((long)Integer.parseInt(PROTOCOL_MAJOR), (long)protocolVersion.getMajor());
            Assert.assertEquals((long)Integer.parseInt(PROTOCOL_MINOR), (long)protocolVersion.getMinor());
            Assert.assertEquals((Object)REASON_PHRASE, (Object)result.getStatusLine().getReasonPhrase());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyDefaultStatusLine() throws IOException {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (connection == null) {
                    connection = exchange.getConnection();
                } else if (!DefaultServer.isAjp() && !DefaultServer.isProxy() && connection != exchange.getConnection()) {
                    Sender sender = exchange.getResponseSender();
                    sender.send("Connection not persistent");
                    return;
                }
                exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "" + StatusLineTestCase.MESSAGE.length());
                Sender sender = exchange.getResponseSender();
                sender.send(StatusLineTestCase.MESSAGE);
            }
        });
        connection = null;
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
        TestHttpClient client = new TestHttpClient();
        try {
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            ProtocolVersion protocolVersion = result.getStatusLine().getProtocolVersion();
            Assert.assertEquals((Object)"HTTP", (Object)protocolVersion.getProtocol());
            Assert.assertEquals((long)Integer.parseInt("1"), (long)protocolVersion.getMajor());
            Assert.assertEquals((long)Integer.parseInt("1"), (long)protocolVersion.getMinor());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

