/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.CharsetUtil;
import io.undertow.server.HttpHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.util.NetworkUtils;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import io.undertow.websockets.utils.FrameChecker;
import io.undertow.websockets.utils.WebSocketTestClient;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ChannelListener;
import org.xnio.FutureResult;
import org.xnio.OptionMap;
import org.xnio.Options;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
public class WebSocketTimeoutTestCase {
    protected static final int TESTABLE_TIMEOUT_VALUE = 2000;
    protected static final int NON_TESTABLE_TIMEOUT_VALUE = 30180;
    protected static final int DEFAULTS_IO_TIMEOTU_VALUE = 500;
    private ScheduledExecutorService SCHEDULER;

    protected void beforeTest(int regularTimeouts, int wsReadTimeout, int wsWriteTimeout) {
        DefaultServer.stopServer();
        DefaultServer.setServerOptions(OptionMap.builder().set(Options.READ_TIMEOUT, regularTimeouts).set(Options.WRITE_TIMEOUT, regularTimeouts).getMap());
        DefaultServer.setUndertowOptions(OptionMap.builder().set(Options.READ_TIMEOUT, regularTimeouts).set(Options.WRITE_TIMEOUT, regularTimeouts).getMap());
        DefaultServer.startServer();
        this.SCHEDULER = Executors.newScheduledThreadPool(2);
        System.setProperty("io.undertow.websockets.core.read-timeout", "" + wsReadTimeout);
        System.setProperty("io.undertow.websockets.core.write-timeout", "" + wsWriteTimeout);
    }

    @After
    public void afterTest() {
        DefaultServer.stopServer();
        DefaultServer.setServerOptions(OptionMap.EMPTY);
        DefaultServer.setUndertowOptions(OptionMap.EMPTY);
        this.SCHEDULER.shutdown();
        System.clearProperty("io.undertow.websockets.core.read-timeout");
        System.clearProperty("io.undertow.websockets.core.write-timeout");
    }

    protected WebSocketVersion getVersion() {
        return WebSocketVersion.V13;
    }

    @Test
    public void testServerReadTimeout() throws Exception {
        this.beforeTest(500, 2000, 30180);
        final AtomicBoolean connected = new AtomicBoolean(false);
        DefaultServer.setRootHandler((HttpHandler)new WebSocketProtocolHandshakeHandler(new WebSocketConnectionCallback(){

            public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                connected.set(true);
                channel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(){

                    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
                        String string = message.getData();
                        if (string.equals("hello")) {
                            WebSockets.sendText((String)"world", (WebSocketChannel)channel, null);
                        } else {
                            WebSockets.sendText((String)string, (WebSocketChannel)channel, null);
                        }
                    }
                });
                channel.resumeReceives();
            }
        }));
        FutureResult latch = new FutureResult();
        WebSocketTestClient client = new WebSocketTestClient(this.getVersion(), new URI("ws://" + NetworkUtils.formatPossibleIpv6Address((String)DefaultServer.getHostAddress("default")) + ":" + DefaultServer.getHostPort("default") + "/"));
        client.connect();
        client.send((WebSocketFrame)new TextWebSocketFrame(Unpooled.copiedBuffer((CharSequence)"hello", (Charset)CharsetUtil.US_ASCII)), new FrameChecker(TextWebSocketFrame.class, "world".getBytes(CharsetUtil.US_ASCII), latch));
        latch.getIoFuture().get();
        long watchStart = System.currentTimeMillis();
        long watchTimeout = System.currentTimeMillis() + 2000L + 500L;
        FutureResult timeoutLatch = new FutureResult();
        ReadTimeoutChannelGuard readTimeoutChannelGuard = new ReadTimeoutChannelGuard(client, (FutureResult<Long>)timeoutLatch, watchTimeout);
        ScheduledFuture<?> sf = this.SCHEDULER.scheduleAtFixedRate(readTimeoutChannelGuard, 0L, 50L, TimeUnit.MILLISECONDS);
        readTimeoutChannelGuard.setTaskScheduledFuture(sf);
        Long watchTimeEnd = (Long)timeoutLatch.getIoFuture().get();
        if (watchTimeEnd == -1L) {
            Assert.fail((String)("Timeout did not happen... in time. Were waiting '" + watchTimeout + "' ms, timeout should happen in '2000' ms."));
        } else {
            long timeSpent = watchTimeEnd - watchStart;
            if (timeSpent > 2150L) {
                Assert.fail((String)("Timeout did not happen... in time. Socket timeout out in '" + timeSpent + "' ms, supposed to happen in '2000' ms."));
            }
        }
    }

    private static class ReadTimeoutChannelGuard
    implements Runnable {
        private final WebSocketTestClient channel;
        private final FutureResult<Long> resultHandler;
        private final long watchEnd;
        private ScheduledFuture<?> sf;

        ReadTimeoutChannelGuard(WebSocketTestClient channel, FutureResult<Long> resultHandler, long watchEnd) {
            this.channel = channel;
            this.resultHandler = resultHandler;
            this.watchEnd = watchEnd;
        }

        public void setTaskScheduledFuture(ScheduledFuture sf2) {
            this.sf = sf2;
        }

        @Override
        public void run() {
            if (System.currentTimeMillis() > this.watchEnd) {
                this.sf.cancel(false);
                if (this.channelActive()) {
                    this.resultHandler.setResult((Object)new Long(-1L));
                } else {
                    this.resultHandler.setResult((Object)System.currentTimeMillis());
                }
            } else if (!this.channelActive()) {
                this.sf.cancel(false);
                this.resultHandler.setResult((Object)System.currentTimeMillis());
            }
        }

        private boolean channelActive() {
            return this.channel.isOpen();
        }
    }
}

