/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.HPackHuffman;
import io.undertow.protocols.http2.Hpack;
import io.undertow.protocols.http2.HpackException;
import io.undertow.testutils.category.UnitTest;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnitTest.class})
public class HpackHuffmanEncodingUnitTestCase {
    @Test
    public void testHuffmanEncoding() throws HpackException {
        this.runTest("Hello World", ByteBuffer.allocate(100), true);
        this.runTest("Hello World", ByteBuffer.allocate(3), false);
        this.runTest("\\randomSpecialsChars~\u001d", ByteBuffer.allocate(100), true);
        this.runTest("\\~\u001d", ByteBuffer.allocate(100), false);
    }

    @Test
    public void testHuffmanEncodingLargeString() throws HpackException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            sb.append("Hello World");
        }
        this.runTest(sb.toString(), ByteBuffer.allocate(10000), true);
    }

    void runTest(String string, ByteBuffer buffer, boolean bufferBigEnough) throws HpackException {
        boolean res = HPackHuffman.encode((ByteBuffer)buffer, (String)string, (boolean)false);
        if (!bufferBigEnough) {
            Assert.assertFalse((boolean)res);
            return;
        }
        Assert.assertTrue((boolean)res);
        buffer.flip();
        Assert.assertTrue(((0x80 & buffer.get(0)) != 0 ? 1 : 0) != 0);
        int length = Hpack.decodeInteger((ByteBuffer)buffer, (int)7);
        StringBuilder sb = new StringBuilder();
        HPackHuffman.decode((ByteBuffer)buffer, (int)length, (StringBuilder)sb);
        Assert.assertEquals((Object)string, (Object)sb.toString());
    }
}

