/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.URLDecodingHandler;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.PathTemplateMatch;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;

public class URLDecodingHandlerTestCase {
    private static int PORT = 7890;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoesNotDecodeByDefault() throws Exception {
        Undertow undertow = Undertow.builder().addHttpListener(PORT, "0.0.0.0").setHandler((HttpHandler)new URLDecodingHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send(exchange.getRelativePath());
            }
        }, "UTF-8")).build();
        undertow.start();
        try {
            TestHttpClient client = new TestHttpClient();
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet("http://localhost:" + PORT + "/%253E"));){
                Assert.assertEquals((Object)"/%3E", (Object)URLDecodingHandlerTestCase.getResponseString(response));
            }
        }
        finally {
            undertow.stop();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodesWhenUrlDecodingIsDisabled() throws Exception {
        Undertow undertow = Undertow.builder().setServerOption(UndertowOptions.DECODE_URL, (Object)false).addHttpListener(PORT, "0.0.0.0").setHandler((HttpHandler)new URLDecodingHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send(exchange.getRelativePath());
            }
        }, "UTF-8")).build();
        undertow.start();
        try {
            TestHttpClient client = new TestHttpClient();
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet("http://localhost:" + PORT + "/%253E"));){
                Assert.assertEquals((Object)"/%3E", (Object)URLDecodingHandlerTestCase.getResponseString(response));
            }
        }
        finally {
            undertow.stop();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeCharactersInMatchedPaths() throws Exception {
        Undertow undertow = Undertow.builder().setServerOption(UndertowOptions.DECODE_URL, (Object)false).addHttpListener(PORT, "0.0.0.0").setHandler((HttpHandler)new RoutingHandler().get("/api/{pathParam}/tail", (HttpHandler)new URLDecodingHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                String matched = (String)((PathTemplateMatch)exchange.getAttachment(PathTemplateMatch.ATTACHMENT_KEY)).getParameters().get("pathParam");
                exchange.getResponseSender().send(matched);
            }
        }, "UTF-8"))).build();
        undertow.start();
        try {
            TestHttpClient client = new TestHttpClient();
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet("http://localhost:" + PORT + "/api/test%2Ftest+test%2Btest%20test/tail"));){
                Assert.assertEquals((Object)"test/test+test+test test", (Object)URLDecodingHandlerTestCase.getResponseString(response));
            }
        }
        finally {
            undertow.stop();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleURLDecodingHandlers() throws Exception {
        Undertow undertow = Undertow.builder().setServerOption(UndertowOptions.DECODE_URL, (Object)false).addHttpListener(PORT, "0.0.0.0").setHandler((HttpHandler)new URLDecodingHandler((HttpHandler)new URLDecodingHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send(exchange.getRelativePath());
            }
        }, "UTF-8"), "UTF-8")).build();
        undertow.start();
        try {
            TestHttpClient client = new TestHttpClient();
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet("http://localhost:" + PORT + "/%253E"));){
                Assert.assertEquals((Object)"/%3E", (Object)URLDecodingHandlerTestCase.getResponseString(response));
            }
        }
        finally {
            undertow.stop();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static String getResponseString(CloseableHttpResponse response) throws IOException {
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        return HttpClientUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8);
    }
}

