/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.IoUtils;

@RunWith(value=DefaultServer.class)
@ProxyIgnore
@HttpOneOnly
public class ConnectionTerminationTestCase {
    private volatile boolean completionListenerCalled = false;
    private final CountDownLatch completionListenerCalledLatch = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbnormalRequestTermination() throws IOException, InterruptedException {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (exchange.isInIoThread()) {
                    exchange.dispatch((HttpHandler)this);
                    return;
                }
                exchange.startBlocking();
                exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                    public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                        ConnectionTerminationTestCase.this.completionListenerCalled = true;
                        ConnectionTerminationTestCase.this.completionListenerCalledLatch.countDown();
                        nextListener.proceed();
                    }
                });
                InputStream request = exchange.getInputStream();
                String data = FileUtils.readFile((InputStream)request);
                exchange.getOutputStream().write(data.getBytes("UTF-8"));
            }
        });
        Socket socket = new Socket();
        socket.connect(DefaultServer.getDefaultServerAddress());
        try {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 10000; ++i) {
                sb.append("hello world\r\n");
            }
            String request = "POST / HTTP/1.1\r\nHost:localhost\r\nContent-Length:" + sb.length() + "100\r\n\r\n" + sb.toString();
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(request.getBytes("US-ASCII"));
            socket.getInputStream().close();
            outputStream.close();
            this.completionListenerCalledLatch.await(5L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)this.completionListenerCalled);
        }
        finally {
            IoUtils.safeClose((Socket)socket);
        }
    }
}

