/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.utils;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class WebSocketTestClient {
    private final Bootstrap bootstrap = new Bootstrap();
    private Channel ch;
    private final URI uri;
    private final WebSocketVersion version;
    private volatile boolean closed;
    private static final AtomicInteger count = new AtomicInteger();

    public WebSocketTestClient(WebSocketVersion version, URI uri) {
        this.uri = uri;
        this.version = version;
    }

    public WebSocketTestClient connect() throws Exception {
        String protocol = this.uri.getScheme();
        if (!"ws".equals(protocol)) {
            throw new IllegalArgumentException("Unsupported protocol: " + protocol);
        }
        WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)this.uri, (WebSocketVersion)this.version, null, (boolean)false, (HttpHeaders)new DefaultHttpHeaders());
        final WSClientHandler handler = new WSClientHandler(handshaker);
        NioEventLoopGroup group = new NioEventLoopGroup();
        ((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(Channel channel) throws Exception {
                ChannelPipeline p = channel.pipeline();
                p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), handler});
            }
        });
        ChannelFuture future = this.bootstrap.connect((SocketAddress)new InetSocketAddress(this.uri.getHost(), this.uri.getPort()));
        future.syncUninterruptibly();
        handler.handshakeFuture.syncUninterruptibly();
        this.ch = future.channel();
        return this;
    }

    public WebSocketTestClient send(WebSocketFrame frame, final FrameListener listener) {
        this.ch.pipeline().addLast("responseHandler" + count.incrementAndGet(), (ChannelHandler)new SimpleChannelInboundHandler<Object>(){

            protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
                if (msg instanceof CloseWebSocketFrame) {
                    WebSocketTestClient.this.closed = true;
                }
                listener.onFrame((WebSocketFrame)msg);
                ctx.pipeline().remove((ChannelHandler)this);
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                cause.printStackTrace();
                listener.onError(cause);
                ctx.pipeline().remove((ChannelHandler)this);
            }
        });
        ChannelFuture cf = this.ch.writeAndFlush((Object)frame).syncUninterruptibly();
        if (!cf.isSuccess()) {
            listener.onError(cf.cause());
        }
        return this;
    }

    public void destroy() {
        this.destroy(false);
    }

    public void destroy(boolean dirty) {
        if (!this.closed && !dirty) {
            final CountDownLatch latch = new CountDownLatch(1);
            this.send((WebSocketFrame)new CloseWebSocketFrame(), new FrameListener(){

                @Override
                public void onFrame(WebSocketFrame frame) {
                    latch.countDown();
                }

                @Override
                public void onError(Throwable t) {
                    latch.countDown();
                }
            });
            try {
                latch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.ch != null) {
            this.ch.close().syncUninterruptibly();
        }
        try {
            this.bootstrap.group().shutdownGracefully(0L, 1L, TimeUnit.SECONDS).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class WSClientHandler
    extends SimpleChannelInboundHandler<Object> {
        private final WebSocketClientHandshaker handshaker;
        private ChannelPromise handshakeFuture;

        WSClientHandler(WebSocketClientHandshaker handshaker) {
            super(false);
            this.handshaker = handshaker;
        }

        public ChannelFuture handshakeFuture() {
            return this.handshakeFuture;
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            this.handshakeFuture = ctx.newPromise();
        }

        public void channelActive(ChannelHandlerContext ctx) {
            this.handshaker.handshake(ctx.channel());
        }

        protected void channelRead0(ChannelHandlerContext ctx, Object o) throws Exception {
            Channel ch = ctx.channel();
            if (!this.handshaker.isHandshakeComplete()) {
                this.handshaker.finishHandshake(ch, (FullHttpResponse)o);
                this.handshakeFuture.setSuccess();
                ReferenceCountUtil.release((Object)o);
                return;
            }
            if (o instanceof FullHttpResponse) {
                FullHttpResponse response = (FullHttpResponse)o;
                ReferenceCountUtil.release((Object)o);
                throw new Exception("Unexpected HttpResponse (status=" + response.getStatus() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ")");
            }
            ctx.fireChannelRead(o);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            cause.printStackTrace();
            if (!this.handshakeFuture.isDone()) {
                this.handshakeFuture.setFailure(cause);
            }
            ctx.close();
        }
    }

    public static interface FrameListener {
        public void onFrame(WebSocketFrame var1);

        public void onError(Throwable var1);
    }
}

