/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionAttachmentHandler;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Protocols;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DecompressingHttpClient;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.IoUtils;
import org.xnio.XnioWorker;

@RunWith(value=DefaultServer.class)
public abstract class AbstractLoadBalancingProxyTestCase {
    private static final String COUNT = "count";
    public static final String RESPONSE_BODY = "This is a response body";
    protected static Undertow server1;
    protected static Undertow server2;
    private static volatile boolean firstFail;
    protected static final int IDLE_TIMEOUT = 1000;
    private static final AttachmentKey<Boolean> EXISTING;

    @BeforeClass
    public static void setupFailTest() {
        firstFail = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void teardown() {
        XnioWorker worker;
        XnioWorker worker1 = null;
        XnioWorker worker2 = null;
        int countDown = 0;
        try {
            if (server1 != null) {
                worker = server1.getWorker();
                server1.stop();
                if (worker != null && !worker.isShutdown()) {
                    ++countDown;
                    worker1 = worker;
                }
            }
        }
        finally {
            block24: {
                CountDownLatch latch;
                block25: {
                    try {
                        if (server2 != null) {
                            worker = server2.getWorker();
                            server2.stop();
                            if (worker != null && !worker.isShutdown() && worker != worker1) {
                                worker2 = worker;
                                ++countDown;
                            }
                        }
                        if (countDown == 0) break block24;
                        latch = new CountDownLatch(countDown);
                        if (worker1 == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (countDown != 0) {
                            CountDownLatch latch2 = new CountDownLatch(countDown);
                            if (worker1 != null) {
                                worker1.getIoThread().execute(latch2::countDown);
                            }
                            if (worker2 != null) {
                                worker2.getIoThread().execute(latch2::countDown);
                            }
                            try {
                                latch2.await();
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        throw throwable;
                    }
                    worker1.getIoThread().execute(latch::countDown);
                }
                if (worker2 != null) {
                    worker2.getIoThread().execute(latch::countDown);
                }
                try {
                    latch.await();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadShared() throws IOException {
        StringBuilder resultString = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            DecompressingHttpClient client = new DecompressingHttpClient((HttpClient)new TestHttpClient());
            try {
                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/name");
                HttpResponse result = client.execute((HttpUriRequest)get);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                resultString.append(HttpClientUtils.readResponse(result));
                resultString.append(' ');
                continue;
            }
            finally {
                client.getConnectionManager().shutdown();
            }
        }
        Assert.assertTrue((boolean)resultString.toString().contains("server1"));
        Assert.assertTrue((boolean)resultString.toString().contains("server2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbruptClosed() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/close");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)503L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUrlEncoding() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/url/foo=bar");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"/url/foo=bar", (Object)HttpClientUtils.readResponse((HttpResponse)result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @HttpOneOnly
    public void testOldBackend() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            for (int i = 0; i < 10; ++i) {
                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/old");
                CloseableHttpResponse result = client.execute((HttpUriRequest)get);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                Assert.assertEquals((Object)RESPONSE_BODY, (Object)HttpClientUtils.readResponse((HttpResponse)result));
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxRetries() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/fail");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"/fail:false", (Object)HttpClientUtils.readResponse((HttpResponse)result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Test
    public void testLoadSharedWithServerShutdown() throws Exception {
        StringBuilder resultString = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            TestHttpClient client = new TestHttpClient();
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/name");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((String)("Test failed with i=" + i), (long)200L, (long)result.getStatusLine().getStatusCode());
            resultString.append(HttpClientUtils.readResponse((HttpResponse)result));
            resultString.append(' ');
            server1.stop();
            Thread.sleep(600L);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/name");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((String)("Test failed with i=" + i), (long)200L, (long)result.getStatusLine().getStatusCode());
            resultString.append(HttpClientUtils.readResponse((HttpResponse)result));
            resultString.append(' ');
            server1.start();
            server2.stop();
            Thread.sleep(600L);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/name");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((String)("Test failed with i=" + i), (long)200L, (long)result.getStatusLine().getStatusCode());
            resultString.append(HttpClientUtils.readResponse((HttpResponse)result));
            resultString.append(' ');
            server2.start();
        }
        Assert.assertTrue((boolean)resultString.toString().contains("server1"));
        Assert.assertTrue((boolean)resultString.toString().contains("server2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStickySessions() throws IOException {
        int expected = 0;
        TestHttpClient client = new TestHttpClient();
        try {
            for (int i = 0; i < 6; ++i) {
                try {
                    HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/session");
                    get.addHeader("Connection", "close");
                    CloseableHttpResponse result = client.execute((HttpUriRequest)get);
                    Assert.assertEquals((String)("Test failed with i=" + i), (long)200L, (long)result.getStatusLine().getStatusCode());
                    int count = Integer.parseInt(HttpClientUtils.readResponse((HttpResponse)result));
                    Assert.assertEquals((long)expected++, (long)count);
                    continue;
                }
                catch (AssertionError e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new AssertionError("Test failed with i=" + i, e);
                }
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateHeaders() throws IOException {
        int expected = 0;
        TestHttpClient client = new TestHttpClient();
        try {
            for (int i = 0; i < 6; ++i) {
                try {
                    HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/session");
                    get.addHeader("a", "b");
                    get.addHeader("a", "b");
                    get.addHeader("a", "b");
                    get.addHeader("a", "b");
                    get.addHeader("a", "b");
                    get.addHeader("a", "b");
                    get.addHeader("a", "b");
                    get.addHeader("a", "b");
                    get.addHeader("Connection", "close");
                    CloseableHttpResponse result = client.execute((HttpUriRequest)get);
                    Assert.assertEquals((String)("Test failed with i=" + i), (long)200L, (long)result.getStatusLine().getStatusCode());
                    int count = Integer.parseInt(HttpClientUtils.readResponse((HttpResponse)result));
                    Assert.assertEquals((String)("Test failed with i=" + i), (long)expected++, (long)count);
                    continue;
                }
                catch (AssertionError e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new AssertionError("Test failed with i=" + i, e);
                }
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionTimeout() throws Exception {
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/timeout");
        get.addHeader("Connection", "close");
        CloseableHttpResponse result = client.execute((HttpUriRequest)get);
        boolean res = Boolean.parseBoolean(HttpClientUtils.readResponse((HttpResponse)result));
        Assert.assertEquals((Object)false, (Object)res);
        try {
            for (int i = 0; i < 20; ++i) {
                result = client.execute((HttpUriRequest)get);
                HttpClientUtils.readResponse((HttpResponse)result);
            }
            result = client.execute((HttpUriRequest)get);
            res = Boolean.parseBoolean(HttpClientUtils.readResponse((HttpResponse)result));
            Thread.sleep(2000L);
            UndertowLogger.ROOT_LOGGER.info((Object)"Sending timed out request");
            result = client.execute((HttpUriRequest)get);
            res = Boolean.parseBoolean(HttpClientUtils.readResponse((HttpResponse)result));
            Assert.assertEquals((Object)false, (Object)res);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    protected static HttpHandler getRootHandler(String s1, String server1) {
        SessionCookieConfig sessionConfig = new SessionCookieConfig();
        return Handlers.jvmRoute((String)"JSESSIONID", (String)s1, (HttpHandler)Handlers.path().addPrefixPath("/session", (HttpHandler)new SessionAttachmentHandler((HttpHandler)new SessionTestHandler(sessionConfig), (SessionManager)new InMemorySessionManager(""), (SessionConfig)sessionConfig)).addPrefixPath("/name", (HttpHandler)new StringSendHandler(server1)).addPrefixPath("/url", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send(exchange.getRequestURI());
            }
        }).addPrefixPath("/path", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send(exchange.getRequestURI());
            }
        }).addPrefixPath("/fail", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (firstFail) {
                    firstFail = false;
                    IoUtils.safeClose((Closeable)exchange.getConnection());
                    return;
                }
                exchange.getResponseSender().send(exchange.getRequestURI() + ":" + firstFail);
            }
        }).addPrefixPath("/timeout", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (exchange.getConnection().getAttachment(EXISTING) == null) {
                    exchange.getConnection().putAttachment(EXISTING, (Object)true);
                    exchange.getResponseSender().send("false");
                } else {
                    exchange.getResponseSender().send("true");
                }
            }
        }).addPrefixPath("/close", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                IoUtils.safeClose((Closeable)exchange.getConnection());
            }
        }).addPrefixPath("/old", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (exchange.isInIoThread()) {
                    exchange.dispatch((HttpHandler)this);
                    return;
                }
                exchange.startBlocking();
                exchange.setProtocol(Protocols.HTTP_1_0);
                exchange.getOutputStream().write(AbstractLoadBalancingProxyTestCase.RESPONSE_BODY.getBytes(StandardCharsets.US_ASCII));
                exchange.getOutputStream().flush();
            }
        }));
    }

    static {
        firstFail = true;
        EXISTING = AttachmentKey.create(Boolean.class);
    }

    protected static final class StringSendHandler
    implements HttpHandler {
        private final String serverName;

        protected StringSendHandler(String serverName) {
            this.serverName = serverName;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.getResponseSender().send(this.serverName);
        }
    }

    protected static final class SessionTestHandler
    implements HttpHandler {
        private final SessionCookieConfig sessionConfig;

        protected SessionTestHandler(SessionCookieConfig sessionConfig) {
            this.sessionConfig = sessionConfig;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            SessionManager manager = (SessionManager)exchange.getAttachment(SessionManager.ATTACHMENT_KEY);
            Session session = manager.getSession(exchange, (SessionConfig)this.sessionConfig);
            if (session == null) {
                session = manager.createSession(exchange, (SessionConfig)this.sessionConfig);
                session.setAttribute(AbstractLoadBalancingProxyTestCase.COUNT, (Object)0);
            }
            Integer count = (Integer)session.getAttribute(AbstractLoadBalancingProxyTestCase.COUNT);
            session.setAttribute(AbstractLoadBalancingProxyTestCase.COUNT, (Object)(count + 1));
            exchange.getResponseSender().send("" + count);
        }
    }
}

