/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet;

import io.undertow.servlet.api.DeploymentManager;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Path;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="UT")
public interface UndertowServletMessages {
    public static final UndertowServletMessages MESSAGES = Messages.getBundle(UndertowServletMessages.class);

    @Message(id=10000, value="%s cannot be null")
    public IllegalArgumentException paramCannotBeNull(String var1);

    @Message(id=10001, value="%s cannot be null for %s named %s")
    public IllegalArgumentException paramCannotBeNull(String var1, String var2, String var3);

    @Message(id=10002, value="Deployments can only be removed when in undeployed state, but state was %s")
    public IllegalStateException canOnlyRemoveDeploymentsWhenUndeployed(DeploymentManager.State var1);

    @Message(id=10003, value="Cannot call getInputStream(), getReader() already called")
    public IllegalStateException getReaderAlreadyCalled();

    @Message(id=10004, value="Cannot call getReader(), getInputStream() already called")
    public IllegalStateException getInputStreamAlreadyCalled();

    @Message(id=10005, value="Cannot call getOutputStream(), getWriter() already called")
    public IllegalStateException getWriterAlreadyCalled();

    @Message(id=10006, value="Cannot call getWriter(), getOutputStream() already called")
    public IllegalStateException getOutputStreamAlreadyCalled();

    @Message(id=10007, value="Two servlets specified with same mapping %s")
    public IllegalArgumentException twoServletsWithSameMapping(String var1);

    @Message(id=10008, value="Header %s cannot be converted to a date")
    public IllegalArgumentException headerCannotBeConvertedToDate(String var1);

    @Message(id=10009, value="Servlet %s of type %s does not implement jakarta.servlet.Servlet")
    public IllegalArgumentException servletMustImplementServlet(String var1, Class<? extends Servlet> var2);

    @Message(id=10010, value="%s of type %s must have a default constructor")
    public IllegalArgumentException componentMustHaveDefaultConstructor(String var1, Class<?> var2);

    @Message(id=10011, value="Filter %s of type %s does not implement jakarta.servlet.Filter")
    public IllegalArgumentException filterMustImplementFilter(String var1, Class<? extends Filter> var2);

    @Message(id=10012, value="Listener class %s must implement at least one listener interface")
    public IllegalArgumentException listenerMustImplementListenerClass(Class<?> var1);

    @Message(id=10013, value="Could not instantiate %s")
    public ServletException couldNotInstantiateComponent(String var1, @Cause Exception var2);

    @Message(id=10014, value="Could not load class %s")
    public RuntimeException cannotLoadClass(String var1, @Cause Exception var2);

    @Message(id=10015, value="Could not delete file %s")
    public IOException deleteFailed(Path var1);

    @Message(id=10016, value="Not a multi part request")
    public ServletException notAMultiPartRequest();

    @Message(id=10018, value="Async not started")
    public IllegalStateException asyncNotStarted();

    @Message(id=10019, value="Response already commited")
    public IllegalStateException responseAlreadyCommited();

    @Message(id=10020, value="Content has been written")
    public IllegalStateException contentHasBeenWritten();

    @Message(id=10021, value="Path %s must start with a /")
    public MalformedURLException pathMustStartWithSlash(String var1);

    @Message(id=10022, value="Session is invalid")
    public IllegalStateException sessionIsInvalid();

    @Message(id=10023, value="Request %s was not original or a wrapper")
    public IllegalArgumentException requestWasNotOriginalOrWrapper(ServletRequest var1);

    @Message(id=10024, value="Response %s was not original or a wrapper")
    public IllegalArgumentException responseWasNotOriginalOrWrapper(ServletResponse var1);

    @Message(id=10025, value="Async request already dispatched")
    public IllegalStateException asyncRequestAlreadyDispatched();

    @Message(id=10026, value="Async is not supported for this request, as not all filters or Servlets were marked as supporting async")
    public IllegalStateException startAsyncNotAllowed();

    @Message(id=10027, value="Not implemented")
    public IllegalStateException notImplemented();

    @Message(id=10028, value="Async processing already started")
    public IllegalStateException asyncAlreadyStarted();

    @Message(id=10029, value="Stream is closed")
    public IOException streamIsClosed();

    @Message(id=10030, value="User already logged in")
    public ServletException userAlreadyLoggedIn();

    @Message(id=10031, value="Login failed")
    public ServletException loginFailed();

    @Message(id=10032, value="Authenticationfailed")
    public ServletException authenticationFailed();

    @Message(id=10033, value="No session")
    public IllegalStateException noSession();

    @Message(id=10034, value="Stream not in async mode")
    public IllegalStateException streamNotInAsyncMode();

    @Message(id=10035, value="Stream in async mode was not ready for IO operation")
    public IllegalStateException streamNotReady();

    @Message(id=10036, value="Listener has already been set")
    public IllegalStateException listenerAlreadySet();

    @Message(id=10038, value="No web socket handler was provided to the web socket servlet")
    public ServletException noWebSocketHandler();

    @Message(id=10039, value="Unknown authentication mechanism %s")
    public RuntimeException unknownAuthenticationMechanism(String var1);

    @Message(id=10040, value="More than one default error page %s and %s")
    public IllegalStateException moreThanOneDefaultErrorPage(String var1, String var2);

    @Message(id=10041, value="The servlet context has already been initialized, you can only call this method from a ServletContainerInitializer or a ServletContextListener")
    public IllegalStateException servletContextAlreadyInitialized();

    @Message(id=10042, value="This method cannot be called from a servlet context listener that has been added programatically")
    public UnsupportedOperationException cannotCallFromProgramaticListener();

    @Message(id=10043, value="Cannot add servlet context listener from a programatically added listener")
    public IllegalArgumentException cannotAddServletContextListener();

    @Message(id=10044, value="listener cannot be null")
    public NullPointerException listenerCannotBeNull();

    @Message(id=10045, value="SSL cannot be combined with any other method")
    public IllegalArgumentException sslCannotBeCombinedWithAnyOtherMethod();

    @Message(id=10046, value="No servlet context at %s to dispatch to")
    public IllegalArgumentException couldNotFindContextToDispatchTo(String var1);

    @Message(id=10047, value="Name was null")
    public NullPointerException nullName();

    @Message(id=10048, value="Can only handle HTTP type of request / response: %s / %s")
    public IllegalArgumentException invalidRequestResponseType(ServletRequest var1, ServletResponse var2);

    @Message(id=10049, value="Async request already returned to container")
    public IllegalStateException asyncRequestAlreadyReturnedToContainer();

    @Message(id=10050, value="Filter %s used in filter mapping %s not found")
    public IllegalStateException filterNotFound(String var1, String var2);

    @Message(id=10051, value="Deployment %s has stopped")
    public ServletException deploymentStopped(String var1);

    @Message(id=10052, value="Header name was null")
    public NullPointerException headerNameWasNull();

    @Message(id=10053, value="No confidential port is available to redirect the current request.")
    public IllegalStateException noConfidentialPortAvailable();

    @Message(id=10054, value="Unable to create an instance factory for %s")
    public RuntimeException couldNotCreateFactory(String var1, @Cause Exception var2);

    @Message(id=10055, value="Listener is not started")
    public IllegalStateException listenerIsNotStarted();

    @Message(id=10056, value="path was not set")
    public IllegalStateException pathWasNotSet();

    @Message(id=10057, value="multipart config was not present on Servlet")
    public IllegalStateException multipartConfigNotPresent();

    @Message(id=10058, value="Servlet name cannot be null")
    public IllegalArgumentException servletNameNull();

    @Message(id=10059, value="Param %s cannot be null")
    public NullPointerException paramCannotBeNullNPE(String var1);

    @Message(id=10060, value="Trailers not supported for this request due to %s")
    public IllegalStateException trailersNotSupported(String var1);

    @Message(id=10061, value="Invalid method for push request %s")
    public IllegalArgumentException invalidMethodForPushRequest(String var1);

    @Message(id=10062, value="No SecurityContext available")
    public ServletException noSecurityContextAvailable();

    @Message(id=10063, value="Path %s must start with a / to get the request dispatcher")
    public IllegalArgumentException pathMustStartWithSlashForRequestDispatcher(String var1);

    @Message(id=10064, value="Servlet context for context path '%s' in deployment '%s' has already been initialized, can not declare roles.")
    public IllegalStateException servletAlreadyInitialize(String var1, String var2);

    @Message(id=10065, value="Can not set empty/null role in servlet context for context path '%s' in deployment '%s' ")
    public IllegalArgumentException roleMustNotBeEmpty(String var1, String var2);

    @Message(id=10066, value="Can not set invoke 'declareRoles' from dynamic listener in servlet context for context path '%s' in deployment '%s' ")
    public UnsupportedOperationException cantCallFromDynamicListener(String var1, String var2);
}

