/*
 * Decompiled with CFR 0.152.
 */
package jakarta.websocket;

import jakarta.websocket.CloseReason$CloseCode;
import java.io.UnsupportedEncodingException;

public class CloseReason {
    private final CloseReason$CloseCode closeCode;
    private final String reasonPhrase;

    public CloseReason(CloseReason$CloseCode closeCode, String reasonPhrase) {
        if (closeCode == null) {
            throw new IllegalArgumentException("closeCode cannot be null");
        }
        try {
            if (reasonPhrase != null && reasonPhrase.getBytes("UTF-8").length > 123) {
                throw new IllegalArgumentException("Reason Phrase cannot exceed 123 UTF-8 encoded bytes: " + reasonPhrase);
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(uee);
        }
        this.closeCode = closeCode;
        this.reasonPhrase = "".equals(reasonPhrase) ? null : reasonPhrase;
    }

    public CloseReason$CloseCode getCloseCode() {
        return this.closeCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase == null ? "" : this.reasonPhrase;
    }

    public String toString() {
        return this.reasonPhrase == null ? "CloseReason[" + this.closeCode.getCode() + "]" : "CloseReason[" + this.closeCode.getCode() + "," + this.reasonPhrase + "]";
    }
}

