/*
 * Decompiled with CFR 0.152.
 */
package jakarta.websocket;

import jakarta.websocket.ContainerProvider$1;
import jakarta.websocket.WebSocketContainer;
import java.security.AccessController;
import java.util.Iterator;
import java.util.ServiceLoader;

public abstract class ContainerProvider {
    public static WebSocketContainer getWebSocketContainer() {
        if (System.getSecurityManager() == null) {
            return ContainerProvider.getWebSocketContainerImpl();
        }
        return AccessController.doPrivileged(new ContainerProvider$1());
    }

    private static WebSocketContainer getWebSocketContainerImpl() {
        Iterator<ContainerProvider> providers = ServiceLoader.load(ContainerProvider.class).iterator();
        if (providers.hasNext()) {
            do {
                ContainerProvider impl;
                WebSocketContainer wsc;
                if ((wsc = (impl = providers.next()).getContainer()) == null) continue;
                return wsc;
            } while (providers.hasNext());
            throw new RuntimeException("Could not find an implementation class with a non-null WebSocketContainer.");
        }
        throw new RuntimeException("Could not find an implementation class.");
    }

    protected abstract WebSocketContainer getContainer();

    static /* synthetic */ WebSocketContainer access$000() {
        return ContainerProvider.getWebSocketContainerImpl();
    }
}

