/*
 * Decompiled with CFR 0.152.
 */
package jakarta.websocket.server;

import jakarta.websocket.Decoder;
import jakarta.websocket.Encoder;
import jakarta.websocket.Extension;
import jakarta.websocket.server.DefaultServerEndpointConfig;
import jakarta.websocket.server.ServerEndpointConfig;
import jakarta.websocket.server.ServerEndpointConfig$Configurator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ServerEndpointConfig$Builder {
    private String path;
    private Class<?> endpointClass;
    private List<String> subprotocols = Collections.emptyList();
    private List<Extension> extensions = Collections.emptyList();
    private List<Class<? extends Encoder>> encoders = Collections.emptyList();
    private List<Class<? extends Decoder>> decoders = Collections.emptyList();
    private ServerEndpointConfig$Configurator serverEndpointConfigurator;

    public static ServerEndpointConfig$Builder create(Class<?> endpointClass, String path) {
        return new ServerEndpointConfig$Builder(endpointClass, path);
    }

    private ServerEndpointConfig$Builder() {
    }

    public ServerEndpointConfig build() {
        return new DefaultServerEndpointConfig(this.endpointClass, this.path, this.subprotocols, this.extensions, this.encoders, this.decoders, this.serverEndpointConfigurator);
    }

    private ServerEndpointConfig$Builder(Class<?> endpointClass, String path) {
        if (endpointClass == null) {
            throw new IllegalArgumentException("endpointClass cannot be null");
        }
        this.endpointClass = endpointClass;
        if (path == null || !path.startsWith("/")) {
            throw new IllegalStateException("Path cannot be null and must begin with /");
        }
        this.path = path;
    }

    public ServerEndpointConfig$Builder encoders(List<Class<? extends Encoder>> encoders) {
        this.encoders = encoders == null ? new ArrayList() : encoders;
        return this;
    }

    public ServerEndpointConfig$Builder decoders(List<Class<? extends Decoder>> decoders) {
        this.decoders = decoders == null ? new ArrayList() : decoders;
        return this;
    }

    public ServerEndpointConfig$Builder subprotocols(List<String> subprotocols) {
        this.subprotocols = subprotocols == null ? new ArrayList() : subprotocols;
        return this;
    }

    public ServerEndpointConfig$Builder extensions(List<Extension> extensions) {
        this.extensions = extensions == null ? new ArrayList() : extensions;
        return this;
    }

    public ServerEndpointConfig$Builder configurator(ServerEndpointConfig$Configurator serverEndpointConfigurator) {
        this.serverEndpointConfigurator = serverEndpointConfigurator;
        return this;
    }
}

